/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class SQLComboxModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private String _connName = null;
    private Connection _conn = null;
    private ConnectionTypeDetails _connTypeDetails = null;
    private String _sql = null;
    private List<?> _binds = null;
    private Map<String, Object> _namedBinds = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean _delayLoad = false;
    private Boolean _loaded = null;
    private String _defaultObject;
    private ArrayList<ArrayList<Object>> _values = new ArrayList();
    private boolean _loading = false;
    private Boolean m_raiseError = null;
    Vector<Object> objects = new Vector();
    Object selectedObject;

    public SQLComboxModel(Connection connection, String string, List<?> list, String string2) {
        this._conn = connection;
        this._sql = string;
        this._binds = list;
        this.setDefaultObject(string2);
        this._connName = Connections.getInstance().getConnectionName(this._conn);
        this.setConnectionTypeDetails();
    }

    public SQLComboxModel(String string, String string2, List<?> list, String string3) {
        this(string, string2);
        this._binds = list;
        this.setDefaultObject(string3);
    }

    public SQLComboxModel(String string, String string2, Map<String, Object> map, String string3) {
        this(string, string2);
        this._namedBinds = map;
        this.setDefaultObject(string3);
    }

    public SQLComboxModel(String string, String string2) {
        this._connName = string;
        try {
            this._conn = Connections.getInstance().getConnection(this._connName);
        }
        catch (DBException dBException) {
            this.logger.severe(Messages.getString("SQLComboxModel.0") + dBException.getMessage());
        }
        this.setConnectionTypeDetails();
        this._sql = string2;
    }

    private void setConnectionTypeDetails() {
        ObjectFactory objectFactory = ObjectFactory.getFactory(this._connName, this._conn);
        this._connTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this._loaded == null) {
            ResultSetWrapper resultSetWrapper = null;
            DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
            if (this.m_raiseError != null) {
                dBUtil.setRaiseError(this.m_raiseError.booleanValue());
            }
            this._loading = true;
            Object object = this.getSelectedItem();
            try {
                Connections.getInstance().lock(this._conn);
                resultSetWrapper = this._namedBinds == null ? dBUtil.executeQuery(this._sql, this._binds) : dBUtil.executeQuery(this._sql, this._namedBinds);
                ResultSet resultSet = resultSetWrapper.getResultSet();
                int n = 500;
                if (this._connTypeDetails != null) {
                    n = this._connTypeDetails.getPreferredFetchSize();
                }
                try {
                    resultSet.setFetchSize(n);
                }
                catch (SQLWarning sQLWarning) {
                    this.logger.warning(Messages.getString("SQLComboxModel.3"));
                }
                while (resultSet != null && resultSet.next()) {
                    if (this._defaultObject != null && this._defaultObject.equals(resultSet.getString(1))) continue;
                    String string = resultSet.getString(1);
                    this.addDistinctElement(string);
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                        arrayList.add(resultSet.getObject(i));
                    }
                    this.addValue(arrayList);
                }
                this._loaded = true;
            }
            catch (Exception exception) {
                this.logger.severe(Messages.getString("SQLComboxModel.4") + exception.getMessage());
            }
            finally {
                this.setSelectedItem(object);
                if (this._loaded == null) {
                    this._loaded = false;
                }
                this._loading = false;
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(this._conn);
            }
        }
    }

    private void addValue(ArrayList<Object> arrayList) {
        this._values.add(arrayList);
    }

    public Object getValueAtIndex(int n, int n2) {
        return this._values.get(n).get(n2);
    }

    @Override
    public int getSize() {
        if (!this._delayLoad && !this._loading) {
            this.load();
        }
        return this._loaded == null ? 20 : this.objects.size();
    }

    @Override
    public Object getElementAt(int n) {
        if (!this._delayLoad && !this._loading) {
            this.load();
        }
        return this._loading || this._loaded == null ? this.convertToElement("") : this.fetch(n);
    }

    private Object fetch(int n) {
        if (n >= 0 && n < this.objects.size()) {
            return this.objects.elementAt(n);
        }
        return null;
    }

    public void setDelayed(boolean bl) {
        this._delayLoad = bl;
    }

    public void setDefaultObject(String string) {
        if (string != null) {
            this._defaultObject = string;
            this.addElement(this._defaultObject);
            this.setSelectedItem(this._defaultObject);
        }
    }

    public String getDefaultObject() {
        return this._defaultObject;
    }

    protected Object convertToElement(Object object) {
        return object;
    }

    public void addElement(Object object) {
        this.objects.addElement(object);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
    }

    protected void addDistinctElement(Object object) {
        if (!this.contains(object)) {
            this.addElement(object);
        }
    }

    public void insertElementAt(Object object, int n) {
        this.objects.insertElementAt(object, n);
        this.fireIntervalAdded(this, n, n);
    }

    @Override
    public void removeElement(Object object) {
        int n = this.objects.indexOf(object);
        if (n != -1) {
            this.removeElementAt(n);
        }
    }

    @Override
    public void removeElementAt(int n) {
        if (this.getElementAt(n) == this.selectedObject) {
            if (n == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(n + 1));
            } else {
                this.setSelectedItem(this.getElementAt(n - 1));
            }
        }
        this.objects.removeElementAt(n);
        this.fireIntervalRemoved(this, n, n);
    }

    protected boolean contains(Object object) {
        return this.objects.contains(object);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSecondaryValueAtIndex(int n) {
        return null;
    }

    public void setRaiseError(Boolean bl) {
        this.m_raiseError = bl;
    }

    public Boolean isLoaded() {
        return this._loaded;
    }
}

