/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.db.xml.Predicate;
import oracle.dbtools.raptor.navigator.db.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.dbtools.raptor.query.QueryProgressListener;

public class ObjectQueryInstance {
    private Query m_query;
    private boolean m_matchAny;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Map<String, Object> m_reqValues = new HashMap<String, Object>();
    private List<QueryAttributeInstance> m_args = new ArrayList<QueryAttributeInstance>();
    private QueryAttributeInstance m_schemaNameFilter;

    public ObjectQueryInstance(String string, Query query) {
        this.m_query = query;
    }

    public void setMatchAny(boolean bl) {
        this.m_matchAny = bl;
    }

    public void setRequiredValue(String string, Object object) {
        this.m_reqValues.put(string, object);
    }

    public void addOptionalArgument(QueryAttributeInstance queryAttributeInstance) {
        this.m_args.add(queryAttributeInstance);
    }

    public void setSchemaFilter(QueryAttributeInstance queryAttributeInstance) {
        this.m_schemaNameFilter = queryAttributeInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Map<String, Object>> executeQuery(Connection connection, QueryProgressListener queryProgressListener) throws SQLException, AbortException {
        ArrayList arrayList = new ArrayList();
        ResultSetWrapper resultSetWrapper = null;
        long l = System.currentTimeMillis();
        try {
            ObjectFactory objectFactory = ObjectFactory.getFactory(null, connection);
            Map<String, Object> map = objectFactory.getGlobalBindMap();
            String string = this.generateSQL(map);
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            resultSetWrapper = dBUtil.executeQuery(string, map);
            if (resultSetWrapper != null) {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                ConnectionTypeDetails connectionTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
                Integer n = connectionTypeDetails.getPreferredFetchSize();
                if (n != null) {
                    resultSet.setFetchSize(n);
                }
                if (queryProgressListener != null) {
                    queryProgressListener.rsOpened();
                }
                List list = this.m_query.getCols();
                while (resultSet.next()) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new AbortException("ObjectQueryInstance.executeQuery");
                    }
                    if (queryProgressListener != null) {
                        queryProgressListener.rsRowFetched();
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Object object = null;
                    int n2 = resultSetMetaData.getColumnCount();
                    for (int i = 1; i <= n2; ++i) {
                        Object object2 = resultSet.getObject(i);
                        if (i == 1) {
                            object = object2;
                        }
                        hashMap.put(resultSetMetaData.getColumnName(i), object2);
                    }
                    for (Object object2 : list) {
                        String string2 = object2.getID();
                        String string3 = object2.getName();
                        Object v = hashMap.get(string3);
                        if (v == null) continue;
                        hashMap.put(string2, v);
                    }
                    if (list.size() == 0 && !hashMap.containsKey("NAME")) {
                        hashMap.put("NAME", object);
                    }
                    this.logger.finer(DatabaseNavigatorResources.format("OQI_LOAD_MSG", hashMap.get("NAME")));
                    arrayList.add(hashMap);
                }
            } else {
                SQLException sQLException = dBUtil.getLastException();
                if (sQLException != null) {
                    throw sQLException;
                }
            }
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(DatabaseNavigatorResources.format("OQI_ELAPSED_TIME_MSG", System.currentTimeMillis() - l));
        }
        return arrayList.iterator();
    }

    private String generateSQL(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder(this.m_query.getSql());
        String string = !this.m_query.isConstrained() ? " WHERE " : " AND ";
        for (Map.Entry<String, Object> object2 : this.m_reqValues.entrySet()) {
            map.put(object2.getKey(), object2.getValue());
        }
        if (this.m_schemaNameFilter != null) {
            stringBuilder.append(string);
            String string2 = this.bindAttribute(this.m_schemaNameFilter, map);
            stringBuilder.append(this.m_schemaNameFilter.getSQLFragment(string2));
            string = " AND ";
        }
        for (QueryAttributeInstance queryAttributeInstance : this.m_args) {
            if (queryAttributeInstance.getPredicate() != Predicate.COMPLEX) continue;
            String string2 = this.bindAttribute(queryAttributeInstance, map);
            stringBuilder.append(string);
            stringBuilder.append(queryAttributeInstance.getSQLFragment(string2));
            string = " AND ";
        }
        int n = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        for (QueryAttributeInstance queryAttributeInstance : this.m_args) {
            if (queryAttributeInstance.getPredicate() == Predicate.COMPLEX) continue;
            String string3 = this.bindAttribute(queryAttributeInstance, map);
            if (n > 0) {
                stringBuilder2.append(this.m_matchAny ? " OR " : " AND ");
            }
            stringBuilder2.append(queryAttributeInstance.getSQLFragment(string3));
            ++n;
        }
        if (n > 0) {
            stringBuilder.append(string);
            if (this.m_matchAny && n > 1) {
                stringBuilder.append("(");
            }
            stringBuilder.append(stringBuilder2.toString());
            if (this.m_matchAny && n > 1) {
                stringBuilder.append(")");
            }
            string = " AND ";
        }
        return stringBuilder.toString();
    }

    private String bindAttribute(QueryAttributeInstance queryAttributeInstance, Map<String, Object> map) {
        QueryParameter queryParameter = queryAttributeInstance.getAttribute();
        String string = queryParameter.getName();
        if (queryParameter instanceof Column) {
            string = ((Column)queryParameter).getID();
        }
        String string2 = ObjectQueryInstance.findUniqueName(string, map.keySet());
        String[] stringArray = queryAttributeInstance.getValues();
        int n = stringArray != null ? stringArray.length : 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                map.put(string2, stringArray != null && stringArray.length > 0 ? stringArray[0] : null);
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    map.put(string2 + "_" + i, stringArray[i]);
                }
            }
        }
        return string2;
    }

    private static String findUniqueName(String string, Set<String> set) {
        if (!set.contains(string)) {
            return string;
        }
        for (int i = 0; i < 1000; ++i) {
            String string2 = string + i;
            if (set.contains(string2)) continue;
            return string2;
        }
        return string;
    }
}

