/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.db.EditableTypesRegistry;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public abstract class AbstractDBViewController
implements Controller {
    public static final String DATABASE_KEY = "Database";
    public static final String DB_EDITOR_FACTORY_KEY = "DBEditorFactory";
    public static final String OBJECT_TYPE_KEY = "DBObjectType";
    private static final String EDIT_OBJECT_CMD = "DatabaseNavigator.EditObject";
    public static final int EDIT_OBJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.EditObject");
    private static final String NEW_OBJECT_CMD = "DatabaseNavigator.NewObject";
    public static final int NEW_OJBECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewObject");
    private static final String FILTER_CMD = "DatabaseNavigator.FILTER";
    public static final int FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.FILTER");
    private static final String GLOBAL_FILTER_CMD = "DatabaseNavigator.FILTER_ALL";
    public static final int GLOBAL_FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.FILTER_ALL");
    private static final String CLEAR_FILTER_CMD = "DatabaseNavigator.CLEAR_FILTER";
    public static final int CLEAR_FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CLEAR_FILTER");
    private static final String NEW_CONN_CMD = "DatabaseNavigator.NewConnection";
    public static final int NEW_DBCONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewConnection");
    private static final String NEW_CONN_CHILD_CMD = "DatabaseNavigator.NewDBConnection";
    static final int NEW_CONN_CHILD_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewDBConnection");
    private static final String OPEN_CMD = "DatabaseNavigator.CONNECT";
    public static final int OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CONNECT");
    private static final String CLOSE_CMD = "DatabaseNavigator.DISCONNECT";
    public static final int CLOSE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DISCONNECT");
    private static final String REOPEN_CMD = "DatabaseNavigator.RECONNECT";
    public static final int REOPEN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RECONNECT");
    private static final String NEW_CLOUD_CONN_CMD = "Cloud.NewCloudConnection";
    public static final int NEW_CLOUD_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"Cloud.NewCloudConnection");
    protected static Map<String, Database> s_databases = new HashMap<String, Database>();
    private final View m_view;

    public static Database getDatabase(String string) {
        Database database = s_databases.get(string);
        if (database == null) {
            try {
                database = Connections.getInstance().getDatabase(string);
                s_databases.put(string, database);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return database;
    }

    protected static boolean canEditObject(DatabaseNode databaseNode) {
        DBObject dBObject;
        String string = (String)databaseNode.getProperty("TYPE");
        if (EditableTypesRegistry.canEditType(string) && PermissionRegistry.canAlter(dBObject = new DBObject(databaseNode))) {
            return DBEditorFactoryRegistry.getEditFactory((DBObjectNode)databaseNode) != null;
        }
        return false;
    }

    private static SchemaObject getSchemaObject(Database database, DatabaseNode databaseNode) throws DBException {
        String string = (String)databaseNode.getProperty("API_NAME");
        if (string == null) {
            string = (String)databaseNode.getProperty("NAME");
        }
        return database.getObject((String)databaseNode.getProperty("TYPE"), database.getSchema((String)databaseNode.getProperty("SCHEMA")), string);
    }

    protected static void updateAction(IdeAction ideAction, DBObject dBObject, Database database, String string, DBEditorFactory dBEditorFactory) {
        String string2 = dBEditorFactory.getCreateLabel(string);
        ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string2));
        ideAction.putValue("MnemonicKey", (Object)StringUtils.getMnemonicKeyCode((String)string2));
        ideAction.putValue("SmallIcon", (Object)DBTypeDisplayRegistry.getNodeIcon((String)string));
        ideAction.putValueDirectly(OBJECT_TYPE_KEY, (Object)string);
        ideAction.putValueDirectly(DATABASE_KEY, (Object)database);
        ideAction.putValueDirectly(DB_EDITOR_FACTORY_KEY, (Object)dBEditorFactory);
        ideAction.putValueDirectly("ObjectAction.DBOBJECT", (Object)dBObject);
    }

    public static void closeEditors(Node node) {
        List list = EditorManager.getEditorManager().getAllEditors();
        Editor editor = null;
        Node node2 = null;
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (int i = 0; i < list.size(); ++i) {
            editor = (Editor)list.get(i);
            node2 = editor.getContext().getNode();
            if (node2 instanceof IViewerNode) {
                node2 = ((IViewerNode)node2).getBaseNode();
            }
            if (node2 != node) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openCodeEditorForNode(Node node) {
        Context context;
        EditorManager editorManager = EditorManager.getEditorManager();
        Context context2 = null;
        for (Object object : editorManager.getAllEditors()) {
            context = ((Editor)object).getContext();
            Node node2 = context != null ? context.getNode() : null;
            if (node2 != node) continue;
            context2 = context;
        }
        WaitCursor waitCursor = null;
        if (context2 == null) {
            waitCursor = new WaitCursor((Component)Ide.getMainWindow());
            context2 = Context.newIdeContext((Node)node);
        }
        if (waitCursor != null) {
            waitCursor.show();
        }
        try {
            Object object;
            object = new OpenEditorOptions(context2, CodeEditor.class);
            context = (CodeEditor)editorManager.openEditor(object);
            context.setCaretPosition(0);
        }
        finally {
            if (waitCursor != null) {
                waitCursor.hide();
            }
        }
    }

    protected AbstractDBViewController(View view) {
        this.m_view = view;
    }

    protected final View getOwningView() {
        return this.m_view;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        View view = context.getView();
        if (view == this.m_view) {
            int n = ideAction.getCommandId();
            if (n == EDIT_OBJECT_CMD_ID) {
                this.editObject(ideAction, context);
                bl = true;
            } else if (n == NEW_OJBECT_CMD_ID) {
                this.createObject(ideAction, context);
                bl = true;
            }
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        View view = context.getView();
        if (view == this.m_view) {
            Element element = context.getElement();
            int n = ideAction.getCommandId();
            if (n == EDIT_OBJECT_CMD_ID) {
                if (element instanceof TextNode) {
                    ideAction.setEnabled(true);
                } else if (element instanceof DatabaseNode) {
                    ideAction.setEnabled(AbstractDBViewController.canEditObject((DatabaseNode)element));
                }
                bl = true;
            }
        }
        return bl;
    }

    protected final void createObject(IdeAction ideAction, Context context) {
        String string = (String)ideAction.getValue(OBJECT_TYPE_KEY);
        final String string2 = string.startsWith("PUBLIC") ? string.substring(7) : string;
        final Database database = (Database)ideAction.getValue(DATABASE_KEY);
        final DBEditorFactory dBEditorFactory = (DBEditorFactory)ideAction.getValue(DB_EDITOR_FACTORY_KEY);
        final String string3 = database.getQualifiedName();
        final DBObject dBObject = (DBObject)ideAction.getValue("ObjectAction.DBOBJECT");
        if (dBEditorFactory != null) {
            DeferUIOperationTask deferUIOperationTask = new DeferUIOperationTask(DatabaseNavigatorResources.getString("CREATE_DATABASE_OBJECT")){

                @Override
                public String getConnectionName() {
                    return string3;
                }

                @Override
                protected void invokeLater() {
                    String string = dBObject != null ? dBObject.getSchemaName() : null;
                    DBEditorConfig dBEditorConfig = DBEditorConfig.newCreateConfig((DBObjectProvider)database, (String)string2, (Schema)new Schema(string));
                    dBEditorFactory.launchDialog(dBEditorConfig);
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)deferUIOperationTask);
        }
    }

    protected final void editObject(IdeAction ideAction, Context context) {
        DatabaseNode databaseNode;
        Node node = context.getNode();
        if (node instanceof TextNode) {
            AbstractDBViewController.openCodeEditorForNode(node);
        } else if (node instanceof DatabaseNode && AbstractDBViewController.canEditObject(databaseNode = (DatabaseNode)node)) {
            Database database = (Database)ideAction.getValue(DATABASE_KEY);
            try {
                SchemaObject schemaObject = AbstractDBViewController.getSchemaObject(database, databaseNode);
                if (schemaObject == null) {
                    throw new DBException(null, "Cannot load object");
                }
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database);
                DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectProvider)database, (oracle.javatools.db.DBObject)schemaObject);
                dBEditorFactory.launchDialog(dBEditorConfig);
                if (dBEditorConfig.getResult() == DBEditorConfig.Result.SUCCESS) {
                    this.refreshParent(context);
                }
            }
            catch (DBException dBException) {
                ExceptionHandler.handleException((Throwable)dBException);
            }
        }
    }

    protected abstract void refreshNode(Context var1);

    protected abstract void refreshParent(Context var1);
}

