/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.util.EventObject;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.navigator.ContextSupport;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.ConnectionStores;
import oracle.dbtools.raptor.navigator.db.CoreDBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBTreeUpdater;
import oracle.dbtools.raptor.navigator.db.DBViewControllerImpl;
import oracle.dbtools.raptor.navigator.db.UIUpdater;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ideri.util.Product;

public class DBNavigatorWindow
extends CoreDBNavigatorWindow {
    private static Class<? extends ContextSupport> s_supportClass;
    private static ContextSupport s_ctxSupport;

    public static void setContextSupportClass(Class<? extends ContextSupport> clazz) {
        s_supportClass = clazz;
    }

    protected static ContextSupport getContextSupport() {
        if (s_ctxSupport == null) {
            if (s_supportClass != null) {
                try {
                    s_ctxSupport = s_supportClass.newInstance();
                }
                catch (Exception exception) {
                    Logger.severe(DBNavigatorWindow.class, (Throwable)exception);
                }
            }
            if (s_ctxSupport == null) {
                s_ctxSupport = new DefaultContextSupport();
            }
        }
        return s_ctxSupport;
    }

    public static Project getProject(String string) {
        return DBNavigatorWindow.getContextSupport().getProject(string);
    }

    public static Workspace getWorkspace() {
        return DBNavigatorWindow.getContextSupport().getWorkspace();
    }

    protected DBNavigatorWindow(ViewId viewId) {
        super(viewId);
        this.setSearchAreaVisible(false);
        this.setType(32);
    }

    @Override
    public String getTitleName() {
        return DatabaseNavigatorResources.getString(RaptorExtensionConstants.isStandAlone() ? "STANDALONE_NAVIGATOR_LABEL" : "PACKAGED_NAVIGATOR_LABEL");
    }

    @Override
    protected Element getRootElement() {
        return ConnectionStores.s_instance;
    }

    @Override
    protected boolean isRootVisible() {
        return false;
    }

    @Override
    protected Controller createController() {
        return new ViewController();
    }

    @Override
    protected void initCustomItemsImpl() {
        DBNavigatorWindow.getContextSupport().attach(this);
        if (!RaptorExtensionConstants.isStandAlone()) {
            NavigatorTree navigatorTree = this.getTree();
            navigatorTree.setShowRootHandles(true);
        }
    }

    @Override
    protected UIUpdater getTreeUpdater() {
        return new DBTreeUpdater("sqldev.nav", this);
    }

    @Override
    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        DBNavigatorWindow.getContextSupport().updateContext(context);
        return context;
    }

    public int getDefaultVisibility(Layout layout) {
        return RaptorExtensionConstants.isStandAlone() ? 1 : 0;
    }

    @Override
    public boolean canCollapse(NavigatorTreeNode navigatorTreeNode) {
        Element element;
        NavigatorTree navigatorTree = this.getTree();
        NavigatorTreeNode navigatorTreeNode2 = navigatorTree.getRoot();
        if (navigatorTreeNode2 == navigatorTreeNode) {
            return false;
        }
        if (RaptorExtensionConstants.isStandAlone() && (element = navigatorTreeNode.getElement()) instanceof Databases) {
            return !"IdeConnections".equals(((Databases)element).getStoreId());
        }
        return true;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_databaseconnections_html");
    }

    @Override
    public String getTreeID() {
        return !Product.isRaptor() ? "nav-DatabaseNavigatorManager" : super.getTreeID();
    }

    private static class DefaultContextSupport
    extends ContextSupport {
        private DefaultContextSupport() {
        }

        @Override
        public Project getProject(String string) {
            Project project = Ide.getActiveProject();
            if (project == null) {
                project = Ide.getDefaultProject();
            }
            return project;
        }

        @Override
        public Workspace getWorkspace() {
            Workspace workspace = Ide.getActiveWorkspace();
            if (workspace == null) {
                workspace = Ide.getDefaultWorkspace();
            }
            return workspace;
        }

        @Override
        public void attach(NavigatorWindow navigatorWindow) {
        }

        @Override
        public void updateContext(Context context) {
        }
    }

    private class ViewController
    implements Controller {
        private final Controller[] m_controllers;

        ViewController() {
            this.m_controllers = new Controller[]{new DBViewControllerImpl(DBNavigatorWindow.this), CloudController.getInstance()};
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            for (Controller controller : this.m_controllers) {
                if (!controller.handleEvent(ideAction, context)) continue;
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            for (Controller controller : this.m_controllers) {
                if (!controller.update(ideAction, context)) continue;
                return true;
            }
            return false;
        }
    }
}

