/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaResource;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Util;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;

public class NavigatorHook {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-navigator";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-navigator", "sqldev-navigator-hook");
    private static final String DESCRIPTOR_ID = "descriptor";
    private static final String DESCRIPTOR_PKG = "descriptorPkg";
    private static final String DESCRIPTOR_TEXT = "#text";
    private static final String TYPE_TEXT = "navigatorType";
    public static final String DB_NAV_TYPE = "sqldev.nav";
    private static Map<String, NavigatorHook> s_registries = new HashMap<String, NavigatorHook>();
    private List<NavigatorDescriptor> s_descriptors = new CopyOnWriteArrayList<NavigatorDescriptor>();
    private HashStructureHookListener s_listener;
    private String m_type;

    public static synchronized NavigatorHook getHookInstance(String string) {
        NavigatorHook navigatorHook = s_registries.get(string);
        if (navigatorHook == null) {
            navigatorHook = new NavigatorHook(string);
            s_registries.put(string, navigatorHook);
        }
        return navigatorHook;
    }

    private NavigatorHook(String string) {
        this.m_type = string;
    }

    public void registerURL(URL uRL) {
        ClassLoader classLoader = NavigatorHook.class.getClassLoader();
        this.processURL(uRL, classLoader);
    }

    synchronized void registerDescriptor(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = URLFactory.newFileURL((File)new File(string));
        }
        if (uRL != null) {
            this.processURL(uRL, NavigatorHook.class.getClassLoader());
        } else {
            Logger.warn(NavigatorHook.class, (String)("Could not add Actions:" + string));
        }
    }

    private synchronized void initListener() {
        if (this.s_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            this.s_listener = new Listener();
            hashStructureHook.addHashStructureHookListener(this.s_listener);
            for (String object : DBConfig.getInstance().getExtensions("NAVIGATOR")) {
                this.registerDescriptor(object);
            }
            URL uRL = Util.getUserExtensionsDirectory();
            if (uRL != null) {
                for (URL uRL2 : FileUtils.getFilesInPath((URL[])new URL[]{uRL}, (String)"xml")) {
                    this.processURL(uRL2, NavigatorHook.class.getClassLoader());
                }
            }
        }
    }

    public Iterator<NavigatorDescriptor> getNavigatorDescriptors() {
        this.initListener();
        return this.s_descriptors.iterator();
    }

    public Iterator<ConnectionType> getConnectionTypes() {
        Set<ConnectionType> set = this.fetchConnectionTypes();
        return set.iterator();
    }

    public ConnectionType getConnectionType(ConnectionInfo connectionInfo) {
        String string = connectionInfo.getConnectionType();
        Version version = connectionInfo.getVersion();
        return this.getConnectionType(string, version);
    }

    public ConnectionType getConnectionType(String string) {
        return this.getConnectionType(string, null);
    }

    private ConnectionType getConnectionType(String string, Version version) {
        Set<ConnectionType> set = this.fetchConnectionTypes();
        ConnectionType connectionType = null;
        for (ConnectionType connectionType2 : set) {
            if (ModelUtil.areEqual((Object)connectionType2.getType(), (Object)string)) {
                ConnectionTypeDetails connectionTypeDetails = connectionType2.getImpl();
                Version version2 = connectionTypeDetails.getMinimumVersion();
                Version version3 = connectionTypeDetails.getMaximumVersion();
                if (version != null && (version2 != null && version2.compareTo((Object)version) > 0 || version3 != null && version3.compareTo((Object)version) < 0)) continue;
                return connectionType2;
            }
            if (!RaptorExtensionConstants.isStandAlone() || !connectionType2.getType().equals("JDBC")) continue;
            connectionType = connectionType2;
        }
        if (connectionType != null && RaptorExtensionConstants.isStandAlone()) {
            return connectionType;
        }
        return null;
    }

    private Set<ConnectionType> fetchConnectionTypes() {
        TreeSet<ConnectionType> treeSet = new TreeSet<ConnectionType>(new TypeComparator());
        Iterator<NavigatorDescriptor> iterator = this.getNavigatorDescriptors();
        while (iterator.hasNext()) {
            NavigatorDescriptor navigatorDescriptor = iterator.next();
            Iterator<ConnectionType> iterator2 = navigatorDescriptor.getConnectionTypes();
            while (iterator2.hasNext()) {
                treeSet.add(iterator2.next());
            }
        }
        return treeSet;
    }

    private void processURL(URL uRL, ClassLoader classLoader) {
        NavigatorDescriptor navigatorDescriptor = this.createDescriptor(uRL, classLoader);
        if (navigatorDescriptor != null) {
            this.s_descriptors.add(navigatorDescriptor);
        } else {
            Logger.info(NavigatorHook.class, (String)MessageFormat.format("Failed to process {0} as a navigator XML file (not necessarily an error).", uRL.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigatorDescriptor createDescriptor(URL uRL, ClassLoader classLoader) {
        NavigatorDescriptor navigatorDescriptor = null;
        InputStream inputStream = null;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            inputStream = uRL.openStream();
            dOMParser.parse(inputStream);
            XMLDocument xMLDocument = dOMParser.getDocument();
            if (xMLDocument != null) {
                navigatorDescriptor = NavigatorDescriptor.createDescriptor(this.m_type, xMLDocument, classLoader);
            }
        }
        catch (Exception exception) {
            Logger.warn(NavigatorHook.class, (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return navigatorDescriptor;
    }

    private static class TypeComparator
    implements Comparator<ConnectionType> {
        private TypeComparator() {
        }

        @Override
        public int compare(ConnectionType connectionType, ConnectionType connectionType2) {
            return connectionType == connectionType2 ? 0 : connectionType.getType().compareTo(connectionType2.getType());
        }
    }

    private final class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processDescriptors(HashStructure hashStructure) {
            Object object;
            List list = hashStructure.getAsList(NavigatorHook.DESCRIPTOR_PKG);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    object = LazyResourceAdapter.getInstance((HashStructure)hashStructure2).getMetaResource(NavigatorHook.DESCRIPTOR_TEXT);
                    Logger.severe(NavigatorHook.class, (String)MessageFormat.format("Unsupported {0} found: {1}", NavigatorHook.DESCRIPTOR_PKG, object.getResourcePath()));
                }
            }
            if ((list = hashStructure.getAsList(NavigatorHook.DESCRIPTOR_ID)) != null) {
                for (HashStructure hashStructure2 : list) {
                    MetaResource metaResource;
                    URL uRL;
                    object = hashStructure2.getString(NavigatorHook.TYPE_TEXT, NavigatorHook.DB_NAV_TYPE);
                    if (!ModelUtil.areEqual((Object)object, (Object)NavigatorHook.this.m_type) || (uRL = (metaResource = LazyResourceAdapter.getInstance((HashStructure)hashStructure2).getMetaResource(NavigatorHook.DESCRIPTOR_TEXT)).toURL()) == null) continue;
                    NavigatorHook.this.processURL(uRL, metaResource.getClassLoader());
                }
            }
        }
    }
}

