/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderOwner;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.ide.model.Element;
import oracle.javatools.util.Version;
import oracle.xml.parser.v2.XMLNode;

class XmlCategoryType
extends XmlFolderOwner
implements ObjectCategory {
    private final String m_category;
    private final DatabaseFolder m_folder;
    private final Version m_minVer;
    private final Version m_maxVer;
    private final Set<String> m_reqObjects;
    private final Set<String> m_reqFeatures;
    private final Set<String> m_reqLicenses;
    private final boolean m_ignoreComparator;

    XmlCategoryType(String string, String string2, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        super(string, navigatorDescriptor, xMLNode);
        this.m_category = string2;
        DatabaseFolder[] databaseFolderArray = this.getFoldersImpl();
        this.m_folder = databaseFolderArray.length > 0 ? databaseFolderArray[0] : null;
        String string3 = XmlNavigatorUtils.getAttributeValue("", "minversion", xMLNode);
        this.m_minVer = string3 != null ? new Version(string3) : null;
        String string4 = XmlNavigatorUtils.getAttributeValue("", "maxversion", xMLNode);
        this.m_maxVer = string4 != null ? new Version(string4) : null;
        this.m_reqObjects = this.parseSet(xMLNode, "requiredAccessObjects");
        this.m_reqFeatures = this.parseSet(xMLNode, "requiredFeatures");
        this.m_reqLicenses = this.parseSet(xMLNode, "requiredLicenses");
        this.m_ignoreComparator = XmlFolderImpl.parseIgnoreComparator(xMLNode);
    }

    Set<String> parseSet(XMLNode xMLNode, String string) {
        Set<String> set;
        String string2 = XmlNavigatorUtils.getAttributeValue("", string, xMLNode);
        if (string2 != null) {
            set = new HashSet();
            Collections.addAll(set, string2.split(","));
        } else {
            set = Collections.emptySet();
        }
        return set;
    }

    @Override
    public String getType() {
        return this.m_category;
    }

    @Override
    boolean isIncludesSynonyms() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.m_folder != null ? this.m_folder.getLabel() : "";
    }

    @Override
    public Icon getIcon() {
        return this.m_folder != null ? this.m_folder.getIcon() : null;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        return null;
    }

    Version getMinimumVersion() {
        return this.m_minVer;
    }

    Version getMaximumVersion() {
        return this.m_maxVer;
    }

    Set<String> getRequiredObjects() {
        return Collections.unmodifiableSet(this.m_reqObjects);
    }

    Set<String> getRequiredFeatures() {
        return Collections.unmodifiableSet(this.m_reqFeatures);
    }

    Set<String> getRequiredLicenses() {
        return Collections.unmodifiableSet(this.m_reqLicenses);
    }
}

