/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.db.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.db.xml.XmlDBObject;
import oracle.dbtools.raptor.navigator.db.xml.XmlDatabaseItem;
import oracle.dbtools.raptor.navigator.db.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectType;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLNode;

public class XmlNodeImpl
extends XmlDatabaseItem
implements XmlDBObject,
NavigatorXmlElements {
    private XmlObjectType m_type;
    private List<XmlChildImpl> m_childTypes = new ArrayList<XmlChildImpl>();
    private String m_nodeClassName;
    private Class<? extends Element> m_nodeClass;
    private String m_implClassName;
    private Class<? extends DatabaseObject> m_implClass;
    private String m_instClassName;
    private Class<? extends DBObjectInstance> m_instClass;

    public XmlNodeImpl(XmlObjectType xmlObjectType, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        super(xMLNode, navigatorDescriptor, xmlObjectType.getType());
        this.m_type = xmlObjectType;
        this.m_nodeClassName = XmlNavigatorUtils.getAttributeValue("", "nodeClass", xMLNode);
        this.m_implClassName = XmlNavigatorUtils.getAttributeValue("", "itemClass", xMLNode);
        this.m_instClassName = XmlNavigatorUtils.getAttributeValue("", "instanceClass", xMLNode);
        XMLNode[] xMLNodeArray = XmlNavigatorUtils.getElements("childType", xMLNode);
        if (xMLNodeArray != null) {
            for (XMLNode xMLNode2 : xMLNodeArray) {
                String string = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode2);
                if (string == null) continue;
                this.m_childTypes.add(new XmlChildImpl(string, navigatorDescriptor, xmlObjectType.getType(), xMLNode2));
            }
        }
    }

    @Override
    public ChildType[] getChildTypes() {
        return this.m_childTypes.toArray(new ChildType[0]);
    }

    @Override
    public DatabaseItem getChildType(String string) {
        return this.getChildTypeImpl(string);
    }

    private XmlChildImpl getChildTypeImpl(String string) {
        for (XmlChildImpl xmlChildImpl : this.m_childTypes) {
            if (!ModelUtil.areEqual((Object)string, (Object)xmlChildImpl.getChildType())) continue;
            return xmlChildImpl;
        }
        return null;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        if (this.m_nodeClass == null && this.m_nodeClassName != null) {
            try {
                this.m_nodeClass = Class.forName(this.m_nodeClassName, true, this.getDescriptor().getDescriptorClassLoader()).asSubclass(Element.class);
                assert (DatabaseNode.class.isAssignableFrom(this.m_nodeClass));
                DBNavigatorManager.registerDatabaseNodeSubtype(this.m_type.getType(), this.m_nodeClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_nodeClass;
    }

    Class<? extends DatabaseObject> getDBObjectImplementationClass() {
        if (this.m_implClass == null && this.m_implClassName != null) {
            try {
                this.m_implClass = Class.forName(this.m_implClassName, true, this.getDescriptor().getDescriptorClassLoader()).asSubclass(DatabaseObject.class);
                assert (DatabaseObject.class.isAssignableFrom(this.m_implClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_implClass;
    }

    @Override
    public Class<? extends DBObjectInstance> getDBObjectInstanceClass() {
        if (this.m_instClass == null && this.m_instClassName != null) {
            try {
                this.m_instClass = Class.forName(this.m_instClassName, true, this.getDescriptor().getDescriptorClassLoader()).asSubclass(DBObjectInstance.class);
                assert (DBObjectInstance.class.isAssignableFrom(this.m_instClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_instClass;
    }

    @Override
    public Class<? extends FilterChildProvider> getChildProvider(String string) {
        XmlChildImpl xmlChildImpl = this.getChildTypeImpl(string);
        return xmlChildImpl != null ? xmlChildImpl.getProviderImpl() : null;
    }
}

