/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.filter;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.xml.Predicate;
import oracle.dbtools.raptor.navigator.db.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.navigator.filter.FilterDateEditPanel;
import oracle.dbtools.raptor.navigator.filter.FilterDetails;
import oracle.dbtools.raptor.navigator.filter.FilterResources;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class FilterEntryPanel
extends JPanel {
    private static final String NULL_PANEL_KEY = "null";
    private static final String NORMAL_PANEL_KEY = "normal";
    private static final String BETWEEN_PANEL_KEY = "between";
    private JComboBox m_cmbName = new JComboBox();
    private JComboBox m_cmbPred = new JComboBox();
    private GridLayout m_layout = new GridLayout();
    private JPanel m_pnlValues = new JPanel();
    private CardLayout m_layoutValues = new CardLayout();
    private JPanel m_pnlNull = new JPanel();
    private JPanel m_pnlNormal = new JPanel();
    private JPanel m_pnlBetween = new JPanel();
    private GridBagLayout m_layoutBetween = new GridBagLayout();
    private JTextField m_fldNormal = new JTextField();
    private GridBagLayout m_layoutNormal = new GridBagLayout();
    private JTextField m_fldLower = new JTextField();
    private JLabel m_lblBetween = new JLabel();
    private JTextField m_fldUpper = new JTextField();
    private JCheckBox m_chkCase = new JCheckBox();
    private L m_listener = new L();
    private Map<String, QueryParameter> m_paramMap = new HashMap<String, QueryParameter>();
    private String m_type = "<UNINITIALIZED>";
    private FilterDetails m_details;
    private JButton m_dateButton;
    private JButton m_dateLowerButton;
    private JButton m_dateUpperButton;

    public FilterEntryPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void init(FilterDetails filterDetails, QueryAttributeInstance queryAttributeInstance, List<QueryParameter> list) {
        Object object;
        Object object22;
        this.m_details = filterDetails;
        Object[] objectArray = new String[list.size()];
        int n = 0;
        for (Object object22 : list) {
            object = object22.getName();
            if (object22 instanceof Column) {
                object = ((Column)object22).getID();
            }
            this.m_paramMap.put((String)object, (QueryParameter)object22);
            objectArray[n++] = object;
        }
        this.m_cmbName.setModel(new NonNullableComboBoxModel(objectArray));
        QueryParameter queryParameter = queryAttributeInstance.getAttribute();
        object22 = queryParameter.getName();
        if (queryParameter instanceof Column) {
            object22 = ((Column)queryParameter).getID();
        }
        this.m_cmbName.setSelectedItem(object22);
        this.nameChanged();
        object = queryAttributeInstance.getPredicate();
        this.m_cmbPred.setSelectedItem(object);
        this.predicateChanged();
        String[] stringArray = queryAttributeInstance.getValues();
        if (stringArray != null) {
            if (object == Predicate.BETWEEN || object == Predicate.NOT_BETWEEN) {
                assert (stringArray.length == 2);
                this.m_fldLower.setText(stringArray[0]);
                this.m_fldUpper.setText(stringArray[1]);
            } else if (object != Predicate.NULL && object != Predicate.NOT_NULL && object != Predicate.COMPLEX) {
                this.m_fldNormal.setText(stringArray[0]);
            }
        }
        this.m_chkCase.setSelected(!this.m_chkCase.isEnabled() || queryAttributeInstance.isCaseSensitive());
    }

    public QueryAttributeInstance commit() throws TraversalException {
        String[] stringArray;
        String string = (String)this.m_cmbName.getSelectedItem();
        QueryParameter queryParameter = this.m_paramMap.get(string);
        Predicate predicate = (Predicate)((Object)this.m_cmbPred.getSelectedItem());
        boolean bl = false;
        if (predicate == Predicate.NULL || predicate == Predicate.NOT_NULL) {
            stringArray = new String[]{};
        } else if (predicate == Predicate.BETWEEN || predicate == Predicate.NOT_BETWEEN) {
            String string2 = this.m_fldLower.getText();
            String string3 = this.m_fldUpper.getText();
            boolean bl2 = false;
            if (ModelUtil.hasLength((String)string2)) {
                if (!ModelUtil.hasLength((String)string3)) {
                    bl2 = true;
                }
            } else if (ModelUtil.hasLength((String)string3)) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (bl2) {
                throw new TraversalException(DatabaseNavigatorResources.getString("FILTER_MISSING_BOUNDS"));
            }
            stringArray = new String[]{string2, string3};
        } else if ("COMPLEX_PREDICATE".equals(queryParameter.getType())) {
            stringArray = new String[]{};
        } else {
            String string4 = this.m_fldNormal.getText();
            if (!ModelUtil.hasLength((String)string4)) {
                bl = true;
            }
            stringArray = new String[]{string4};
        }
        return !bl ? new QueryAttributeInstance(queryParameter, predicate, stringArray, !this.m_chkCase.isEnabled() || this.m_chkCase.isSelected()) : null;
    }

    Component getDefaultFocusComponent() {
        Predicate predicate = (Predicate)((Object)this.m_cmbPred.getSelectedItem());
        switch (predicate) {
            case COMPLEX: {
                return this.m_cmbName;
            }
            case NULL: 
            case NOT_NULL: {
                return this.m_cmbPred;
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                return this.m_fldLower;
            }
        }
        return this.m_fldNormal;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_layout.setColumns(4);
        this.m_layout.setHgap(5);
        this.m_cmbName.addItemListener(this.m_listener);
        this.m_cmbName.getAccessibleContext().setAccessibleName(FilterResources.getString("NAME_CRITERIA"));
        this.m_cmbPred.addItemListener(this.m_listener);
        this.m_cmbPred.getAccessibleContext().setAccessibleName(FilterResources.getString("NAME_PREDICATE"));
        this.m_pnlValues.setLayout(this.m_layoutValues);
        this.m_pnlNormal.setLayout(this.m_layoutNormal);
        this.m_pnlBetween.setLayout(this.m_layoutBetween);
        this.m_lblBetween.setText(FilterResources.getString("LABEL_AND"));
        this.m_fldNormal.getAccessibleContext().setAccessibleName(FilterResources.getString("NAME_VALUE"));
        this.m_fldLower.getAccessibleContext().setAccessibleName(FilterResources.getString("NAME_LOWER_BOUND"));
        this.m_fldUpper.getAccessibleContext().setAccessibleName(FilterResources.getString("NAME_UPPER_BOUND"));
        this.m_chkCase.setText(FilterResources.getString("LABEL_CASE_SENSITIVE"));
        this.add((Component)this.m_cmbName, null);
        this.add((Component)this.m_cmbPred, null);
        this.m_pnlValues.add((Component)this.m_pnlNull, NULL_PANEL_KEY);
        this.m_pnlNormal.add((Component)this.m_fldNormal, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_dateButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_dateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterDateEditPanel filterDateEditPanel = new FilterDateEditPanel(null);
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)filterDateEditPanel, (Component)filterDateEditPanel.getDefaultComponent(), (String)ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)filterDateEditPanel, filterDateEditPanel.getHelpTopicId());
                jEWTDialog.setResizable(true);
                if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                    try {
                        FilterEntryPanel.this.m_fldNormal.setText(filterDateEditPanel.getValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            }
        });
        this.m_dateLowerButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_dateLowerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterDateEditPanel filterDateEditPanel = new FilterDateEditPanel(null);
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)filterDateEditPanel, (Component)filterDateEditPanel.getDefaultComponent(), (String)ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)filterDateEditPanel, filterDateEditPanel.getHelpTopicId());
                jEWTDialog.setResizable(true);
                if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                    try {
                        FilterEntryPanel.this.m_fldLower.setText(filterDateEditPanel.getValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            }
        });
        this.m_dateUpperButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_dateUpperButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterDateEditPanel filterDateEditPanel = new FilterDateEditPanel(null);
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)filterDateEditPanel, (Component)filterDateEditPanel.getDefaultComponent(), (String)ControlsArb.getString("RESULTSET_EDIT_VALUE_TITLE"));
                HelpSystem.getHelpSystem().registerTopic((JComponent)filterDateEditPanel, filterDateEditPanel.getHelpTopicId());
                jEWTDialog.setResizable(true);
                if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                    try {
                        FilterEntryPanel.this.m_fldUpper.setText(filterDateEditPanel.getValue());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            }
        });
        this.m_pnlNormal.add((Component)this.m_dateButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlValues.add((Component)this.m_pnlNormal, NORMAL_PANEL_KEY);
        this.m_pnlBetween.add((Component)this.m_fldLower, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBetween.add((Component)this.m_dateLowerButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBetween.add((Component)this.m_lblBetween, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.m_pnlBetween.add((Component)this.m_fldUpper, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBetween.add((Component)this.m_dateUpperButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlValues.add((Component)this.m_pnlBetween, BETWEEN_PANEL_KEY);
        this.add((Component)this.m_pnlValues, null);
        this.add((Component)this.m_chkCase, null);
    }

    private void nameChanged() {
        String string = (String)this.m_cmbName.getSelectedItem();
        if (string != null) {
            QueryParameter queryParameter = this.m_paramMap.get(string);
            String string2 = queryParameter.getType();
            this.updateDateSelectButton(string2);
            if (ModelUtil.areDifferent((Object)string2, (Object)this.m_type)) {
                Set<Predicate> set;
                this.m_type = string2;
                Predicate predicate = (Predicate)((Object)this.m_cmbPred.getSelectedItem());
                this.m_cmbPred.setEnabled(true);
                this.m_fldNormal.setEnabled(true);
                boolean bl = false;
                if ("NUMBER".equals(string2)) {
                    set = this.m_details.getSupportedPredicates(FilterDetails.TypeCategory.NUMBER);
                } else if ("DATE".equals(string2)) {
                    set = this.m_details.getSupportedPredicates(FilterDetails.TypeCategory.DATETIME);
                } else if ("COMPLEX_PREDICATE".equals(string2)) {
                    set = this.m_details.getSupportedPredicates(FilterDetails.TypeCategory.COMPLEX);
                    this.m_cmbPred.setEnabled(false);
                    this.m_fldNormal.setEnabled(false);
                } else {
                    set = this.m_details.getSupportedPredicates(FilterDetails.TypeCategory.CHARACTER);
                    bl = this.m_details.isSupportsCaseInsensitiveFilters();
                }
                this.m_chkCase.setEnabled(bl);
                this.m_cmbPred.setModel(new NonNullableComboBoxModel(set.toArray()));
                if (predicate != null && set.contains((Object)predicate)) {
                    this.m_cmbPred.setSelectedItem((Object)predicate);
                }
            }
        }
    }

    private void updateDateSelectButton(String string) {
        this.m_dateButton.setVisible("DATE".equals(string));
        this.m_dateLowerButton.setVisible("DATE".equals(string));
        this.m_dateUpperButton.setVisible("DATE".equals(string));
    }

    private void predicateChanged() {
        Predicate predicate = (Predicate)((Object)this.m_cmbPred.getSelectedItem());
        String string = predicate == Predicate.NULL || predicate == Predicate.NOT_NULL || predicate == Predicate.COMPLEX ? NULL_PANEL_KEY : (predicate == Predicate.BETWEEN || predicate == Predicate.NOT_BETWEEN ? BETWEEN_PANEL_KEY : NORMAL_PANEL_KEY);
        this.m_layoutValues.show(this.m_pnlValues, string);
    }

    private class L
    implements ItemListener {
        private L() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == FilterEntryPanel.this.m_cmbName) {
                FilterEntryPanel.this.nameChanged();
                FilterEntryPanel.this.predicateChanged();
            } else if (object == FilterEntryPanel.this.m_cmbPred) {
                FilterEntryPanel.this.predicateChanged();
            }
        }
    }
}

