/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.ExtrasMessages;
import oracle.dbtools.raptor.RaptorExtrasResources;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesTreeNode;
import oracle.dbtools.raptor.navigator.folders.FolderNamePanel;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.dialogs.MessageDialog;

public class DatabasesFoldersController
implements Controller {
    public static final String CONNECTION_CATEGORY = "DatabaseNavigator.CategorizeConnection";
    public static final int CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CategorizeConnection");
    public static final String NEW_CONNECTION_CATEGORY = "DatabaseNavigator.NewCategory";
    public static final int NEW_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewCategory");
    public static final String REMOVE_CONNECTION_CATEGORY = "DatabaseNavigator.RemoveCategory";
    public static final int REMOVE_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RemoveCategory");
    public static final String REMOVE_FROM_FOLDER = "DatabaseNavigator.RemoveConnFromFolder";
    public static final int REMOVE_FROM_FOLDER_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RemoveConnFromFolder");
    public static final String RENAME_CONNECTION_CATEGORY = "DatabaseNavigator.RenameCategory";
    public static final int RENAME_CONNECTION_CATEGORY_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.RenameCategory");
    public static final String DISCONNECT_CONNECTION_FROM_FOLDER = "DatabaseNavigator.Disconn_Database";
    public static final int DISCONNECT_CONNECTION_FROM_FOLDER_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.Disconn_Database");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        Element[] elementArray = context.getSelection();
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getFirstNavigatorTreeNodeFromContext(context);
        if (navigatorTreeNode == null) {
            return false;
        }
        NavigatorTree navigatorTree = NavigatorContext.getNavigatorTreeFromContext(context);
        if (NEW_CONNECTION_CATEGORY_ID == n) {
            DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode.findAncestorTreeNode(Databases.class, false);
            String[] stringArray = databasesTreeNode.getFolderNames();
            String string = this.getFolderName(stringArray, null);
            if (string != null) {
                databasesTreeNode.updateFolder(navigatorTree, string, elementArray);
            }
            bl = true;
        } else if (REMOVE_FROM_FOLDER_ID == n) {
            DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode.findAncestorTreeNode(Databases.class, false);
            databasesTreeNode.updateFolder(navigatorTree, null, elementArray);
            bl = true;
        } else if (RENAME_CONNECTION_CATEGORY_ID == n) {
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode.findAncestorTreeNode(Databases.class, false);
            String[] stringArray = databasesTreeNode.getFolderNames();
            String string = this.getFolderName(stringArray, databasesFolder.getName());
            if (string != null) {
                databasesTreeNode.renameFolder(databasesFolder.getName(), string);
            }
            bl = true;
        } else if (REMOVE_CONNECTION_CATEGORY_ID == n) {
            DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
            DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode.findAncestorTreeNode(Databases.class, false);
            databasesTreeNode.removeFolder(navigatorTree, databasesFolder.getName());
            bl = true;
        } else if (n == DISCONNECT_CONNECTION_FROM_FOLDER_ID) {
            CloseTask closeTask = null;
            if (elementArray[0] instanceof Databases) {
                closeTask = new CloseTask(Connections.getInstance().getConnNames(((Databases)elementArray[0]).getStoreId()));
            } else if (elementArray[0] instanceof DatabasesFolder) {
                DatabasesFolder databasesFolder = (DatabasesFolder)elementArray[0];
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = databasesFolder.getChildren();
                while (iterator.hasNext()) {
                    arrayList.add(((DatabaseConnection)iterator.next()).getQualifiedConnectionName());
                }
                if (arrayList.size() > 0) {
                    closeTask = new CloseTask(arrayList.toArray(new String[0]));
                }
            }
            if (closeTask != null) {
                closeTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.information((Component)Ide.getMainWindow(), (Object)RaptorExtrasResources.getString("CONN_CLOSED_LABEL"), null, null);
                            }
                        });
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)closeTask);
            }
            bl = true;
        }
        return bl;
    }

    private String getFolderName(String[] stringArray, String string) {
        FolderNamePanel folderNamePanel = new FolderNamePanel();
        Namespace namespace = new Namespace();
        namespace.put("FolderName", (Object)string);
        namespace.put("OtherFolderNames", (Object)stringArray);
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), ExtrasMessages.getString("DatabasesFoldersController.5"), (Traversable)folderNamePanel, namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog();
        return tDialogLauncher.showDialog() ? (String)namespace.find("FolderName") : null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        return n == NEW_CONNECTION_CATEGORY_ID || n == RENAME_CONNECTION_CATEGORY_ID || n == REMOVE_CONNECTION_CATEGORY_ID || n == REMOVE_FROM_FOLDER_ID || n == DISCONNECT_CONNECTION_FROM_FOLDER_ID;
    }

    private static class CloseTask
    extends RaptorTask<Void> {
        private String[] m_conns;

        CloseTask(String[] stringArray) {
            super(RaptorExtrasResources.getString("DISC_CONN_CMD_FROM_FOLDER_LABEL"), false, IRaptorTaskRunMode.TASKVIEWER);
            this.m_conns = stringArray;
        }

        protected Void doWork() throws TaskException {
            Connections connections = Connections.getInstance();
            for (String string : this.m_conns) {
                if (!connections.isConnectionOpen(string)) continue;
                connections.closeConnection(string, true);
            }
            return null;
        }
    }
}

