/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.SynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class DatabasesTreeNode
extends SynchronousNavigatorTreeNode {
    public static final String NAV_FOLDER_PROP = "NAV_FOLDER";
    private static final String[] EMPTY_ARRAY = new String[0];
    private Map<String, DatabasesFolder> m_folders;
    private ConnectionListener m_renameListener;

    public DatabasesTreeNode() {
        this.setComparator(new C());
    }

    @Override
    protected Iterator<Element> loadChildrenImpl() {
        ArrayList<DatabasesFolder> arrayList = new ArrayList<DatabasesFolder>();
        boolean bl = false;
        this.m_folders = new HashMap<String, DatabasesFolder>();
        this.initRenameListener();
        HashMap<String, DatabaseConnection> hashMap = new HashMap<String, DatabaseConnection>();
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        Databases databases = (Databases)this.getElement();
        Object object = databases.getChildren();
        while (object.hasNext()) {
            DatabaseConnection databaseConnection = (DatabaseConnection)object.next();
            hashMap.put(databaseConnection.getConnectionName(), databaseConnection);
        }
        object = this.getStoreID();
        for (String string : databasesFolderCache.getFolders((String)object)) {
            DatabasesFolder databasesFolder = this.createFolder(string);
            for (String string2 : databasesFolderCache.getConnectionNames((String)object, string)) {
                DatabaseConnection databaseConnection = (DatabaseConnection)hashMap.remove(string2);
                if (databaseConnection != null) {
                    databasesFolder.add(databaseConnection);
                    continue;
                }
                databasesFolderCache.removeConnection((String)object, string, string2);
                bl = true;
            }
            if (databasesFolder.size() > 0) {
                arrayList.add(databasesFolder);
                this.m_folders.put(string, databasesFolder);
                continue;
            }
            databasesFolderCache.removeFolder((String)object, string);
            bl = true;
        }
        if (bl) {
            this.savePrefs();
        }
        arrayList.addAll(hashMap.values());
        return arrayList.iterator();
    }

    @Override
    protected void cleanupOnClose() {
        if (this.m_folders != null) {
            this.m_folders.clear();
            this.m_folders = null;
            this.clearRenameListener();
        }
    }

    @Override
    protected Object getKey(Element element) {
        if (element instanceof DatabaseConnection) {
            return "Store:" + ((DatabaseConnection)element).getQualifiedConnectionName();
        }
        if (element instanceof DatabasesFolder) {
            return "Folder:" + ((DatabasesFolder)element).getName();
        }
        return super.getKey(element);
    }

    private String getStoreID() {
        return ((Databases)this.getElement()).getStoreId();
    }

    private void savePrefs() {
        if (!Ide.isStarting()) {
            try {
                Preferences preferences = Preferences.getPreferences();
                preferences.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getLocalizedMessage());
            }
        }
    }

    private DatabasesFolder createFolder(String string) {
        DatabasesFolder databasesFolder = new DatabasesFolder(string);
        return databasesFolder;
    }

    public String[] getFolderNames() {
        if (this.m_folders != null) {
            return this.m_folders.keySet().toArray(EMPTY_ARRAY);
        }
        return EMPTY_ARRAY;
    }

    public boolean renameFolder(String string, String string2) {
        DatabasesFolder databasesFolder = this.m_folders.remove(string);
        if (databasesFolder != null) {
            NavigatorTreeNode navigatorTreeNode = this.lookup((Element)databasesFolder);
            if (navigatorTreeNode != null) {
                this.uncache(navigatorTreeNode);
            }
            databasesFolder.setName(string2);
            UpdateMessage.fireObjectRenamed((Subject)databasesFolder);
            this.m_folders.put(string2, databasesFolder);
            if (navigatorTreeNode != null) {
                this.cache(navigatorTreeNode);
            }
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
            databasesFolderCache.renameFolder(this.getStoreID(), string, string2);
            this.savePrefs();
            UpdateMessage.fireObjectRenamed((Subject)databasesFolder);
            return true;
        }
        return false;
    }

    public void updateFolder(NavigatorTree navigatorTree, String string, Element[] elementArray) {
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        String string2 = this.getStoreID();
        if (string != null) {
            DatabasesFolder databasesFolder = this.m_folders.get(string);
            if (databasesFolder == null) {
                databasesFolder = this.createFolder(string);
                this.m_folders.put(string, databasesFolder);
                navigatorTree.addChildToNode((NavigatorTreeNode)this, (Element)databasesFolder);
            }
            NavigatorTreeNode navigatorTreeNode = this.lookup((Element)databasesFolder);
            navigatorTree.expand(navigatorTreeNode, false);
            DatabasesFolder databasesFolder2 = this.getParent(elementArray[0]);
            if (databasesFolder2 == null) {
                for (Element element : elementArray) {
                    databasesFolder.add(element);
                    databasesFolderCache.addConnection(string2, string, ((DatabaseConnection)element).getConnectionName());
                    this.reparentNode(navigatorTree, navigatorTreeNode, element);
                }
            } else if (databasesFolder2 != databasesFolder) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (Element element : elementArray) {
                    if (databasesFolder2.remove(element)) {
                        arrayList.add(element);
                        databasesFolderCache.removeConnection(string2, databasesFolder2.getName(), ((DatabaseConnection)element).getConnectionName());
                    }
                    databasesFolder.add(element);
                    databasesFolderCache.addConnection(string2, string, ((DatabaseConnection)element).getConnectionName());
                    this.reparentNode(navigatorTree, navigatorTreeNode, element);
                }
            }
        } else {
            DatabasesFolder databasesFolder = this.getParent(elementArray[0]);
            if (databasesFolder != null) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (Element element : elementArray) {
                    NavigatorTreeNode navigatorTreeNode;
                    if (databasesFolder.remove(element)) {
                        arrayList.add(element);
                        databasesFolderCache.removeConnection(string2, databasesFolder.getName(), ((DatabaseConnection)element).getConnectionName());
                    }
                    if ((navigatorTreeNode = this.reparentNode(navigatorTree, this, element)) != null) continue;
                    navigatorTree.addChildToNode((NavigatorTreeNode)this, element);
                }
            }
        }
        this.savePrefs();
    }

    private NavigatorTreeNode reparentNode(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode, Element element) {
        NavigatorTreeNode navigatorTreeNode2 = this.lookup(element);
        if (navigatorTreeNode2 == null) {
            navigatorTreeNode2 = navigatorTree.findTreeNode(element, (NavigatorTreeNode)this);
        }
        if (navigatorTreeNode2 != null) {
            navigatorTree.reparentNode(navigatorTreeNode2, navigatorTreeNode);
        }
        return navigatorTreeNode2;
    }

    private DatabasesFolder getParent(Element element) {
        Iterator<NavigatorTreeNode> iterator = this.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode = iterator.next();
            Element element2 = navigatorTreeNode.getElement();
            if (!(element2 instanceof DatabasesFolder) || !((DatabasesFolder)element2).containsChild(element)) continue;
            return (DatabasesFolder)element2;
        }
        return null;
    }

    public void removeFolder(NavigatorTree navigatorTree, String string) {
        DatabasesFolder databasesFolder = this.m_folders.remove(string);
        if (databasesFolder != null) {
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
            databasesFolderCache.removeFolder(this.getStoreID(), string);
            NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
            if (navigatorTreeNode != null) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                Iterator iterator = databasesFolder.getChildren();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    NavigatorTreeNode navigatorTreeNode2 = navigatorTree.findTreeNode(element, navigatorTreeNode);
                    if (navigatorTreeNode2 != null) {
                        navigatorTree.reparentNode(navigatorTreeNode2, this);
                        continue;
                    }
                    arrayList.add(element);
                }
                if (arrayList.size() > 0) {
                    navigatorTree.addChildrenToNode(this, arrayList);
                }
                navigatorTree.removeChildFromNode(this, navigatorTreeNode);
            }
            this.savePrefs();
        }
    }

    private void handleConnectionRename(String string, String string2) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        String string3 = Connections.getConnectionName(string);
        String string4 = Connections.getConnectionName(string2);
        String string5 = this.getStoreID();
        for (String string6 : databasesFolderCache.getFolders(string5)) {
            if (!databasesFolderCache.getConnectionNames(string5, string6).contains(string3)) continue;
            databasesFolderCache.removeConnection(string5, string6, string3);
            databasesFolderCache.addConnection(string5, string6, string4);
            break;
        }
    }

    private void addConnectionToFolder(String string, DatabaseConnection databaseConnection) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        NavigatorTree navigatorTree = this.getOwningNavigatorTree();
        if (string != null) {
            DatabasesFolder databasesFolder = this.m_folders.get(string);
            if (databasesFolder == null) {
                databasesFolder = this.createFolder(string);
                this.m_folders.put(string, databasesFolder);
                navigatorTree.addChildToNode((NavigatorTreeNode)this, (Element)databasesFolder);
            }
            NavigatorTreeNode navigatorTreeNode = this.lookup((Element)databasesFolder);
            navigatorTree.expand(navigatorTreeNode, false);
            DatabasesFolder databasesFolder2 = this.getParent(databaseConnection);
            if (databasesFolder2 == null) {
                databasesFolder.add(databaseConnection);
                databasesFolderCache.addConnection(this.getStoreID(), string, databaseConnection.getConnectionName());
                navigatorTree.refresh(navigatorTreeNode);
            } else {
                System.out.println("shouldn't happen");
            }
        }
    }

    private void initRenameListener() {
        this.m_renameListener = new ConnectionListener(){

            @Override
            public void connectionAdded(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionModified(ConnectionEvent connectionEvent) {
                DatabasesTreeNode.this.handleConnectionRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
            }

            @Override
            public void connectionOpened(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionRemoved(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionRenamed(ConnectionEvent connectionEvent) {
                DatabasesTreeNode.this.handleConnectionRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
            }
        };
        Connections.getInstance().addConnectionListener(this.m_renameListener);
    }

    private void clearRenameListener() {
        Connections.getInstance().removeConnectionListener(this.m_renameListener);
        this.m_renameListener = null;
    }

    @Override
    protected void handleChildrenRemoved(Collection<Element> collection) {
        NavigatorTree navigatorTree = this.getOwningNavigatorTree();
        if (navigatorTree != null) {
            for (Element element : collection) {
                DatabasesFolder databasesFolder = this.getParent(element);
                if (databasesFolder != null) {
                    if (!databasesFolder.remove(element)) continue;
                    NavigatorTreeNode navigatorTreeNode = this.lookup((Element)databasesFolder);
                    NavigatorTreeNode navigatorTreeNode2 = this.lookup(element);
                    if (navigatorTreeNode2 == null) {
                        navigatorTreeNode2 = navigatorTree.findTreeNode(element, (NavigatorTreeNode)this);
                    }
                    if (navigatorTreeNode2 == null) continue;
                    navigatorTree.removeChildFromNode(navigatorTreeNode, navigatorTreeNode2);
                    continue;
                }
                navigatorTree.removeChildrenFromNode(this, Collections.singletonList(element));
            }
        }
    }

    @Override
    protected void updateImpl(Object object, UpdateMessage updateMessage) {
        String string = null;
        Properties properties = null;
        ArrayList arrayList = new ArrayList();
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_ADDED) {
            List list = updateMessage.getAddObjects();
            for (Object e : list) {
                if (e instanceof DatabaseConnection) {
                    DatabaseConnection databaseConnection = (DatabaseConnection)e;
                    DatabaseConnections databaseConnections = null;
                    try {
                        databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
                        properties = databaseConnections.getProperties(databaseConnection.getConnectionName());
                        if (properties != null && properties.get(NAV_FOLDER_PROP) != null) {
                            string = (String)properties.get(NAV_FOLDER_PROP);
                            properties.remove(NAV_FOLDER_PROP);
                            databaseConnections.updateConnection(databaseConnection.getConnectionName(), databaseConnection.getConnectionName(), properties);
                            this.addConnectionToFolder(string, databaseConnection);
                            continue;
                        }
                        arrayList.add(e);
                    }
                    catch (ConnectionException connectionException) {
                        connectionException.printStackTrace();
                    }
                    continue;
                }
                arrayList.add(e);
            }
            if (arrayList.size() > 0) {
                list.clear();
                list.addAll(arrayList);
                super.updateImpl(object, updateMessage);
            }
        } else {
            super.updateImpl(object, updateMessage);
        }
    }

    private static class C
    implements Comparator<NavigatorTreeNode> {
        private Comparator<Object> m_default = Collator.getInstance();

        private C() {
        }

        @Override
        public int compare(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
            Element element = navigatorTreeNode.getElement();
            Element element2 = navigatorTreeNode2.getElement();
            return element.getClass() == element2.getClass() ? this.compareSameTypes(element, element2) : this.compareDifferentTypes(element, element2);
        }

        private int compareSameTypes(Element element, Element element2) {
            return this.m_default.compare(element.getShortLabel(), element2.getShortLabel());
        }

        private int compareDifferentTypes(Element element, Element element2) {
            return element instanceof DatabasesFolder ? -1 : 1;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == this.getClass();
        }
    }
}

