/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;

public final class FoldersConnectionPropertiesUpdater
implements ConnectionPropertiesUpdater {
    private static final String FOLDER_KEY = "NAV_FOLDER";
    private String m_storeID;
    private Map<String, String> m_folderMap;

    @Override
    public void processForExport(String string, Properties properties) {
        String string2 = this.m_folderMap.get(string);
        if (string2 != null) {
            properties.put(FOLDER_KEY, this.m_folderMap.get(string));
        }
    }

    @Override
    public void processForImport(String string, Properties properties, boolean bl) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        String string2 = properties.getProperty(FOLDER_KEY);
        String string3 = this.m_folderMap.get(string);
        if (string3 != null) {
            databasesFolderCache.removeConnection(this.m_storeID, string3, string);
        }
        if (string2 != null) {
            databasesFolderCache.addConnection(this.m_storeID, string2, string);
        }
    }

    @Override
    public void setConnectionStore(String string) {
        if (ModelUtil.areDifferent((Object)string, (Object)this.m_storeID)) {
            this.m_storeID = string;
            this.m_folderMap = new HashMap<String, String>();
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
            for (String string2 : databasesFolderCache.getFolders(this.m_storeID)) {
                for (String string3 : databasesFolderCache.getConnectionNames(this.m_storeID, string2)) {
                    this.m_folderMap.put(string3, string2);
                }
            }
        }
    }
}

