/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.net.DBURLStreamHandlerFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.util.Log;

public class DBURLFileSystemHelper
extends URLFileSystemHelper {
    public static final String DB_PROTOCOL = "sqldev.nav";
    public static final String EDITOR_PROTOCOL = "sqldev.worksheet";
    private Map<String, Boolean> writeableSchemas = new HashMap<String, Boolean>();

    public Icon getDefaultIcon(URL uRL) {
        return super.getDefaultIcon(uRL);
    }

    public Icon getSystemIcon(URL uRL) {
        return super.getSystemIcon(uRL);
    }

    public boolean isReadOnly(URL uRL) {
        return !this.canWrite(uRL);
    }

    public boolean canRead(URL uRL) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite(URL uRL) {
        boolean bl = false;
        String string = DBURLFormatHelper.getBaseType(uRL);
        if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TRIGGER".equals(string)) {
            String string2 = DBURLFormatHelper.getSchema(uRL);
            String string3 = "PROCEDURE";
            if ("TRIGGER".equals(string)) {
                string3 = "TRIGGER";
            } else if ("TYPE".equals(string) || "TYPE BODY".equals(string)) {
                string3 = "TYPE";
            }
            Database database = DBURLFileSystemHelper.getDatabase(uRL);
            if (database != null) {
                Connection connection = database.getConnection();
                if (Connections.getInstance().lock(connection)) {
                    ResultSetWrapper resultSetWrapper = null;
                    try {
                        String string4 = database.getUserName();
                        Boolean bl2 = this.writeableSchemas.get(string4);
                        if (bl2 != null) {
                            boolean bl3 = bl2;
                            return bl3;
                        }
                        boolean bl4 = !string2.equals(string4);
                        String string5 = "SELECT 1 FROM system_privilege_map \nWHERE name = 'CREATE" + (bl4 ? " ANY " : " ") + string3 + "' \n" + "OR name = 'ALTER" + (bl4 ? " ANY " : " ") + string3 + "'";
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        resultSetWrapper = dBUtil.executeQuery(string5, new HashMap());
                        ResultSet resultSet = resultSetWrapper.getResultSet();
                        if (resultSet.next()) {
                            bl = true;
                        }
                        this.writeableSchemas.put(string4, bl);
                    }
                    catch (Exception exception) {
                        Log.error((String)exception.getMessage());
                    }
                    finally {
                        if (resultSetWrapper != null) {
                            resultSetWrapper.close();
                        }
                        Connections.getInstance().unlock(connection);
                    }
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private static Database getDatabase(URL uRL) {
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(DBURLFormatHelper.getConnectionName(uRL), false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return database;
    }

    public boolean exists(URL uRL) {
        String string = DBURLFormatHelper.getBaseType(uRL);
        if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TRIGGER".equals(string)) {
            String string2 = DBURLFormatHelper.getConnectionName(uRL);
            try {
                Connection connection = Connections.getInstance().getConnection(string2, false);
                return connection != null;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return false;
    }

    public Reader createReader(URL uRL, String string) throws IOException {
        char[] cArray;
        Reader reader = null;
        if ((DBURLStreamHandlerFactory.isOracleSource(uRL) || DBURLStreamHandlerFactory.isOracleTimesTenSource(uRL)) && (cArray = DBURLStreamHandlerFactory.fetchSource(uRL)) != null) {
            reader = new CharBufferReader(cArray);
        }
        return reader != null ? reader : super.createReader(uRL, string);
    }

    public String getPlatformPathName(URL uRL) {
        return ObjectNode.getDefaultLongDisplay(uRL, null);
    }

    public long lastModified(URL uRL) {
        if (RaptorExtensionConstants.isStandAlone()) {
            return -1L;
        }
        long l = System.currentTimeMillis();
        String string = DBURLFormatHelper.getBaseType(uRL);
        if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string) || "TYPE".equals(string) || "TYPE BODY".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TRIGGER".equals(string)) {
            String string2 = DBURLFormatHelper.getSchema(uRL);
            String string3 = DBURLFormatHelper.getName(uRL);
            Database database = DBURLFileSystemHelper.getDatabase(uRL);
            if (database != null) {
                try {
                    Long l2 = database.getTimestamp(string, database.getSchema(string2), string3);
                    long l3 = System.currentTimeMillis();
                    if (500L < l3 - l) {
                        Log.error((String)("slow lastModified(" + uRL.toString() + ")=" + (l3 - l)));
                    }
                    if (l2 != null) {
                        return l2;
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return -1L;
    }

    public String toDisplayString(URL uRL) {
        return super.toDisplayString(uRL);
    }

    private static class CharBufferReader
    extends Reader {
        private int m_pos;
        private char[] m_buf;

        private CharBufferReader(char[] cArray) {
            assert (cArray != null);
            this.m_buf = cArray;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.m_pos == -1) {
                throw new IOException("Reader closed");
            }
            int n3 = Math.min(n2, this.m_buf.length - this.m_pos);
            if (n3 == 0) {
                return -1;
            }
            System.arraycopy(this.m_buf, this.m_pos, cArray, n, n3);
            this.m_pos += n3;
            return n3;
        }

        @Override
        public void close() {
            this.m_pos = -1;
        }
    }
}

