/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.db.xml.AbstractChildInstance;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.plsql.LocationComparator;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;

public class PlSqlArguments
implements FilterChildProvider {
    private static final String MEMBER_TYPE = "MEMBER";
    private static final String ARG_TYPE = "ARG";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static Comparator sort = new LocationComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBChildInstance> listChildren(DatabaseNode databaseNode, String string) throws AbortException, SQLException {
        ArrayList<DBChildInstance> arrayList = new ArrayList<DBChildInstance>();
        DBObjectInstance dBObjectInstance = databaseNode.getNodeInstance();
        DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
        DatabaseItem databaseItem = databaseObject.getChildType(string);
        if (databaseItem != null) {
            String string2 = databaseObject.getType();
            ObjectFactory objectFactory = dBObjectInstance.getObjectFactory();
            if ("PROCEDURE".equals(string2) || "FUNCTION".equals(string2)) {
                if (ARG_TYPE.equals(string)) {
                    Connection connection = objectFactory.getConnection();
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        preparedStatement = connection.prepareStatement("SELECT data_type, argument_name name \nFROM all_arguments \nWHERE \t/*argument_name is not null \nand*/ object_name=? and owner=? and package_name is NULL \norder by position");
                        Object object = databaseNode.getProperty("NAME");
                        Object object2 = databaseNode.getProperty("SCHEMA");
                        preparedStatement.setObject(1, object);
                        preparedStatement.setObject(2, object2);
                        resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            ArgChildInstance argChildInstance = new ArgChildInstance(objectFactory);
                            argChildInstance.setDescriptor(databaseItem);
                            String string3 = resultSet.getString("name");
                            if (string3 == null || string3.length() == 0) {
                                string3 = "RETURN";
                            }
                            argChildInstance.setProperty("NAME", string3);
                            argChildInstance.setProperty("CODE_OFFSET", -1);
                            String string4 = resultSet.getString("data_type");
                            if ("DATE".equalsIgnoreCase(string4) || "TIME".equalsIgnoreCase(string4) || "TIMESTAMP".equalsIgnoreCase(string4)) {
                                argChildInstance.setProperty("MEMBER_TYPE", "DATE");
                            } else if (string4.toUpperCase().contains("CHAR")) {
                                argChildInstance.setProperty("MEMBER_TYPE", "STRING");
                            } else if (string4.toUpperCase().contains("EXCEPTION")) {
                                argChildInstance.setProperty("MEMBER_TYPE", "EXCEPTION");
                            } else {
                                argChildInstance.setProperty("MEMBER_TYPE", string4);
                            }
                            argChildInstance.setProperty("TOOLTIP", string3 + " " + string4);
                            arrayList.add(argChildInstance);
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.severe("SELECT data_type, argument_name name \nFROM all_arguments \nWHERE \t/*argument_name is not null \nand*/ object_name=? and owner=? and package_name is NULL \norder by position".toString());
                        this.logger.severe(sQLException.getMessage());
                    }
                    finally {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        ((PlSqlNode)databaseNode).releaseTextBuffer();
                    }
                }
            } else if (MEMBER_TYPE.equals(string)) {
                for (Member member : ((PlSqlNode)databaseNode).parseMembers()) {
                    ArgChildInstance argChildInstance = new ArgChildInstance(objectFactory);
                    argChildInstance.setDescriptor(databaseItem);
                    argChildInstance.setProperty("NAME", member.name);
                    argChildInstance.setProperty("CODE_OFFSET", member.codeOffset);
                    argChildInstance.setProperty("MEMBER_TYPE", member.type);
                    argChildInstance.setProperty("TOOLTIP", member.getTooltip());
                    argChildInstance.setProperty("TYPE", string);
                    argChildInstance.setProperty("MEMBER_PRIVATE_VISIBILITY_KEY", member.isPrivate);
                    if (!member.isData()) {
                        argChildInstance.setProperty("OVERLOAD", member.overload);
                    }
                    argChildInstance.setProperty("ConnectionType", objectFactory.getConnectionType());
                    arrayList.add(argChildInstance);
                }
            }
        }
        return arrayList;
    }

    private static class ArgChildInstance
    extends AbstractChildInstance {
        private ArgChildInstance(ObjectFactory objectFactory) {
            super(objectFactory);
            this.setProperty("TYPE", PlSqlArguments.ARG_TYPE);
        }

        @Override
        protected void setDescriptor(DatabaseItem databaseItem) {
            super.setDescriptor(databaseItem);
        }
    }
}

