/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.cloud;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.JSONHandler;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.ui.table.GenericTable;

public class BasicCloudEditor
extends AsynchronousViewerEditor {
    private JPanel _gui = null;
    GenericTable _table;
    private CloudObject _current;
    private DefaultTableModel _model;

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        this.refreshDetails(false);
    }

    private Row getRowFromArray(Iterator<JSONEvent> iterator) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        JSONEvent jSONEvent = null;
        int n = 0;
        block4: while (iterator.hasNext()) {
            jSONEvent = iterator.next();
            switch (jSONEvent.type()) {
                case PROPERTY_NAME: {
                    Pair<String, Object> pair = this.getJSONValue(iterator, jSONEvent);
                    arrayList.add(new Column((String)pair.first(), n, pair.second()));
                    continue block4;
                }
                case END_OBJECT: {
                    break block4;
                }
                default: {
                    Logger.warn(BasicCloudEditor.class, (String)("json:Expected a property but got: " + jSONEvent.type()));
                    continue block4;
                }
            }
        }
        return new Row(arrayList);
    }

    private Pair<String, Object> getJSONValue(Iterator<JSONEvent> iterator, JSONEvent jSONEvent) {
        Object object = null;
        String string = jSONEvent.propertyName();
        jSONEvent = iterator.next();
        switch (jSONEvent.type()) {
            case NULL_VALUE: {
                break;
            }
            case BOOLEAN_VALUE: {
                object = jSONEvent.booleanValue();
                break;
            }
            case NUMERIC_VALUE: {
                object = jSONEvent.numberValue();
                break;
            }
            case STRING_VALUE: {
                object = jSONEvent.stringValue();
            }
        }
        return Pair.pair((Object)string, (Object)object);
    }

    private void refreshDetails(boolean bl) {
        try {
            Node node = this._context.getNode();
            if (node == null) {
                node = (Node)this._context.getSelection()[0];
            }
            if (bl || this._current == null || this._current != (CloudObject)((IViewerNode)node).getDBObject().getElement()) {
                String string;
                List<Row> list;
                CloudObject cloudObject = null;
                if (node instanceof IViewerNode) {
                    this._current = cloudObject = (CloudObject)((IViewerNode)node).getDBObject().getElement();
                }
                if (this._table == null) {
                    this._table = new GenericTable();
                    this._model = new DefaultTableModel();
                    this._table.setModel((TableModel)this._model);
                } else {
                    this._model = new DefaultTableModel();
                    this._table.setModel((TableModel)this._model);
                }
                String string2 = cloudObject.getConnectionName();
                CConnection cConnection = CConnections.getInstance().getConnection(string2, false);
                if (cConnection != null && (list = cConnection.executeQuery(string = cloudObject.getRemoteURI().toString(), new JSONHandler<List<Row>>(){

                    @Override
                    protected List<Row> build(Iterator<JSONEvent> iterator) throws IOException {
                        ArrayList<Row> arrayList = new ArrayList<Row>();
                        boolean bl = true;
                        block10: while (iterator.hasNext()) {
                            JSONEvent jSONEvent = iterator.next();
                            switch (jSONEvent.type()) {
                                case START_OBJECT: {
                                    if (bl) {
                                        bl = false;
                                        continue block10;
                                    }
                                    throw new IOException(new IllegalStateException("Invalid JSON document"));
                                }
                                case PROPERTY_NAME: {
                                    Pair pair = BasicCloudEditor.this.getJSONValue(iterator, jSONEvent);
                                    if (!"items".equals(pair.first())) continue block10;
                                    block11: while (iterator.hasNext()) {
                                        jSONEvent = iterator.next();
                                        switch (jSONEvent.type()) {
                                            case START_OBJECT: {
                                                arrayList.add(BasicCloudEditor.this.getRowFromArray(iterator));
                                                continue block11;
                                            }
                                            case PROPERTY_NAME: {
                                                pair = BasicCloudEditor.this.getJSONValue(iterator, jSONEvent);
                                                continue block11;
                                            }
                                            case END_ARRAY: {
                                                continue block10;
                                            }
                                        }
                                        Logger.warn(BasicCloudEditor.class, (String)("json:Expected a property but got: " + jSONEvent.type()));
                                    }
                                    continue block10;
                                }
                                case END_OBJECT: {
                                    break block10;
                                }
                                default: {
                                    Logger.warn(BasicCloudEditor.class, (String)("json:Expected a property but got: " + jSONEvent.type()));
                                    continue block10;
                                }
                            }
                        }
                        return arrayList;
                    }
                })).size() > 0) {
                    Row row = list.get(0);
                    for (Column object : row._cols) {
                        this._model.addColumn(object._name);
                    }
                    for (Row row2 : list) {
                        this._model.addRow(row2.getData());
                    }
                    this._model.fireTableDataChanged();
                }
            }
        }
        catch (CConnectionException cConnectionException) {
            cConnectionException.printStackTrace();
        }
    }

    @Override
    protected JComponent createViewerUI() {
        if (this._gui == null) {
            this._gui = new JPanel();
            this._gui.setLayout(new BorderLayout());
            this._gui.add((Component)this._table, "Center");
        }
        this.refreshDetails(false);
        return this._gui;
    }

    @Override
    protected void updateContent(boolean bl) {
        this.refreshDetails(bl);
    }

    @Override
    protected void cleanUp() {
        this._gui = null;
    }

    @Override
    public Object getPrintable() {
        return this._gui;
    }

    class Column {
        String _name;
        int _seq;
        Object _value;

        public Column(String string, int n, Object object) {
            this._name = string;
            this._seq = n;
            this._value = object;
        }
    }

    class Row {
        List<Column> _cols;

        public Row(List<Column> list) {
            this._cols = list;
        }

        public int getColCount() {
            return this._cols.size();
        }

        public Object[] getData() {
            Object[] objectArray = new Object[this._cols.size()];
            for (int i = 0; i < this._cols.size(); ++i) {
                objectArray[i] = this._cols.get((int)i)._value;
            }
            return objectArray;
        }
    }
}

