/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.table;

import java.awt.Component;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManagerImpl;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class DDLViewer
extends AsynchronousViewerEditor {
    protected BasicEditorPane _code;
    protected DBObject _lastdbObject;
    protected DBObject _dbObject;
    protected IdeAction _refreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_TE_Editor");
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/raptor/oviewer/base/accelerators.xml")};

    @Override
    protected Component getGUIComponent() {
        JComponent jComponent = (JComponent)super.getGUIComponent();
        if (null == jComponent) {
            this.setGUIComponent(this.createViewerUI());
            this.updateContent(true);
            this.setContentModelLoaded(true);
        }
        return super.getGUIComponent();
    }

    @Override
    protected JComponent createViewerUI() {
        this.setCodeArea(EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts));
        BasicDocument basicDocument = (BasicDocument)this.getCodeArea().getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this.getCodeArea().setEditable(false);
        this.getCodeArea().setCaretPosition(0);
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.getCodeArea().installPlugin((EditorPlugin)lineGutterPlugin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.getCodeArea(), 22, 32);
        jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        this._refreshAction = IdeAction.findOrCreate((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("DDLViewer.2"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this._refreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                DDLViewer.this.updateContent(true);
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
        this.setPinEnabled(true);
        DDLViewer.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                DDLViewer.this.buildToolbar();
            }
        });
        return jScrollPane;
    }

    private void buildToolbar() {
        ((Toolbar)super.getFixedTopMargin()).add((ToggleAction)this._refreshAction.newLocalAction((View)this));
    }

    protected String getBinds() {
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    @Override
    protected void updateContent(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (viewerNode != null) {
            this._dbObject = viewerNode.getDBObject();
        }
        if (bl || this._dbObject != null && (this._lastdbObject == null || this._lastdbObject.getObjectName() != this._dbObject.getObjectName())) {
            this.getCodeArea().setEditable(true);
            final ReentrantLock reentrantLock = Connections.getInstance().getLock(this._dbObject.getConnection());
            RaptorTask<Object> raptorTask = new RaptorTask<Object>(Messages.getString("DDLViewer.5"), true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    reentrantLock.lock();
                    try {
                        CharSequence charSequence;
                        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
                        DDLFormat dDLFormat = new DDLFormat();
                        dDLGenerator.setFormating(dDLFormat);
                        String string = "";
                        if (DBConfig.getInstance().getBoolean("AUTO_READONLY_FORMAT").booleanValue()) {
                            if (CodingStyleManager.getCodingStyleManager() == null) {
                                CodingStyleManager.setCodingStyleManager(new CodingStyleManagerImpl());
                            }
                            CodingStyleSQLOptions codingStyleSQLOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions();
                            string = codingStyleSQLOptions.format(dDLFormat.getGrant() ? dDLGenerator.getDDL(DDLViewer.this._dbObject) + DDLViewer.this.getTerm() + dDLGenerator.getGrants(DDLViewer.this._dbObject) : dDLGenerator.getDDL(DDLViewer.this._dbObject));
                        } else {
                            string = dDLFormat.getGrant() ? dDLGenerator.getDDL(DDLViewer.this._dbObject) + DDLViewer.this.getTerm() + dDLGenerator.getGrants(DDLViewer.this._dbObject) : dDLGenerator.getDDL(DDLViewer.this._dbObject);
                        }
                        int n = string.trim().lastIndexOf("\n");
                        int n2 = string.trim().length();
                        if (n != -1 && n2 > n && ((StringBuilder)(charSequence = new StringBuilder(string.substring(string.trim().lastIndexOf("\n"), string.length())))).toString().contains("--")) {
                            charSequence = ((StringBuilder)charSequence).replace(((StringBuilder)charSequence).lastIndexOf(";"), ((StringBuilder)charSequence).lastIndexOf(";") + 1, "\n;");
                            string = string.substring(0, string.trim().lastIndexOf("\n")) + ((StringBuilder)charSequence).toString();
                        }
                        charSequence = string;
                        return charSequence;
                    }
                    catch (Exception exception) {
                        throw new TaskException((Throwable)exception);
                    }
                    finally {
                        reentrantLock.unlock();
                    }
                }

                public boolean cancel() {
                    this.setMessage("--Generation of DDL was cancelled");
                    return true;
                }
            };
            raptorTask.setCancellable(true);
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
                final /* synthetic */ RaptorTask val$task;
                {
                    this.val$task = raptorTask;
                }

                public void updateCodeArea(BasicEditorPane basicEditorPane, RaptorTaskEvent raptorTaskEvent) {
                    if (raptorTaskEvent.getTaskDescriptor().getStatus() == IRaptorTaskStatus.FINISHED || raptorTaskEvent.getTaskDescriptor().getStatus() == IRaptorTaskStatus.FAILED) {
                        basicEditorPane.setEditable(false);
                        basicEditorPane.setCaretPosition(0);
                        DDLViewer.this._lastdbObject = DDLViewer.this._dbObject;
                    }
                }

                public void taskCancelled(final RaptorTaskEvent raptorTaskEvent) {
                    final BasicEditorPane basicEditorPane = DDLViewer.this.getCodeArea();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            basicEditorPane.setEditable(true);
                            basicEditorPane.setText("--Generation of DDL was cancelled");
                            basicEditorPane.setEditable(false);
                            this.updateCodeArea(basicEditorPane, raptorTaskEvent);
                        }
                    });
                }

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    final BasicEditorPane basicEditorPane = DDLViewer.this.getCodeArea();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            basicEditorPane.setEditable(true);
                            basicEditorPane.setText("--Generation of DDL failed");
                            basicEditorPane.setEditable(false);
                            this.updateCodeArea(basicEditorPane, raptorTaskEvent);
                        }
                    });
                }

                public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
                    final BasicEditorPane basicEditorPane = DDLViewer.this.getCodeArea();
                    try {
                        final Object object = this.val$task.getResult();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (object != null) {
                                    basicEditorPane.setEditable(true);
                                    basicEditorPane.setText(object.toString());
                                    basicEditorPane.setEditable(false);
                                } else {
                                    basicEditorPane.setText("--Generation of DDL was cancelled");
                                }
                                this.updateCodeArea(basicEditorPane, raptorTaskEvent);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, interruptedException.getMessage());
                    }
                    catch (ExecutionException executionException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, executionException.getMessage());
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    @Override
    public Object getPrintable() {
        return this.getCodeArea();
    }

    @Override
    protected void cleanUp() {
        this._lastdbObject = null;
        this._dbObject = null;
        this._refreshAction = null;
        this._code = null;
    }

    public Object getEditorAttribute(String string) {
        boolean bl = false;
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    private String getTerm() {
        return "\n";
    }

    protected void setCodeArea(BasicEditorPane basicEditorPane) {
        this._code = basicEditorPane;
    }

    protected BasicEditorPane getCodeArea() {
        return this._code;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_bdbtableviewer_html");
    }
}

