/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.xmleditor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.javatools.util.Version;

public class XMLEditor {
    private String _title;
    private String _subTitle;
    private Class _nodeClass;
    private Class _editorClass;
    private ArrayList<Query> _queries;
    private ArrayList<Query> _subQueries;
    private String _type;
    private boolean _vertical;
    private String _display;
    private ArrayList<Query> _bottomQueries;

    public void setTitle(String string) {
        this._title = string;
    }

    public void setNode(String string) throws ClassNotFoundException {
        this._nodeClass = this.getClass().getClassLoader().loadClass("oracle.jdeveloper.cm.dt.browser.jdbc." + string);
    }

    public void setQueries(ArrayList<Query> arrayList) {
        this._queries = arrayList;
    }

    public Query getQuery(String string) {
        return XMLEditor.getQuery(string, this._queries);
    }

    public Query getSubQuery(String string) {
        return XMLEditor.getQuery(string, this._subQueries);
    }

    public Query getBottomQuery(String string) {
        return XMLEditor.getQuery(string, this._bottomQueries);
    }

    private static Query getQuery(String string, List<Query> list) {
        for (Query query : list) {
            if (!DBUtil.checkVersion((String)string, (Version)query.getMaxversion(), (Version)query.getMinversion())) continue;
            return query;
        }
        return null;
    }

    public ArrayList<Query> getQueries() {
        return this._queries;
    }

    public ArrayList<Query> getSubQueries() {
        return this._subQueries;
    }

    public void setSubQueries(ArrayList<Query> arrayList) {
        this._subQueries = arrayList;
    }

    public Class getNodeClass() {
        return this._nodeClass;
    }

    public String getTitle() {
        return this._title;
    }

    public void setEditorClass(String string) {
        if (string != null) {
            try {
                this._editorClass = this.getClass().getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
            }
        }
    }

    public Class getEditorClass() {
        return this._editorClass;
    }

    public void setSubQueryType(String string) {
        this._type = string;
    }

    public String getSubQueryType() {
        return this._type;
    }

    public void setVertical(String string) {
        this._vertical = Boolean.parseBoolean(string);
    }

    public boolean getVertical() {
        return this._vertical;
    }

    public void setDisplay(String string) {
        this._display = string;
    }

    public String getDisplay() {
        return this._display;
    }

    public void setBottomQueries(ArrayList<Query> arrayList) {
        this._bottomQueries = arrayList;
    }

    public ArrayList<Query> getBottomQueries() {
        return this._bottomQueries;
    }

    public void setSubTitle(String string) {
        this._subTitle = string;
    }

    public String getSubTitle() {
        return this._subTitle;
    }
}

