/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.MultiItemTemplate;
import oracle.javatools.ui.infotip.templates.SingleItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.service.TransformAction;

public class AdvisoryHoverBuilder {
    private static HoverFlavor errorFlavor = HoverFlavor.getFlavor((String)"errors");
    private InfoTipHover hover = null;

    public AdvisoryHoverBuilder(JComponent jComponent, Point point, List<HoverFlavor> list, BasicEditorPane basicEditorPane, Set<Issue> set, InfoTipStyles infoTipStyles) {
        if (set == null || !list.contains(errorFlavor)) {
            return;
        }
        SwingUtilities.convertPointFromScreen(point, jComponent);
        int n = basicEditorPane.viewToModel(point);
        try {
            if (!basicEditorPane.modelToView(n).contains(point)) {
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        LinkedList<Issue> linkedList = new LinkedList<Issue>();
        for (Issue issue : set) {
            if (issue.from > n || n >= issue.to || !issue.isFixable()) continue;
            linkedList.add(issue);
        }
        if (linkedList.isEmpty()) {
            return;
        }
        try {
            Issue issue;
            Rectangle rectangle = basicEditorPane.modelToView(n);
            rectangle.grow(1, 1);
            this.hover = new InfoTipHover(null, InfoTipStyles.DEFAULT, (JComponent)basicEditorPane, rectangle, errorFlavor);
            issue = AdvisoryHoverBuilder.createTipContent(this.hover, basicEditorPane, linkedList, infoTipStyles);
            if (issue == null) {
                this.hover = null;
                return;
            }
            this.hover.setContent((Template)issue);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("global").log(Level.SEVERE, badLocationException.getMessage());
            this.hover = null;
        }
    }

    Hover getHover() {
        return this.hover;
    }

    static Template createTipContent(InfoTipHover infoTipHover, BasicEditorPane basicEditorPane, List<Issue> list, InfoTipStyles infoTipStyles) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<SingleItemTemplate> arrayList = new ArrayList<SingleItemTemplate>();
        HashSet<String> hashSet = new HashSet<String>();
        int n = (int)basicEditorPane.getVisibleRect().getWidth();
        for (Issue issue : list) {
            String string = issue.msg;
            if (string == null || "".equals(string) || !hashSet.add(string = string.trim())) continue;
            List<TransformAction> list2 = issue.getActions(basicEditorPane);
            SingleItemTemplate.Severity severity = null;
            Severity severity2 = Severity.INCOMPLETE;
            if (severity2 == Severity.ERROR) {
                severity = SingleItemTemplate.Severity.ERROR;
            } else if (severity2 == Severity.WARNING) {
                severity = SingleItemTemplate.Severity.WARNING;
            } else if (severity2 == Severity.INCOMPLETE) {
                severity = SingleItemTemplate.Severity.INCOMPLETE;
            }
            SingleItemTemplate singleItemTemplate = new SingleItemTemplate(severity, string, null, list2, infoTipStyles, n);
            singleItemTemplate.setHover(infoTipHover);
            arrayList.add(singleItemTemplate);
        }
        MultiItemTemplate multiItemTemplate = new MultiItemTemplate(arrayList);
        return multiItemTemplate;
    }
}

