/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.phighlight.AdvisoryHoverBuilder;
import oracle.dbtools.raptor.phighlight.HighlightAddin;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.dbtools.raptor.phighlight.SemanticAnalysis;
import oracle.dbtools.raptor.phighlight.SyntaxAdvice;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;

public class HighlightEditorPlugin
implements EditorPlugin,
TooltipMessage,
ParserEventListener,
HoverProvider {
    private Logger logger = Logger.getLogger(HighlightEditorPlugin.class.getName());
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private Issue[] _errors;
    private String connection;
    private List<HighlightedText> wiggleHighlights = new LinkedList<HighlightedText>();
    private Set<Issue> wiggleRanges = new TreeSet<Issue>();

    public HighlightEditorPlugin() {
    }

    public HighlightEditorPlugin(BasicEditorPane basicEditorPane, String string) {
        this._editorPane = basicEditorPane;
        ((IdeEditorPane)this._editorPane).getMultiHoverProvider().registerProvider((HoverProvider)this);
        this.connection = string;
    }

    @Override
    public String getToolTipText(int n) {
        if (this._errors != null && 0 < this._errors.length) {
            for (int i = 0; i < this._errors.length; ++i) {
                Issue issue = this._errors[i];
                if (!issue.isInHighlight(n)) continue;
                String[] stringArray = issue.msg.split("\n");
                String string = stringArray[0];
                if (stringArray.length > 1) {
                    string = string + "...";
                }
                return string;
            }
        } else {
            for (Issue issue : this.wiggleRanges) {
                if (issue.from > n || n >= issue.to || issue.isFixable()) continue;
                return issue.msg;
            }
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
        final PlSqlNode plSqlNode = this.getNode();
        if (plSqlNode != null) {
            this._nodeListener = new NodeListener(){

                public void nodeSaved(NodeEvent nodeEvent) {
                    if (plSqlNode.getParser().text == null) {
                        return;
                    }
                    if (DBURLFormatHelper.isDBURL(plSqlNode.getURL())) {
                        HighlightEditorPlugin.this.updateHighlight();
                    }
                }
            };
            plSqlNode.addNodeListener(this._nodeListener);
            this.updateHighlight();
            plSqlNode.getParser().addParserEventListener(this);
        }
        ((IdeEditorPane)this._editorPane).getMultiHoverProvider().registerProvider((HoverProvider)this);
        this.deinstallStatusEditorPlugin();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        PlSqlNode plSqlNode = this.getNode();
        plSqlNode.removeNodeListener(this._nodeListener);
        plSqlNode.getParser().removeParserEventListener(this);
        this._highlightLayer = null;
        this._editorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected PlSqlNode getNode() {
        Context context = (Context)this._editorPane.getProperty("editor-ide-context");
        PlSqlNode plSqlNode = null;
        if (context != null) {
            plSqlNode = (PlSqlNode)context.getNode();
        }
        return plSqlNode;
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null && this._editorPane != null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void deinstallStatusEditorPlugin() {
        try {
            Field field = BasicEditorPane.class.getDeclaredField("pluginList");
            field.setAccessible(true);
            ArrayList arrayList = (ArrayList)field.get(this._editorPane);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (!(e instanceof StatusEditorPlugin)) continue;
                this._editorPane.deinstallPlugin((EditorPlugin)e);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private void updateHighlight() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object doInBackground() {
                HighlightEditorPlugin.access$102(HighlightEditorPlugin.this, HighlightEditorPlugin.this.getErrors());
                return null;
            }

            @Override
            public void done() {
                HighlightLayer highlightLayer = HighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                highlightLayer.removeAllHighlights();
                HighlightStyle highlightStyle = HighlightAddin.getErrorHighlightStyle();
                HighlightStyle highlightStyle2 = HighlightAddin.getWarningHighlightStyle();
                CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)HighlightEditorPlugin.this._editorPane);
                BasicEditorOverview basicEditorOverview = codeEditor.getOverview();
                basicEditorOverview.removeMarks((Object)"audit-errors");
                basicEditorOverview.removeMarks((Object)"audit-warnings");
                int n = HighlightEditorPlugin.this._editorPane.getLineCount();
                if (n == 0) {
                    return;
                }
                for (int i = 0; i < HighlightEditorPlugin.this._errors.length; ++i) {
                    Color color;
                    HighlightStyle highlightStyle3;
                    String string;
                    Issue issue = HighlightEditorPlugin.this._errors[i];
                    int n2 = issue.line;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 >= n) {
                        n2 = n - 1;
                    }
                    String string2 = issue.msg;
                    if (issue.isError()) {
                        string = "audit-errors";
                        highlightStyle3 = highlightStyle;
                        color = OverviewStatus.ERROR;
                    } else {
                        string = "audit-warnings";
                        highlightStyle3 = highlightStyle2;
                        color = OverviewStatus.WARNING;
                    }
                    try {
                        int n3;
                        int n4;
                        int n5 = HighlightEditorPlugin.this._editorPane.getLineCount();
                        if (n5 < n2) {
                            HighlightEditorPlugin.this.logger.log(Level.SEVERE, "Could not highlight: #lines = " + n5 + ", line=" + n2);
                            return;
                        }
                        int n6 = HighlightEditorPlugin.this._editorPane.getLineStartOffset(n2);
                        int n7 = HighlightEditorPlugin.this._editorPane.getLineEndOffset(n2);
                        if (string2.startsWith("PLS-00103:")) {
                            n4 = issue.offset;
                            n3 = n6 + n4;
                            n2 = HighlightEditorPlugin.this._editorPane.getLineFromOffset(n3);
                            highlightLayer.addHighlight(highlightStyle3, n3, n3 + 1);
                            issue.setHighlights(n3, n3);
                            basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(HighlightEditorPlugin.this._editorPane, Integer.valueOf(n3), Integer.valueOf(n3), 2.0f, color), (Object)string);
                            continue;
                        }
                        n4 = n6 + issue.offset;
                        n3 = n7 - 1;
                        highlightLayer.addHighlight(highlightStyle3, n4, n3);
                        issue.setHighlights(n4, n3);
                        basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(HighlightEditorPlugin.this._editorPane, Integer.valueOf(n4), Integer.valueOf(n4), 2.0f, color), (Object)string);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OverviewStatus overviewStatus = basicEditorOverview.getStatus();
                if (overviewStatus != null) {
                    if (0 < HighlightEditorPlugin.this._errors.length) {
                        overviewStatus.setColor(OverviewStatus.ERROR);
                    } else {
                        overviewStatus.setColor(OverviewStatus.OK);
                    }
                }
            }
        };
        swingWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Issue[] getErrors() {
        ArrayList<Issue> arrayList = new ArrayList<Issue>();
        PlSqlNode plSqlNode = this.getNode();
        URL uRL = plSqlNode.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        if (string == null) {
            return new Issue[0];
        }
        String string2 = plSqlNode.getConnectionName();
        if (string2 == null) {
            return new Issue[0];
        }
        ResultSetWrapper resultSetWrapper = null;
        try {
            boolean bl;
            Connection connection = Connections.getInstance().getConnection(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(string);
            arrayList2.add(plSqlNode.getSrcName());
            if (!Connections.getInstance().lock(string2)) {
                Issue[] issueArray = new Issue[]{};
                return issueArray;
            }
            resultSetWrapper = DBUtil.getInstance((String)string2).executeQuery(this.getErrorReportQuery(connection), arrayList2);
            if (resultSetWrapper == null) {
                Issue[] issueArray = new Issue[]{};
                return issueArray;
            }
            ResultSet resultSet = resultSetWrapper.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl2 = bl = resultSetMetaData.getColumnCount() == 4;
            while (resultSet.next()) {
                if (plSqlNode.getParser().text == null) {
                    Issue[] issueArray = new Issue[]{};
                    return issueArray;
                }
                int n = resultSet.getInt(1);
                if (n == 0) {
                    n = 1;
                }
                int n2 = n - 1 + plSqlNode.offset(string);
                int n3 = resultSet.getInt(2);
                if (n3 == 0) {
                    n3 = 1;
                }
                int n4 = n3 - 1;
                String string3 = resultSet.getString(3);
                boolean bl3 = bl ? "ERROR".equals(resultSet.getString(4)) : true;
                Issue issue = new Issue(n2, n4, string3, bl3);
                arrayList.add(issue);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
        }
        finally {
            Connections.getInstance().unlock(string2);
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        return arrayList.toArray(new Issue[arrayList.size()]);
    }

    private String getErrorReportQuery(Connection connection) throws SQLException {
        if (connection.getMetaData().getDatabaseMajorVersion() > 9) {
            return "SELECT LINE,POSITION,TEXT,ATTRIBUTE FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
        }
        return "SELECT LINE,POSITION,TEXT FROM USER_ERRORS WHERE TYPE=? AND NAME=? ";
    }

    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        List<LexerToken> list = backgroundParser.src;
        int n = this._editorPane.getCaretPosition();
        int n2 = LexerToken.scanner2parserOffset(list, (int)n);
        this.wiggleRanges = new TreeSet<Issue>();
        LazyNode lazyNode = backgroundParser.output;
        if (lazyNode != null) {
            SyntaxError syntaxError;
            Matrix matrix2;
            LazyNode lazyNode2 = null;
            List list2 = backgroundParser.src;
            String string = backgroundParser.text;
            int n3 = 0;
            if (2000 < list.size()) {
                for (Matrix matrix2 : lazyNode.ancestors(n2)) {
                    if (!(matrix2 instanceof LazyNode)) continue;
                    lazyNode2 = (LazyNode)matrix2;
                    if (lazyNode2.to - lazyNode2.from < 4 || !lazyNode2.isDDL(null) && !lazyNode2.isDML(null) && !lazyNode2.isProcedure() && !lazyNode2.isStmt(lazyNode) && lazyNode2 != lazyNode || lazyNode2 == lazyNode && lazyNode2.from + 2000 < lazyNode2.to || lazyNode2.from + 2000 < lazyNode2.to) continue;
                    list2 = lazyNode2.getSrcFragment();
                    syntaxError = list.get(matrix2.from);
                    string = backgroundParser.text.substring(syntaxError.begin, list.get((int)(matrix2.to - 1)).end);
                    n3 = syntaxError.begin;
                    break;
                }
            }
            SqlEarley sqlEarley = SqlEarley.partialRecognizer();
            matrix2 = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(list2, matrix2);
            syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"sql_statements", "subprg_body"}, list2, (Earley)sqlEarley, (Matrix)matrix2);
            if (syntaxError != null) {
                this.markErrors(syntaxError, backgroundParser, n3);
            }
            if ((lazyNode2 != null && lazyNode2.isDML(null) || lazyNode2 == null) && DBConfig.getInstance().getBoolean("SEMANTICANALYSISINFOTIP").booleanValue()) {
                PlSqlNode plSqlNode = this.getNode();
                if (plSqlNode != null) {
                    this.connection = plSqlNode.getConnectionName();
                }
                SemanticAnalysis.doIt(list2, string, sqlEarley.forest(list2, matrix2), n3, this._editorPane.getCaretPosition(), this.wiggleRanges, this.connection);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HighlightLayer highlightLayer = HighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                for (Object object : HighlightEditorPlugin.this.wiggleHighlights) {
                    highlightLayer.removeHighlight((HighlightedText)object);
                }
                for (Object object : HighlightEditorPlugin.this.wiggleRanges) {
                    HighlightEditorPlugin.this.wiggleHighlights.add(highlightLayer.addHighlight(((Issue)object).getHighlightStyle(), ((Issue)object).from, ((Issue)object).to));
                }
            }
        });
    }

    private void markErrors(SyntaxError syntaxError, BackgroundParser backgroundParser, int n) {
        n += syntaxError.end;
        int n2 = 3;
        if (syntaxError.getSuggestions().length == 1 && syntaxError.getSuggestions()[0].charAt(0) == '\'') {
            n2 = syntaxError.getSuggestions()[0].length();
        }
        int n3 = n + n2;
        if (backgroundParser.text.length() < n3) {
            n3 = backgroundParser.text.length();
        }
        if (0 < n && n3 < n + 3) {
            --n;
        }
        this.wiggleRanges.add(new SyntaxAdvice(n, n3, syntaxError.getSuggestions()));
    }

    public Hover hover(JComponent jComponent, Point point, List<HoverFlavor> list) {
        AdvisoryHoverBuilder advisoryHoverBuilder = new AdvisoryHoverBuilder(jComponent, point, list, this._editorPane, this.wiggleRanges, InfoTipStyles.CODE);
        Hover hover = advisoryHoverBuilder.getHover();
        if (hover != null) {
            hover.showHover();
        }
        return hover;
    }

    static /* synthetic */ Issue[] access$102(HighlightEditorPlugin highlightEditorPlugin, Issue[] issueArray) {
        highlightEditorPlugin._errors = issueArray;
        return issueArray;
    }
}

