/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.phighlight;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.phighlight.HighlightAddin;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.audit.service.TransformAction;

class Issue
implements Comparable<Issue> {
    int from;
    int to;
    String msg;
    Type type;
    int line;
    int offset;
    protected String replacement = null;

    boolean isError() {
        return this.type == Type.ERROR;
    }

    Issue(int n, int n2, String string, Type type) {
        this.from = n;
        this.to = n2;
        this.msg = string;
        this.type = type;
    }

    Issue(int n, int n2, String string, boolean bl) {
        this.line = n;
        this.offset = n2;
        this.msg = string;
        this.type = bl ? Type.ERROR : Type.WARNING;
    }

    String getReplacement() {
        return this.replacement;
    }

    boolean isFixable() {
        return this.replacement != null;
    }

    void doFix(BasicEditorPane basicEditorPane) {
        basicEditorPane.setSelectionStart(this.from);
        basicEditorPane.setSelectionEnd(this.to);
        basicEditorPane.replaceSelection(this.replacement);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Issue)) {
            return false;
        }
        return this.compareTo((Issue)object) == 0;
    }

    public int hashCode() {
        throw new RuntimeException("hashCode inconsistent with equals");
    }

    @Override
    public int compareTo(Issue issue) {
        if (this.type != issue.type) {
            return this.type.toInt() - issue.type.toInt();
        }
        if (this.from != issue.from) {
            return this.from - issue.from;
        }
        return this.to - issue.to;
    }

    void setHighlights(int n, int n2) {
        this.from = n;
        this.to = n2;
    }

    boolean isInHighlight(int n) {
        return this.from <= n && n <= this.to;
    }

    HighlightStyle getHighlightStyle() {
        switch (this.type) {
            case ERROR: {
                return HighlightAddin.getDynamicErrorHighlightStyle();
            }
            case WARNING: 
            case ADVISORY: {
                return HighlightAddin.getDisjointJoinGraphHighlightStyle();
            }
        }
        throw new AssertionError((Object)"Unexpected case");
    }

    List<TransformAction> getActions(final BasicEditorPane basicEditorPane) {
        LinkedList<TransformAction> linkedList = new LinkedList<TransformAction>();
        linkedList.add(new TransformAction(this.getReplacement(), null, null){

            public void actionPerformed(ActionEvent actionEvent) {
                Issue.this.doFix(basicEditorPane);
            }

            public Throwable apply() {
                return null;
            }
        });
        return linkedList;
    }

    static enum Type {
        ERROR(0),
        WARNING(1),
        ADVISORY(2);

        int id;

        private Type(int n2) {
            this.id = n2;
        }

        public int toInt() {
            return this.id;
        }
    }
}

