/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.search.NavSearchDockableFactory;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

public class FindHighlightListener
implements EditorListener {
    private MouseListener mouseler;
    private KeyListener keydler;
    private FindHighlightPlugin findPlugin;
    private BasicEditorPane editorPane;
    private Editor editor;

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        Node node = editor.getContext().getNode();
        if (!(node instanceof EquippedWithParser) && !(editor instanceof EquippedWithParser)) {
            return;
        }
        this.editor = editor;
        this.addListeners();
    }

    private void addListeners() {
        if (null == this.editor) {
            return;
        }
        if (!(this.editor instanceof BasicEditorPaneContainer)) {
            return;
        }
        this.editorPane = ((BasicEditorPaneContainer)this.editor).getFocusedEditorPane();
        if (this.editorPane != null) {
            this.findPlugin = new FindHighlightPlugin();
            EquippedWithParser equippedWithParser = null;
            final Node node = this.editor.getContext().getNode();
            if (node instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)node;
            } else if (this.editor instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)this.editor;
            }
            if (equippedWithParser == null) {
                return;
            }
            final BackgroundParser backgroundParser = equippedWithParser.getParser();
            this.mouseler = new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    LexerToken annotatedElement;
                    FindHighlightListener.this.findPlugin.clearFindHighlighting();
                    if (mouseEvent.getClickCount() != 2) {
                        return;
                    }
                    String string = FindHighlightListener.this.editorPane.getSelectedText();
                    int n = FindHighlightListener.this.editorPane.getSelectionStart();
                    HighlightLayer highlightLayer = null;
                    HighlightStyle highlightStyle = null;
                    try {
                        annotatedElement = FindHighlightListener.this.findPlugin.getClass();
                        Iterator<LexerToken> iterator = annotatedElement.getDeclaredMethod("getHighlightLayer", new Class[0]);
                        ((Method)((Object)iterator)).setAccessible(true);
                        highlightLayer = (HighlightLayer)((Method)((Object)iterator)).invoke(FindHighlightListener.this.findPlugin, new Object[0]);
                        Field field = annotatedElement.getDeclaredField("findStyle");
                        field.setAccessible(true);
                        highlightStyle = (HighlightStyle)field.get(null);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        return;
                    }
                    highlightLayer.beginBlockUpdate();
                    try {
                        annotatedElement = null;
                        for (LexerToken lexerToken : backgroundParser.src) {
                            if (lexerToken.begin != n || !lexerToken.content.equalsIgnoreCase(string)) continue;
                            annotatedElement = lexerToken;
                            break;
                        }
                        if (annotatedElement == null) {
                            return;
                        }
                        for (LexerToken lexerToken : backgroundParser.src) {
                            if (lexerToken.end - lexerToken.begin != annotatedElement.end - annotatedElement.begin || lexerToken.type != annotatedElement.type || !lexerToken.content.equalsIgnoreCase(annotatedElement.content)) continue;
                            highlightLayer.addHighlight(highlightStyle, lexerToken.begin, lexerToken.end);
                        }
                    }
                    finally {
                        highlightLayer.endBlockUpdate();
                    }
                }
            };
            this.keydler = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (!keyEvent.isAltDown() || keyEvent.getKeyChar() != 'g') {
                        return;
                    }
                    String string = FindHighlightListener.this.editorPane.getSelectedText();
                    if (string == null || 50 < string.length()) {
                        int n = FindHighlightListener.this.editorPane.getSelectionStart();
                        LexerToken lexerToken = null;
                        for (LexerToken lexerToken2 : backgroundParser.src) {
                            if (lexerToken2.begin > n || n > lexerToken2.end) continue;
                            lexerToken = lexerToken2;
                            break;
                        }
                        if (lexerToken == null) {
                            return;
                        }
                        string = lexerToken.content;
                    }
                    String string2 = null;
                    if (FindHighlightListener.this.editor instanceof IDBEditor) {
                        string2 = ((IDBEditor)FindHighlightListener.this.editor).getConnectionName();
                    }
                    if (node instanceof PlSqlNode) {
                        string2 = ((PlSqlNode)node).getConnectionName();
                    }
                    if (string2 == null) {
                        return;
                    }
                    DockUtil.showDockableWindow((DockableView)NavSearchDockableFactory.getSearchWindow(string2, string));
                }
            };
            this.editorPane.addMouseListener(this.mouseler);
            this.editorPane.addKeyListener(this.keydler);
            this.editorPane.installPlugin((EditorPlugin)this.findPlugin);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FindHighlightListener.this.addListeners();
                }
            });
        }
    }

    public void editorDeactivated(Editor editor) {
        if (!"CodeEditor".equals(editor.getDisplayName()) && !"Worksheet".equals(editor.getDisplayName())) {
            return;
        }
        this.editor = null;
        if (this.editorPane != null) {
            this.editorPane.removeMouseListener(this.mouseler);
            this.editorPane.removeKeyListener(this.keydler);
            this.editorPane.deinstallPlugin((EditorPlugin)this.findPlugin);
        }
    }

    public void editorClosed(Editor editor) {
    }
}

