/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.SqlNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.compare.CompareIdeViewer;

public class PLSQLContextMenu
implements ContextMenuListener {
    private MenuFilter m_filter = new MenuFilter(){

        public boolean accept(Component component) {
            IdeAction ideAction;
            int n;
            Action action;
            return !(component instanceof JMenuItem) || !((action = ((JMenuItem)component).getAction()) instanceof IdeAction) || (n = (ideAction = (IdeAction)action).getCommandId()) != Ide.findCmdID((String)"RunSelectionCommand") && n != Ide.findOrCreateCmdID((String)"ContextMenuDebug") && n != Ide.findOrCreateCmdID((String)"ContextMenuRunCommand") && n != Ide.findOrCreateCmdID((String)"ContextMenuDebugCommand");
        }
    };

    public void menuWillShow(ContextMenu contextMenu) {
        Node node;
        CompareIdeViewer compareIdeViewer;
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 1 || elementArray.length == 2) {
            boolean bl = true;
            for (Element element : elementArray) {
                if (element instanceof PlSqlNode) continue;
                bl = false;
                break;
            }
            if (bl) {
                compareIdeViewer = CompareIdeViewer.getCompareIdeViewer();
                contextMenu.add((Component)compareIdeViewer.getContextCompareMenu());
            }
        }
        if ((node = PLSQLContextMenu.getSingleNode(context)) == null) {
            return;
        }
        this.maybeAddMenuFilter(contextMenu, node);
        compareIdeViewer = node.getShortLabel();
        if (compareIdeViewer != null && compareIdeViewer.toLowerCase().startsWith("anon_block")) {
            return;
        }
        if (!(node instanceof PlSqlNode) && !(node instanceof SqlNode)) {
            return;
        }
        URL uRL = node.getURL();
        if (uRL.toString().toLowerCase().startsWith("sqldev.migration")) {
            return;
        }
        if (node instanceof SqlNode) {
            Element element;
            IdeAction ideAction = IdeAction.find((int)PLSQLController.DEBUG_COMMAND);
            if (ideAction != null) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                ideAction.updateAction(context);
            }
            element = KeymapManager.getInstance();
            EditorKeyStrokes editorKeyStrokes = element.getEditorKeyStrokes();
            IdeAction ideAction2 = editorKeyStrokes.lookupAction("toggle-java-comments");
            ideAction2.setEnabled(true);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction2, JDeveloperMenuConstants.WEIGHT_SOURCE_MENU), JDeveloperMenuConstants.SECTION_WINDOW_CTXT_MENU);
            IdeAction ideAction3 = editorKeyStrokes.lookupAction("completion-insight");
            ideAction3.setEnabled(true);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction3, JDeveloperMenuConstants.WEIGHT_SOURCE_MENU), JDeveloperMenuConstants.SECTION_WINDOW_CTXT_MENU);
            IdeAction ideAction4 = editorKeyStrokes.lookupAction("block-indent");
            ideAction4.setEnabled(true);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction4, JDeveloperMenuConstants.WEIGHT_SOURCE_MENU), JDeveloperMenuConstants.SECTION_WINDOW_CTXT_MENU);
            IdeAction ideAction5 = editorKeyStrokes.lookupAction("block-outdent");
            ideAction5.setEnabled(true);
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction5, JDeveloperMenuConstants.WEIGHT_SOURCE_MENU), JDeveloperMenuConstants.SECTION_WINDOW_CTXT_MENU);
            return;
        }
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.DEBUG_COMMAND);
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.COMPILE_COMMAND);
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.COMPILE_DEBUG_COMMAND);
        this.addAndUpdateMenuItem(contextMenu, (PlSqlNode)node, PLSQLController.RUN_COMMAND);
    }

    public void menuWillHide(ContextMenu contextMenu) {
        contextMenu.removeMenuFilter(this.m_filter);
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addAndUpdateMenuItem(ContextMenu contextMenu, PlSqlNode plSqlNode, int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            String string;
            if (!(n != PLSQLController.RUN_COMMAND && n != PLSQLController.DEBUG_COMMAND || (string = (String)ideAction.getValue("Name")).endsWith("..."))) {
                ideAction.putValue("Name", (Object)(string + "..."));
            }
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
            PLSQLController.updateAction(ideAction, plSqlNode);
        }
    }

    private void maybeAddMenuFilter(ContextMenu contextMenu, Node node) {
        if (node instanceof PlSqlNode || node instanceof SqlNode) {
            contextMenu.addMenuFilter(this.m_filter);
        }
    }

    public static Node getSingleNode(Context context) {
        Element[] elementArray = context.getSelection();
        Node node = context.getNode();
        if (elementArray.length == 0) {
            return node;
        }
        if (elementArray.length == 1) {
            return node;
        }
        return node != elementArray[0] ? node : null;
    }
}

