/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.folding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.insight.Autoformat;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.util.Service;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.editor.language.NumberRange;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel
implements ParserEventListener {
    private static final int threshold = 2;

    public PlSqlFoldingModel(BasicDocument basicDocument, BackgroundParser backgroundParser) {
        super(basicDocument);
        backgroundParser.addParserEventListener(this);
        backgroundParser.addParserEventListener(new Autoformat());
        BasicDocument basicDocument2 = this.getDocument();
        TextBuffer textBuffer = basicDocument2.getTextBuffer();
        textBuffer.readLock();
        this.setRoot(new TypedFoldingBlock(0, textBuffer.getLength(), "", null));
        textBuffer.readUnlock();
    }

    public void reload(int n, int n2) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        PlSqlFoldingModel.updateFoldingBlock(typedFoldingBlock, n, n2);
        super.reload();
    }

    private static void updateFoldingBlock(TypedFoldingBlock typedFoldingBlock, int n, int n2) {
        if (typedFoldingBlock.getStartOffset() >= n) {
            typedFoldingBlock.setStartOffset(typedFoldingBlock.getStartOffset() + n2);
        }
        if (typedFoldingBlock.getEndOffset() >= n) {
            typedFoldingBlock.setEndOffset(typedFoldingBlock.getEndOffset() + n2);
        }
        LinkedList<TypedFoldingBlock> linkedList = new LinkedList<TypedFoldingBlock>();
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock2 = (TypedFoldingBlock)iterator.next();
            if (n2 < 0 && n <= typedFoldingBlock2.getStartOffset() && typedFoldingBlock2.getStartOffset() < n - n2) {
                linkedList.add(typedFoldingBlock2);
                continue;
            }
            PlSqlFoldingModel.updateFoldingBlock(typedFoldingBlock2, n, n2);
        }
        for (TypedFoldingBlock typedFoldingBlock2 : linkedList) {
            typedFoldingBlock.remove((FoldingBlock)typedFoldingBlock2);
        }
    }

    static void walkParseTree(String string, LineMap lineMap, LazyNode lazyNode, List<LexerToken> list, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, LazyNode lazyNode2, ArrayList<NumberRange> arrayList, int n) {
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        if (lazyNode == null) {
            return;
        }
        boolean bl = "cursor".equalsIgnoreCase(lazyNode.startToken);
        if ("select".equalsIgnoreCase(lazyNode.startToken) || bl) {
            LexerToken lexerToken2;
            LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
            int n2 = -1;
            boolean bl2 = bl;
            int n3 = -1;
            for (LexerToken lexerToken2 : list) {
                ++n2;
                if (bl2 && "is".equalsIgnoreCase(lexerToken2.content)) {
                    bl2 = false;
                    continue;
                }
                if (bl2 || lazyNode.from > n2 || n2 >= lazyNode.to) continue;
                if (n3 == -1) {
                    n3 = n2;
                }
                linkedList.add(lexerToken2);
            }
            if (5000 < linkedList.size()) {
                throw new AssertionError((Object)"Fragment too large");
            }
            if (0 == linkedList.size()) {
                return;
            }
            SqlEarley sqlEarley = SqlEarley.getInstance();
            lexerToken2 = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(linkedList, (Matrix)lexerToken2);
            ParseNode parseNode = sqlEarley.forest(linkedList, (Matrix)lexerToken2);
            parseNode.moveInterval(n3);
            PlSqlFoldingModel.walkParseTree(string, lineMap, parseNode, list, typedFoldingBlock3, typedFoldingBlock2, arrayList, n);
            return;
        }
        if (lazyNode.isStmt(lazyNode2) || lazyNode.isProcedure()) {
            int n4;
            int n5;
            Object object = list.get(lazyNode.from);
            int n6 = n5 = ((LexerToken)object).begin;
            object = list.get(lazyNode.to - 1);
            int n7 = n4 = ((LexerToken)object).end;
            for (NumberRange numberRange : arrayList) {
                if (n6 >= numberRange.start) {
                    n6 += numberRange.end - numberRange.start;
                }
                if (n7 < numberRange.start) continue;
                n7 += numberRange.end - numberRange.start;
            }
            int n8 = PlSqlFoldingModel.lineDiff(lineMap, n6, n7);
            if (n8 > 2) {
                TypedFoldingBlock typedFoldingBlock4;
                int n9 = string.length() - n5 < 127 ? string.length() : n5 + 128;
                String string2 = string.substring(n5, n9);
                int n10 = string2.indexOf(10);
                if (n10 > 0) {
                    string2 = string2.substring(0, n10);
                }
                typedFoldingBlock3 = new TypedFoldingBlock(n6, n7, string2 + "...", (ParseNode)lazyNode);
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                if (typedFoldingBlock2 != null && (typedFoldingBlock4 = PlSqlFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n)) != null) {
                    typedFoldingBlock3.setExpanded(typedFoldingBlock4.isExpanded());
                }
            }
        }
        for (ParseNode parseNode : lazyNode.shallowChildren()) {
            PlSqlFoldingModel.walkParseTree(string, lineMap, (LazyNode)parseNode, list, typedFoldingBlock3, typedFoldingBlock2, lazyNode2, arrayList, n);
        }
    }

    private static void walkParseTree(String string, LineMap lineMap, ParseNode parseNode, List<LexerToken> list, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, ArrayList<NumberRange> arrayList, int n) {
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        if (parseNode == null) {
            return;
        }
        if (parseNode.contains(IdentifiersDb.instance.subquery)) {
            int n2;
            int n3;
            LexerToken lexerToken = list.get(parseNode.from);
            int n4 = n3 = lexerToken.begin;
            lexerToken = list.get(parseNode.to - 1);
            int n5 = n2 = lexerToken.end;
            for (NumberRange numberRange : arrayList) {
                if (n4 >= numberRange.start) {
                    n4 += numberRange.end - numberRange.start;
                }
                if (n5 < numberRange.start) continue;
                n5 += numberRange.end - numberRange.start;
            }
            int n6 = PlSqlFoldingModel.lineDiff(lineMap, n4, n5);
            if (n6 > 2) {
                TypedFoldingBlock typedFoldingBlock4;
                int n7 = string.length() - n3 < 127 ? string.length() : n3 + 128;
                String string2 = string.substring(n3, n7);
                int n8 = string2.indexOf(10);
                if (n8 > 0) {
                    string2 = string2.substring(0, n8);
                }
                typedFoldingBlock3 = new TypedFoldingBlock(n4, n5, string2 + "...", parseNode);
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                if (typedFoldingBlock2 != null && (typedFoldingBlock4 = PlSqlFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n)) != null) {
                    typedFoldingBlock3.setExpanded(typedFoldingBlock4.isExpanded());
                }
            }
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            PlSqlFoldingModel.walkParseTree(string, lineMap, parseNode2, list, typedFoldingBlock3, typedFoldingBlock2, arrayList, n);
        }
    }

    private static int lineDiff(LineMap lineMap, int n, int n2) {
        int n3 = lineMap.getLineFromOffset(n);
        int n4 = lineMap.getLineFromOffset(n2);
        return n4 - n3;
    }

    public static void print(DefaultFoldingBlock defaultFoldingBlock, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("[" + defaultFoldingBlock.getStartOffset() + "," + defaultFoldingBlock.getEndOffset() + ") " + defaultFoldingBlock.getClass().getName());
        Iterator iterator = defaultFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            PlSqlFoldingModel.print((TypedFoldingBlock)iterator.next(), n + 1);
        }
    }

    private static boolean isShifted(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == n && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == n) {
            return true;
        }
        return typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == 0 && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == 0;
    }

    public static TypedFoldingBlock searchShiftedBlock(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (PlSqlFoldingModel.isShifted(typedFoldingBlock, typedFoldingBlock2, n)) {
            return typedFoldingBlock;
        }
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock3 = (TypedFoldingBlock)iterator.next();
            TypedFoldingBlock typedFoldingBlock4 = PlSqlFoldingModel.searchShiftedBlock(typedFoldingBlock3, typedFoldingBlock2, n);
            if (typedFoldingBlock4 == null) continue;
            return typedFoldingBlock4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        TypedFoldingBlock typedFoldingBlock2 = new TypedFoldingBlock(0, backgroundParser.text != null ? backgroundParser.text.length() : 0, "", null);
        int n = typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset();
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.readLock();
        LineMap lineMap = null;
        try {
            lineMap = textBuffer.getLineMap();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            return;
        }
        finally {
            textBuffer.readUnlock();
        }
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        for (LexerToken lexerToken : backgroundParser.src) {
            arrayList.add(lexerToken);
        }
        PlSqlFoldingModel.walkParseTree(backgroundParser.text, lineMap, backgroundParser.output, arrayList, typedFoldingBlock2, typedFoldingBlock, backgroundParser.output, backgroundParser.increments, n);
        this.setRoot(typedFoldingBlock2);
        PlSqlFoldingModel.super.reload();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(StackParser.class, (String)"test.sql");
        long l = System.currentTimeMillis();
        List list = LexerToken.parse((String)string);
        long l2 = System.currentTimeMillis();
        System.out.println("time = " + (l2 - l));
        LazyNode lazyNode = StackParser.getInstance().parse(list);
    }

    static class TypedFoldingBlock
    extends DefaultFoldingBlock
    implements Comparable {
        ParseNode src;

        public TypedFoldingBlock(int n, int n2, String string, ParseNode parseNode) {
            super(n, n2, string, true);
            this.src = parseNode;
        }

        public List<TypedFoldingBlock> descendants() {
            LinkedList<TypedFoldingBlock> linkedList = new LinkedList<TypedFoldingBlock>();
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)iterator.next();
                linkedList.addAll(typedFoldingBlock.descendants());
            }
            linkedList.add(this);
            return linkedList;
        }

        public String toString() {
            return "[" + this.getStartOffset() + "," + this.getEndOffset() + ") " + this.getReplacementText();
        }

        public int compareTo(Object object) {
            TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)object;
            if (this.getStartOffset() != typedFoldingBlock.getStartOffset()) {
                return this.getStartOffset() - typedFoldingBlock.getStartOffset();
            }
            if (this.getStartOffset() != typedFoldingBlock.getStartOffset()) {
                return this.getEndOffset() - typedFoldingBlock.getEndOffset();
            }
            return 0;
        }

        public void setExpanded(boolean bl) {
            super.setExpanded(bl);
        }
    }
}

