/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class LocationListener
implements EditorListener {
    private MouseListener handler;
    private BasicEditorPane editorPane;
    private Editor editor;

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        if (!"CodeEditor".equals(editor.getDisplayName()) && !"Worksheet".equals(editor.getDisplayName())) {
            return;
        }
        this.editor = editor;
        this.addListeners();
    }

    private void addListeners() {
        if (null == this.editor) {
            return;
        }
        this.editorPane = ((BasicEditorPaneContainer)this.editor).getFocusedEditorPane();
        if (this.editorPane != null) {
            EquippedWithParser equippedWithParser = null;
            Node node = this.editor.getContext().getNode();
            if (node instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)node;
            } else if (this.editor instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)this.editor;
            }
            if (equippedWithParser == null) {
                return;
            }
            BackgroundParser backgroundParser = equippedWithParser.getParser();
            this.handler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 1) {
                        return;
                    }
                    int n = LocationListener.this.editorPane.getCaretPosition();
                    OutlinePanel outlinePanel = (OutlinePanel)OutlineWindow.getInstance().getGUI();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)outlinePanel.model.getRoot();
                    int n2 = outlinePanel.model.getChildCount(defaultMutableTreeNode);
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)outlinePanel.model.getChild(defaultMutableTreeNode, i);
                        if (!(defaultMutableTreeNode2.getUserObject() instanceof Member)) continue;
                        Member member = (Member)defaultMutableTreeNode2.getUserObject();
                        if (n3 <= n && n < member.codeOffset) {
                            outlinePanel.current = i;
                            outlinePanel.repaint();
                            return;
                        }
                        n3 = member.codeOffset;
                    }
                    if (n3 <= n) {
                        outlinePanel.current = n2;
                        outlinePanel.repaint();
                    }
                }
            };
            this.editorPane.addMouseListener(this.handler);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocationListener.this.addListeners();
                }
            });
        }
    }

    public void editorDeactivated(Editor editor) {
        if (!"CodeEditor".equals(editor.getDisplayName()) && !"Worksheet".equals(editor.getDisplayName())) {
            return;
        }
        this.editor = null;
        if (this.editorPane != null) {
            this.editorPane.removeMouseListener(this.handler);
        }
    }

    public void editorClosed(Editor editor) {
    }
}

