/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class Inliner
extends UndoableRefactoring {
    static final String path = "/oracle/dbtools/raptor/refactor/";
    static Parsed prg = null;
    static IProgram program = null;

    public Inliner(Context context) {
        super(context);
    }

    @Override
    protected Replacements runProgram(int n) {
        return this.runProgram(n, this.text, this.src, this.p);
    }

    private Replacements runProgram(int n, String string, List<LexerToken> list, BasicEditorPane basicEditorPane) {
        long l = System.currentTimeMillis();
        try {
            ParseNode parseNode9;
            int n2;
            int n3;
            ParseNode parseNode2;
            int n4;
            String string22;
            ParseNode parseNode3;
            if (prg == null) {
                prg = new Parsed(Service.readFile(Inliner.class, (String)"/oracle/dbtools/raptor/refactor/inline.prg"), Program.getArboriParser(), "program");
            }
            Parsed parsed = new Parsed(string, list, (Earley)SqlEarley.getInstance(), "sql_statement");
            if (program == null) {
                program = new IProgram();
                Program.debug = false;
                parseNode3 = prg.getRoot();
                program.program(parseNode3, prg.getSrc(), prg.getInput());
            }
            Inliner.program.offset = LexerToken.scanner2parserOffset(list, (int)n);
            System.out.println(Inliner.program.offset);
            parseNode3 = list.get(Inliner.program.offset);
            if (basicEditorPane != null) {
                int n5;
                int n6 = basicEditorPane.getLineFromOffset(n);
                if (n6 < (n5 = basicEditorPane.getLineFromOffset(parseNode3.begin))) {
                    --Inliner.program.offset;
                }
                parseNode3 = list.get(Inliner.program.offset);
                n5 = basicEditorPane.getLineFromOffset(parseNode3.begin);
                if (n6 < n5) {
                    --Inliner.program.offset;
                }
            }
            System.out.println(parseNode3);
            String string3 = parseNode3.content;
            Map map = null;
            try {
                map = program.eval(parsed);
            }
            catch (AssertionError assertionError) {
                if (((Throwable)((Object)assertionError)).getMessage().contains("syntactically invalid")) {
                    String string4 = Messages.getString("SyntaxErrorMsg");
                    SyntaxError syntaxError = parsed.getSyntaxError();
                    if (syntaxError != null) {
                        string4 = syntaxError.getDetailedMessage();
                    }
                    MessageDialog.information(null, (Object)string4, (String)Messages.getString("ErrorTitle"), null);
                }
                System.out.println("Refactoring aborted due to " + ((Throwable)((Object)assertionError)).getMessage());
                return null;
            }
            for (String string22 : map.keySet()) {
                System.out.println(string22 + "=" + ((MaterializedPredicate)map.get(string22)).toString(string22.length() + 1));
            }
            ParseNode parseNode4 = null;
            string22 = null;
            boolean bl = false;
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("\"proc/call\"");
            MaterializedPredicate materializedPredicate2 = (MaterializedPredicate)map.get("\"prm val\"");
            MaterializedPredicate materializedPredicate3 = (MaterializedPredicate)map.get("\"prm decl\"");
            if (materializedPredicate.cardinality() == 0) {
                int n7 = 0;
                MaterializedPredicate materializedPredicate4 = (MaterializedPredicate)map.get("\"proc\"");
                if (n7 < materializedPredicate4.cardinality()) {
                    ParseNode parseNode5 = materializedPredicate4.getAttribute(n7, "id");
                    string3 = parseNode5.content(list);
                }
                String string5 = Messages.getString("NoCalls") + " " + string3;
                MessageDialog.information(null, (Object)string5, (String)Messages.getString("ErrorTitle"), null);
                return null;
            }
            int n8 = materializedPredicate3.cardinality();
            TreeMap treeMap = new TreeMap();
            MaterializedPredicate materializedPredicate5 = (MaterializedPredicate)map.get("\"pc+fml\"");
            for (n4 = 0; n4 < materializedPredicate.cardinality(); ++n4) {
                ParseNode parseNode6;
                parseNode2 = materializedPredicate.getAttribute(n4, "call");
                string3 = parseNode2.content(list);
                parseNode4 = materializedPredicate.getAttribute(n4, "body");
                bl = materializedPredicate.getAttribute(n4, "f").contains(SqlEarley.getInstance().getSymbol("'FUNCTION'"));
                if (bl) {
                    MessageDialog.information(null, (Object)Messages.getString("CantInlineFunction"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode4.from <= parseNode2.from && parseNode2.to <= parseNode4.to) {
                    MessageDialog.information(null, (Object)Messages.getString("RecursiveInvocationMsg"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode2.from <= Inliner.program.offset && Inliner.program.offset <= parseNode2.to) {
                    string22 = parseNode2;
                }
                TreeMap<ParseNode, ParseNode> treeMap2 = new TreeMap<ParseNode, ParseNode>();
                ParseNode parseNode7 = null;
                for (n3 = 0; n3 < materializedPredicate5.cardinality(); ++n3) {
                    parseNode6 = materializedPredicate5.getAttribute(n3, "call");
                    if (parseNode2.from != parseNode6.from || parseNode2.to != parseNode6.to) continue;
                    parseNode7 = materializedPredicate5.getAttribute(n3, "paren_expr_list");
                    break;
                }
                if (parseNode7 != null) {
                    for (n3 = 0; n3 < materializedPredicate2.cardinality(); ++n3) {
                        parseNode6 = materializedPredicate2.getAttribute(n3, "arg");
                        if (parseNode7.from > parseNode6.from || parseNode6.to > parseNode7.to) continue;
                        ParseNode parseNode8 = materializedPredicate3.getAttribute(n3 % n8, "prm_spec");
                        treeMap2.put(parseNode6, parseNode8);
                    }
                }
                treeMap.put(parseNode2, treeMap2);
            }
            System.out.println("Inline time = " + (System.currentTimeMillis() - l));
            int n9 = n4 = string22 != null ? 1 : treeMap.size();
            if (!MessageDialog.confirm(null, (Object)MessageFormat.format(Messages.getString("Replace"), n4, list.get((int)(parseNode4.from + 1)).content), (String)Messages.getString("InlineProcedure"), null)) {
                return null;
            }
            parseNode2 = new Replacements(string);
            int n10 = list.get((int)parseNode4.from).begin;
            int n11 = string.substring(0, n10).lastIndexOf(10) + 1;
            if (n11 < 0) {
                n11 = 0;
            }
            if ((n2 = (n3 = list.get((int)(parseNode4.to - 1)).end) + string.substring(n3).indexOf(10) + 1) < 0) {
                n2 = n3;
            }
            if (materializedPredicate.cardinality() == ((MaterializedPredicate)map.get("\"all calls\"")).cardinality() && this.notPublic(string3)) {
                parseNode2.put(n11, n2, "");
            }
            int n12 = n10 - n11;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n12; ++i) {
                stringBuffer.append(' ');
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Object> iterator = parseNode4.children().iterator();
            while (iterator.hasNext() && !(parseNode9 = (ParseNode)iterator.next()).contains(IdentifiersDb.instance.decl_id)) {
                if (parseNode9.contains(IdentifiersDb.instance.subprg_spec) || parseNode9.contains(SqlEarley.getInstance().getSymbol("'IS'")) || parseNode9.contains(SqlEarley.getInstance().getSymbol("'AS'"))) continue;
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(Inliner.padFromNL2Pos(list.get((int)parseNode9.from).begin, string));
                }
                stringBuilder.append(string.substring(list.get((int)parseNode9.from).begin, list.get((int)parseNode9.to).begin));
            }
            stringBuilder.append(";");
            for (ParseNode parseNode9 : treeMap.keySet()) {
                int n13;
                Map map2 = (Map)treeMap.get(parseNode9);
                String string6 = stringBuffer + "declare\n" + stringBuilder.toString();
                for (ParseNode parseNode10 : map2.keySet()) {
                    ParseNode parseNode11 = (ParseNode)map2.get(parseNode10);
                    String string7 = list.get((int)parseNode11.from).content;
                    String string8 = list.get((int)parseNode10.from).content;
                    string6 = string6.replace(string7, string8);
                }
                ParseNode parseNode12 = parsed.getRoot().parent(parseNode9.from, parseNode9.to);
                if (!parseNode12.contains(SqlEarley.getInstance().getSymbol("stmt"))) {
                    parseNode12 = parsed.getRoot().parent(parseNode12.from, parseNode12.to);
                }
                if ((n13 = string.substring(0, n10 = list.get((int)parseNode12.from).begin).lastIndexOf(10) + 1) < 0) {
                    n13 = 0;
                }
                parseNode2.put(n13, list.get((int)(parseNode12.to - 1)).end, Inliner.indentLines(n10 - n13 - n12, string6));
            }
            return parseNode2;
        }
        catch (Exception exception) {
            System.err.println("Exception caught during inline: ");
            exception.printStackTrace();
            return null;
        }
    }

    private boolean notPublic(String string) {
        if (this.plsNode == null) {
            return true;
        }
        URL uRL = this.plsNode.getURL();
        String string2 = DBURLFormatHelper.getBaseType(uRL);
        URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string2.substring(0, string2.indexOf(32))), DBURLFormatHelper.getName(uRL));
        PlSqlNode plSqlNode = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode(uRL2);
        if (plSqlNode == null) {
            return true;
        }
        for (Member member : plSqlNode.parseMembers()) {
            if (!member.name.equals(string)) continue;
            return false;
        }
        return true;
    }

    public static String indentLines(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().intern();
            stringBuffer2.append(string2);
            if (!"\n".equals(string2)) continue;
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    private static String padFromNL2Pos(int n, String string) {
        int n2 = string.substring(0, n).lastIndexOf(10) + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - n2; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(Inliner.class, (String)"testInline.sql");
        Parsed parsed = new Parsed(string, (Earley)SqlEarley.getInstance(), "sql_statements");
        parsed.getRoot().printTree();
        int n = parsed.getInput().indexOf("p; --");
        Replacements replacements = new Inliner(null).runProgram(n, parsed.getInput(), parsed.getSrc(), null);
        if (replacements == null) {
            return;
        }
        System.out.println(replacements.toString());
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        IProgram() {
        }
    }
}

