/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.raptor.navigator.plsql.LocationComparator;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public abstract class UndoableRefactoring
extends Command {
    protected UndoableEdit _undoableEdit;
    protected String text;
    protected List<LexerToken> src;
    protected LazyNode root;
    protected BasicEditorPane p;
    protected PlSqlNode plsNode;

    public UndoableRefactoring(Context context) {
        super(-1, 0, "My Changes");
        Context context2 = new Context(context);
        this.setContext(context2);
        Node node = context.getNode();
        View view = context.getView();
        this.p = ((BasicEditorPaneContainer)view).getFocusedEditorPane();
        if (node instanceof PlSqlNode) {
            this.plsNode = (PlSqlNode)node;
            this.root = this.plsNode.getParser().output;
            this.src = this.plsNode.getParser().src;
            this.text = this.plsNode.getParser().text;
        } else if (view instanceof BasicEditorPaneContainer && view instanceof EquippedWithParser) {
            BackgroundParser backgroundParser = ((EquippedWithParser)view).getParser();
            this.root = backgroundParser.output;
            this.src = backgroundParser.src;
            this.text = backgroundParser.text;
            PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
            plsqlStructureParser.parse(this.src, new LocationComparator());
        }
    }

    protected abstract Replacements runProgram(int var1);

    public int doit() throws Exception {
        if (this._undoableEdit == null) {
            int n = this.p.getCaretPosition();
            Replacements replacements = this.runProgram(n);
            if (replacements == null) {
                return 0;
            }
            TextNode textNode = (TextNode)this.context.getNode();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            this._undoableEdit = replacements.modify(textBuffer);
            textNode.releaseTextBuffer();
            return 0;
        }
        this._undoableEdit.redo();
        return 0;
    }

    public int undo() throws Exception {
        this._undoableEdit.undo();
        return 0;
    }
}

