/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.dbtools.raptor.runner.InvalidData;
import oracle.dbtools.raptor.runner.Messages;
import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.Type;
import oracle.dbtools.util.Service;
import oracle.ide.util.FastStringBuffer;

class Parameter {
    private static final String NULL_VALUE = "NULL";
    private static final String FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    private static final char CHAR_SINGLE_QUOTE = '\'';
    private static final String STRING_SINGLE_QUOTE = "'";
    private static final String STRING_SINGLE_QUOTE2 = "''";
    private String _name;
    private String _varName;
    private Type _type;
    private Mode _mode;
    private boolean _default;
    private boolean _return;
    private Object _value = "NULL";
    private static final String self = "THIS";
    static final String TO_DATE = "to_date('";
    static final String COMMA = "','";
    boolean isOutputBound = false;

    Parameter(Type type) {
        this._name = "<Return Value>";
        this._varName = "v_Return";
        this._type = type;
        this._mode = Mode.OUT;
        this._default = false;
        this._return = true;
    }

    Parameter(String string, Type type, Mode mode, boolean bl) {
        this._name = string;
        this._varName = string;
        this._type = type;
        this._mode = mode;
        this._default = bl;
        this._return = false;
    }

    public Parameter(Type type, int n) {
        this._name = self;
        this._varName = self;
        this._type = type;
        this._mode = Mode.IN_OUT;
        this._default = false;
        this._return = false;
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < n; ++i) {
            if (0 < i) {
                stringBuilder.append(COMMA);
            }
            stringBuilder.append("null");
        }
        this._value = this._type.getTypeName() + stringBuilder.toString() + ")";
    }

    boolean isObjectInstance() {
        return self.equals(this._name);
    }

    public boolean isReturn() {
        return this._return;
    }

    public boolean isDefaultProvided() {
        return this._default;
    }

    public String getVarName() {
        return this._varName;
    }

    public Type getType() {
        return this._type;
    }

    public String getParamName() {
        return this._name;
    }

    public Mode getMode() {
        return this._mode;
    }

    public void generateDeclaration(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" ");
        fastStringBuffer.append(this._type.getTypeName());
        fastStringBuffer.append(";\n");
    }

    public void generateInitialization(FastStringBuffer fastStringBuffer) {
        if (this._type.isOutputSupported() || self.equals(this._name)) {
            fastStringBuffer.append("  ");
        } else {
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- Modify the code to initialize the variable\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- ");
        }
        fastStringBuffer.append(this._varName);
        try {
            fastStringBuffer.append(" := " + this.formatValue() + ";\n");
        }
        catch (InvalidData invalidData) {
            fastStringBuffer.append(" := NULL;\n");
        }
    }

    String formatValue() throws InvalidData {
        if (this._value == null || NULL_VALUE.equalsIgnoreCase(this._value.toString())) {
            return NULL_VALUE;
        }
        Integer n = this.getType().getSqlType();
        if (n == null) {
            return this._value.toString();
        }
        switch (n) {
            case 12: {
                String string;
                String string2 = this.getType().getTypeName();
                int n2 = string2.indexOf(40);
                if (0 < n2 && Integer.parseInt(string = string2.substring(n2 + 1, string2.length() - 1)) < this._value.toString().length()) {
                    throw new InvalidData(this.getVarName(), this._type.getTypeName() + " " + Messages.getString("WrongCharFormat"));
                }
                return this.getEscapedVarchar(this._value.toString());
            }
            case 91: {
                String string = FORMAT_YYYY_MM_DD;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                simpleDateFormat.setLenient(false);
                try {
                    Date date = simpleDateFormat.parse(this._value.toString());
                    if (date == null) {
                        throw new InvalidData(this.getVarName(), Messages.getString("WrongDateFormat"));
                    }
                }
                catch (ParseException parseException) {
                    throw new InvalidData(this.getVarName(), Messages.getString("WrongDateFormat"));
                }
                return TO_DATE + this._value.toString() + COMMA + string + "')";
            }
            case 2: {
                try {
                    BigDecimal bigDecimal = new BigDecimal(this._value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidData(this.getVarName(), Messages.getString("WrongNumberFormat"));
                }
                return this._value.toString();
            }
        }
        return this._value.toString();
    }

    void setUnFormattedValue(String string) {
        Type type = this.getType();
        if (type == null) {
            System.err.println("type == null for _name=" + this._name + " _varName=" + this._varName);
            this.setValue(string);
            return;
        }
        Integer n = type.getSqlType();
        if (n == null) {
            System.err.println("sqlType == null for _name=" + this._name + " _varName=" + this._varName);
            this.setValue(string);
            return;
        }
        switch (n) {
            case 12: {
                String string2 = string;
                if (string2.startsWith(STRING_SINGLE_QUOTE)) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith(STRING_SINGLE_QUOTE)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                this.setValue(string2);
                return;
            }
            case 91: {
                String string3 = string;
                if (string3.startsWith(TO_DATE)) {
                    string3 = string3.substring(TO_DATE.length());
                }
                if (0 < string.indexOf(COMMA)) {
                    string3 = string3.substring(0, string3.indexOf(COMMA));
                }
                this.setValue(string3);
                return;
            }
            case 2: {
                this.setValue(string);
                return;
            }
        }
        this.setValue(string);
    }

    public void generateCallReference(FastStringBuffer fastStringBuffer) {
        if (self.equals(this._name)) {
            return;
        }
        fastStringBuffer.append("  ");
        fastStringBuffer.append(Service.addDoubleQuote((String)this._name));
        fastStringBuffer.append(" => ");
        fastStringBuffer.append(this._varName);
    }

    public void generateResultOutput(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append("/* Legacy output: \n");
        if ("BOOLEAN".equals(this._type.getTypeName())) {
            fastStringBuffer.append("IF (").append(this._varName).append(") THEN \n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(" = ' || ");
            fastStringBuffer.append("'TRUE');\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("ELSE\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(" = ' || ");
            fastStringBuffer.append("'FALSE');\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("END IF;\n");
        } else {
            fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(" = ' || ");
            fastStringBuffer.append(this._varName);
            fastStringBuffer.append(");\n");
        }
        fastStringBuffer.append("*/ \n");
        fastStringBuffer.append("  ");
        if (this._type.getSqlType() == null) {
            fastStringBuffer.append("--");
        }
        fastStringBuffer.append(":");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" := ");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(";");
        if ("REF CURSOR".equals(this._type.getDeclaredName())) {
            fastStringBuffer.append(" --<-- Cursor");
        }
        fastStringBuffer.append("\n");
    }

    public boolean isOutputBound() {
        return this.isOutputBound;
    }

    public void setOutputBound(boolean bl) {
        this.isOutputBound = bl;
    }

    public Object getValue() {
        if (this.getMode() == Mode.IN || this.getMode() == Mode.IN_OUT) {
            return this._value == null ? NULL_VALUE : this._value;
        }
        return "N/A";
    }

    public void setValue(Object object) {
        this._value = object;
    }

    public void editType(String string) {
        this._type.setTypeName(string);
    }

    private String getEscapedVarchar(String string) {
        String string2 = string.replace(STRING_SINGLE_QUOTE, STRING_SINGLE_QUOTE2);
        return '\'' + string2 + '\'';
    }
}

