/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaResource;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.runner.InvalidData;
import oracle.dbtools.raptor.runner.Messages;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.dbtools.raptor.runner.PlSqlWrapperValidator;
import oracle.dbtools.raptor.runner.Procedure;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Pair;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DirOptionsArb;
import oracle.ide.runner.Debugger;
import oracle.ide.util.FileUtilities;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.layout.BoxLayout2;
import oracle.jdevimpl.runner.debug.JDebuggerSingleton;
import oracle.sql.CLOB;

public class PlSqlRunnerPanel
extends JPanel {
    private static Map<String, PlSqlWrapperValidator> s_validators = new HashMap<String, PlSqlWrapperValidator>();
    private static QueryXMLSupport s_xmlSupport;
    private BorderLayout m_layMain = new BorderLayout();
    private JSplitPane m_splContent = new JSplitPane();
    private JSplitPane m_splTop = new JSplitPane();
    private JPanel m_pnlTarget = new JPanel();
    private JPanel m_pnlParams = new JPanel();
    private JPanel m_pnlBlock = new JPanel();
    private GridBagLayout m_layTarget = new GridBagLayout();
    private JLabel m_lblTarget = new JLabel();
    private JScrollPane m_scrTarget = new JScrollPane();
    private JList m_lstTarget = new JList();
    private GridBagLayout m_layParams = new GridBagLayout();
    private JLabel m_lblParams = new JLabel();
    private JScrollPane m_scrParams = new JScrollPane();
    private GridBagLayout m_layBlock = new GridBagLayout();
    private JScrollPane m_scrBlock = new JScrollPane();
    private JTable m_tblParams = new JTable(){
        TableCellEditor col3Editor = null;

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 3) {
                if (this.col3Editor != null) {
                    return this.col3Editor;
                }
                String string = (String)this.getValueAt(n, 1);
                this.col3Editor = super.getCellEditor(n, n2);
                this.col3Editor.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingCanceled(ChangeEvent changeEvent) {
                    }

                    @Override
                    public void editingStopped(ChangeEvent changeEvent) {
                        PlSqlRunnerPanel.this.refreshCode();
                    }
                });
                return this.col3Editor;
            }
            return super.getCellEditor(n, n2);
        }
    };
    private TableColumnModel m_colMdl = new DefaultTableColumnModel();
    private BasicEditorPane m_txtBlock = EditorFactory.createIdeEditorPane();
    private JLabel m_lblBlock = new JLabel();
    private ListSelectionModel m_selModel = new DefaultListSelectionModel();
    private JButton m_btnReset = new JButton();
    private JButton m_btnFromFile = new JButton();
    private JButton m_btnToFile = new JButton();
    private Component m_glue = Box.createHorizontalGlue();
    private JPanel m_pnlButtons = new JPanel();
    private BoxLayout2 m_layButtons = new BoxLayout2();
    private TableColumn m_colName = new TableColumn();
    private TableColumn m_colType = new TableColumn();
    private TableColumn m_colMode = new TableColumn();
    private TableColumn m_colValue = new TableColumn();
    PlSqlNode m_node;
    private JEWTDialog m_dlg;
    private static final String PROC_QUERY = "SELECT OBJECT_ID FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ?";
    private static final String TRIGGER_QUERY = "SELECT t.triggering_event, o.object_id, o.object_name, o.owner  \nFROM SYS.ALL_TRIGGERS T, SYS.ALL_OBJECTS O \nWHERE T.OWNER = ? AND TRIGGER_NAME = ? \nand t.table_owner = o.owner and t.table_name = o.object_name and t.base_object_type = o.object_type";
    private CodeEditor editor = null;
    private PlSqlNode anonymousNode = null;
    private static Map<String, URL> persistedBlocks;
    private CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            PlSqlRunnerPanel.this.refreshTableModel();
        }
    };
    public static final String anonBlock = "anon_block";

    public static void registerValidator(String string, PlSqlWrapperValidator plSqlWrapperValidator) {
        s_validators.put(string, plSqlWrapperValidator);
    }

    private static QueryXMLSupport getXMLSupport() {
        if (s_xmlSupport == null) {
            s_xmlSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(PlSqlRunnerPanel.class.getClassLoader(), "/oracle/dbtools/raptor/runner/source.xml"));
        }
        return s_xmlSupport;
    }

    public PlSqlRunnerPanel(PlSqlNode plSqlNode) {
        this.m_node = plSqlNode;
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_plsql_html");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    String getTitle() {
        return RunnerArb.getString("RUN_DIALOG_TITLE");
    }

    void setCommentsReturn() {
    }

    public TextBuffer runDialog() {
        String string = (String)this.m_node.getProperty("INVALID");
        if (Boolean.parseBoolean(string)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)RunnerArb.getString("INVALID_PROGRAM_MSG"), (String)RunnerArb.getString("INVALID_PROGRAM_TITLE"), null);
            return null;
        }
        String string2 = this.getTitle();
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.m_lstTarget, (String)string2);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !PlSqlRunnerPanel.this._commit()) {
                    throw new PropertyVetoException("no", propertyChangeEvent);
                }
            }
        });
        jEWTDialog.setResizable(true);
        jEWTDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                PlSqlRunnerPanel.this.init();
            }
        });
        this.m_dlg = jEWTDialog;
        TextBuffer textBuffer = null;
        try {
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                BasicDocument basicDocument = (BasicDocument)this.m_txtBlock.getDocument();
                textBuffer = basicDocument.getTextBuffer();
                this.setCommentsReturn();
                Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
                DBStarterFactory.PlSqlStarter.paramTableModel = procedure.getTableModel();
                procedure.persistRollback(textBuffer.getString(0, textBuffer.getLength()));
                if (this.anonymousNode != null) {
                    this.anonymousNode.save();
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(PlSqlRunnerPanel.class.getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (IOException iOException) {
            Logger.getLogger(PlSqlRunnerPanel.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return textBuffer;
    }

    private void refreshTableModel() {
        Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
        String string = this.m_txtBlock.getText();
        try {
            Map<String, Pair<String, String>> map = procedure.parseAnonBlock(string);
            ParamTableModel paramTableModel = procedure.getTableModel();
            for (String string2 : map.keySet()) {
                paramTableModel.editParam(string2, (String)map.get(string2).first(), (String)map.get(string2).second());
            }
        }
        catch (InvalidData invalidData) {
            System.out.println("InvalidData @col " + invalidData.name);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void refreshCode() {
        Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
        String string = this.m_txtBlock.getText();
        try {
            StringBuilder stringBuilder = procedure.updateAnonBlock(string);
            if (stringBuilder != null) {
                String string2 = stringBuilder.toString();
                this.m_txtBlock.setText(string2);
            }
        }
        catch (InvalidData invalidData) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)invalidData.msg, (String)Messages.getString("WrongFormat"), null);
            try {
                ParamTableModel paramTableModel = procedure.getTableModel();
                paramTableModel.editParam(invalidData.name, invalidData.priorValue, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        if (this.editor != null) {
            this.editor.close();
            ((JDebuggerSingleton)Debugger.getDebugger()).editorClosed((Editor)this.editor);
            this.editor = null;
        }
        this.m_txtBlock.dispose();
    }

    private void _updateOK(boolean bl) {
        this.m_dlg.setOKButtonEnabled(bl);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.min(dimension.width, 600), dimension.height);
    }

    public void setNode(PlSqlNode plSqlNode) {
        this.m_node = plSqlNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Procedure.resetDefaultParamMap();
        DefaultListModel<Procedure> defaultListModel = new DefaultListModel<Procedure>();
        String string = this.m_node.getType();
        PlSqlNode plSqlNode = null;
        try {
            Connection connection;
            Object object;
            String string2;
            TextBuffer textBuffer = null;
            PlsqlRoot plsqlRoot = null;
            URL uRL = this.m_node.getURL();
            if (!DBURLFormatHelper.isDBURL(uRL)) {
                uRL = this.m_node.matchingDbUrl();
            }
            if ((string2 = DBURLFormatHelper.getBaseType(uRL)).equals("PACKAGE BODY")) {
                object = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string2.substring(0, string2.indexOf(32))), DBURLFormatHelper.getName(uRL));
                plSqlNode = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode((URL)object);
                textBuffer = plSqlNode.acquireTextBuffer();
                plsqlRoot = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
            } else {
                textBuffer = this.m_node.acquireTextBuffer();
                plsqlRoot = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
            }
            object = DBURLFormatHelper.getSchema(uRL);
            String string3 = DBURLFormatHelper.getName(uRL);
            Database database = PlSqlRunnerPanel.getDatabase(this.m_node);
            Connection connection2 = connection = database.getConnection();
            synchronized (connection2) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string)) {
                        Query query = PlSqlRunnerPanel.getXMLSupport().getQuery("Runner.CompilationUnit", connection);
                        statement = connection.prepareStatement(query.getSql());
                        statement.setString(1, (String)object);
                        statement.setString(2, string3);
                        statement.setString(3, "PACKAGE");
                        resultSet = statement.executeQuery();
                        while (resultSet.next()) {
                            String string4 = resultSet.getString(1);
                            int n = resultSet.getInt(2);
                            int n2 = resultSet.getInt(3);
                            defaultListModel.addElement(new Procedure((String)object, string3, string4, n2, n, database, plsqlRoot, textBuffer));
                        }
                    } else if ("TYPE".equals(string) || "TYPE BODY".equals(string)) {
                        Query query = PlSqlRunnerPanel.getXMLSupport().getQuery("Runner.CompilationUnit", connection);
                        statement = connection.prepareStatement(query.getSql());
                        statement.setString(1, (String)object);
                        statement.setString(2, string3);
                        statement.setString(3, "TYPE");
                        resultSet = statement.executeQuery();
                        while (resultSet.next()) {
                            String string5 = resultSet.getString(1);
                            int n = resultSet.getInt(2);
                            int n3 = resultSet.getInt(3);
                            defaultListModel.addElement(new Procedure((String)object, string3, string5, n3, n, database, plsqlRoot, textBuffer));
                        }
                    } else if ("TRIGGER".equals(string)) {
                        statement = connection.prepareStatement(TRIGGER_QUERY);
                        statement.setString(1, (String)object);
                        statement.setString(2, string3);
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            int n = resultSet.getInt("object_id");
                            String string6 = resultSet.getString("triggering_event");
                            String string7 = resultSet.getString("object_name");
                            String string8 = resultSet.getString("owner");
                            defaultListModel.addElement(new Procedure(string8, string7, n, string6, database, plsqlRoot, textBuffer));
                        }
                    } else {
                        statement = connection.prepareStatement(PROC_QUERY);
                        statement.setString(1, (String)object);
                        statement.setString(2, string3);
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            int n = resultSet.getInt(1);
                            defaultListModel.addElement(new Procedure((String)object, string3, n, database, plsqlRoot, textBuffer));
                        }
                    }
                    if (defaultListModel.getSize() == 0) {
                        if (!DBURLFormatHelper.isDBURL(this.m_node.getURL())) {
                            this.m_txtBlock.setText(RunnerArb.format("ERROR_MISSING_SOURCE", string3));
                        } else {
                            this.m_txtBlock.setText(RunnerArb.format("ERROR_EMPTY_PKG", string3));
                        }
                        this._updateOK(false);
                    } else {
                        this._updateOK(true);
                    }
                }
                catch (SQLException sQLException) {
                    SQLErrorDialog.showErrorDialog((Component)this, (String)RunnerArb.getString("ERROR_MSG_TITLE"), (SQLException)sQLException);
                    this._updateOK(false);
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        finally {
            this.m_node.releaseTextBuffer();
            if (plSqlNode != null) {
                plSqlNode.releaseTextBuffer();
            }
        }
        this.m_lstTarget.setModel(defaultListModel);
        if (defaultListModel.size() > 0) {
            this.m_lstTarget.setSelectedIndex(0);
        }
        this.m_splContent.invalidate();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_layButtons.setAxis(0);
        this.m_pnlButtons.setLayout((LayoutManager)this.m_layButtons);
        this.m_splContent.setOrientation(0);
        this.m_pnlTarget.setLayout(this.m_layTarget);
        this.m_pnlParams.setLayout(this.m_layParams);
        this.m_pnlBlock.setLayout(this.m_layBlock);
        ResourceUtils.resLabel((JLabel)this.m_lblTarget, (Component)this.m_lstTarget, (String)RunnerArb.getString("LABEL_TARGET"));
        this.m_scrTarget.setMinimumSize(new Dimension(150, 100));
        this.m_lstTarget.setSelectionModel(this.m_selModel);
        this.m_lstTarget.setVisibleRowCount(5);
        ResourceUtils.resLabel((JLabel)this.m_lblParams, (Component)this.m_tblParams, (String)RunnerArb.getString("LABEL_PARAMS"));
        this.m_scrBlock.setHorizontalScrollBarPolicy(32);
        this.m_scrBlock.setVerticalScrollBarPolicy(22);
        this.m_tblParams.setAutoCreateColumnsFromModel(false);
        this.m_tblParams.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.m_colName.setModelIndex(0);
        this.m_colName.setPreferredWidth(220);
        this.m_colName.setHeaderValue(RunnerArb.getString("HEADER_PARAMETER"));
        this.m_colMdl.addColumn(this.m_colName);
        this.m_colType.setModelIndex(1);
        this.m_colType.setPreferredWidth(110);
        this.m_colType.setHeaderValue(RunnerArb.getString("HEADER_DATA_TYPE"));
        this.m_colMdl.addColumn(this.m_colType);
        this.m_colMode.setModelIndex(2);
        this.m_colMode.setPreferredWidth(50);
        this.m_colMode.setHeaderValue(RunnerArb.getString("HEADER_MODE"));
        this.m_colMdl.addColumn(this.m_colMode);
        this.m_colValue.setModelIndex(3);
        this.m_colValue.setPreferredWidth(200);
        this.m_colValue.setHeaderValue(RunnerArb.getString("HEADER_VALUE"));
        this.m_colMdl.addColumn(this.m_colValue);
        this.m_tblParams.setColumnModel(this.m_colMdl);
        ResourceUtils.resLabel((JLabel)this.m_lblBlock, (Component)this.m_txtBlock, (String)RunnerArb.getString("LABEL_BLOCK"));
        this.m_selModel.setSelectionMode(0);
        this.m_selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PlSqlRunnerPanel.this._targetChanged();
                }
            }
        });
        ResourceUtils.resButton((AbstractButton)this.m_btnReset, (String)RunnerArb.getString("LABEL_RESET"));
        ResourceUtils.resButton((AbstractButton)this.m_btnFromFile, (String)RunnerArb.getString("LABEL_FROM_FILE"));
        this.m_btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlRunnerPanel.this._resetDocument();
            }
        });
        this.m_btnFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlRunnerPanel.this._loadFromFile();
            }
        });
        ResourceUtils.resButton((AbstractButton)this.m_btnToFile, (String)RunnerArb.getString("LABEL_TO_FILE"));
        this.m_btnToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlRunnerPanel.this._saveToFile();
            }
        });
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && PlSqlRunnerPanel.this.isShowing()) {
                    PlSqlRunnerPanel.this.m_splContent.setDividerLocation(0.33);
                    PlSqlRunnerPanel.this.m_splTop.setDividerLocation(0.4);
                    PlSqlRunnerPanel.this.removeHierarchyListener(this);
                }
            }
        });
        this.m_pnlTarget.add((Component)this.m_lblTarget, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_scrTarget.getViewport().add((Component)this.m_lstTarget, null);
        this.m_pnlTarget.add((Component)this.m_scrTarget, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splTop.add((Component)this.m_pnlTarget, "left");
        this.m_pnlParams.add((Component)this.m_lblParams, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_scrParams.getViewport().add((Component)this.m_tblParams, null);
        this.m_pnlParams.add((Component)this.m_scrParams, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splTop.add((Component)this.m_pnlParams, "right");
        this.m_splContent.add((Component)this.m_splTop, "top");
        this.m_scrBlock.getViewport().add((Component)this.m_txtBlock, null);
        this.m_pnlBlock.add((Component)this.m_lblBlock, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBlock.add((Component)this.m_scrBlock, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splContent.add((Component)this.m_pnlBlock, "bottom");
        this.add((Component)this.m_splContent, "Center");
        this.m_pnlButtons.add(this.m_glue);
        this.m_pnlButtons.add(this.m_btnToFile);
        this.m_pnlButtons.add(this.m_btnFromFile);
        this.m_pnlButtons.add(this.m_btnReset);
        this.add((Component)this.m_pnlButtons, "South");
    }

    protected void _saveToFile() {
        URL[] uRLArray;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setURLFilter(SqlNode.SQL_FILTER);
        int n = uRLFileChooser.showSaveDialog(this, RunnerArb.getString("TITLE_TO_FILE"));
        if (n == 0 && (uRLArray = uRLFileChooser.getSelectedURLs()) != null && uRLArray[0] != null) {
            URL uRL = uRLArray[0];
            String string = URLFileSystem.getSuffix((URL)uRL);
            if (!ModelUtil.hasLength((String)string)) {
                uRL = URLFactory.newURL((URL)URLFileSystem.getParent((URL)uRL), (String)(URLFileSystem.getFileName((URL)uRL) + ".sql"));
            }
            try {
                String string2 = this.m_txtBlock.getText();
                String string3 = Ide.getEnvironOptions().getEncoding();
                byte[] byArray = string3 != null ? string2.getBytes(string3) : string2.getBytes();
                FileUtilities.writeFile((URL)uRL, (byte[])byArray);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Throwable)iOException);
            }
        }
    }

    private void _loadFromFile() {
        URL uRL = null;
        try {
            URL[] uRLArray;
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.setSelectionScope(2);
            uRLFileChooser.setSelectionMode(0);
            uRLFileChooser.setURLFilter(SqlNode.SQL_FILTER);
            int n = uRLFileChooser.showOpenDialog(this, DirOptionsArb.getString((int)12));
            if (n == 0 && (uRLArray = uRLFileChooser.getSelectedURLs()) != null && uRLArray[0] != null) {
                uRL = uRLArray[0];
                byte[] byArray = FileUtilities.readFile((URL)uRL);
                String string = Ide.getEnvironOptions().getEncoding();
                String string2 = string != null ? new String(byArray, string) : new String(byArray);
                this.m_txtBlock.setText(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunnerArb.getString("INVALID_FILE_NOT_FOUND") + URLFileSystem.getPlatformPathName(uRL)), (String)RunnerArb.getString("INVALID_PROGRAM_TITLE"), null);
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)RunnerArb.getString("INVALID_PROGRAM_TITLE"), null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void _resetDocument() {
        Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
        if (procedure != null) {
            procedure.resetDocument();
            this._targetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _targetChanged() {
        if (this.editor == null) {
            this.editor = new CodeEditor();
        }
        ParamTableModel paramTableModel = null;
        Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
        try {
            paramTableModel = procedure.getTableModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = paramTableModel.getRowCount() > 0;
        this.m_tblParams.setEnabled(bl);
        this.m_lblParams.setEnabled(bl);
        this.m_tblParams.setModel(paramTableModel);
        TextBuffer textBuffer = null;
        try {
            URL uRL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(Product.getProductID());
            String string = this.getPersistedKey(procedure);
            URL uRL2 = persistedBlocks.get(string);
            if (this.anonymousNode == null) {
                this.anonymousNode = new PlSqlNode();
            }
            if (uRL2 == null) {
                uRL2 = URLFileSystem.createTempFile((String)anonBlock, (String)".pls", (URL)uRL);
                this.anonymousNode.setURL(uRL2);
                persistedBlocks.put(string, uRL2);
                textBuffer = this.anonymousNode.acquireTextBuffer();
                textBuffer.writeLock();
                textBuffer.removeToEnd(0);
                textBuffer.insert(0, procedure.generateRunBlock());
            } else {
                this.anonymousNode.setURL(uRL2);
                textBuffer = this.anonymousNode.acquireTextBuffer();
                textBuffer.writeLock();
                textBuffer.removeToEnd(0);
                textBuffer.insert(0, (Reader)new InputStreamReader((InputStream)new FileInputStream(URLFileSystem.getPath((URL)uRL2)), Ide.getEnvironOptions().getEncoding()));
                if (textBuffer.getLength() == 0) {
                    textBuffer.insert(0, procedure.generateRunBlock());
                }
            }
            this.anonymousNode.releaseTextBuffer();
            Context context = new Context((Node)this.anonymousNode);
            this.editor.setContext(context);
            ((JDebuggerSingleton)Debugger.getDebugger()).editorOpened((Editor)this.editor);
            this.m_scrBlock.getViewport().remove((Component)this.m_txtBlock);
            this.m_txtBlock = this.editor.getFocusedEditorPane();
            this.m_scrBlock.getViewport().add((Component)this.m_txtBlock, null);
            boolean bl2 = false;
            for (CaretListener caretListener : this.m_txtBlock.getCaretListeners()) {
                if (caretListener != this.caretListener) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.m_txtBlock.addCaretListener(this.caretListener);
            }
            this.refreshTableModel();
            this.m_scrBlock.setRowHeaderView((Component)this.editor.getGutter());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (textBuffer != null) {
                textBuffer.writeUnlock();
            }
        }
    }

    private String getPersistedKey(Procedure procedure) {
        ParamTableModel paramTableModel = null;
        try {
            paramTableModel = procedure.getTableModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < paramTableModel.getRowCount(); ++i) {
            Parameter parameter = paramTableModel.getParameter(i);
            stringBuilder.append(" " + parameter.getParamName() + " " + parameter.getType().getTypeName());
        }
        String string = this.m_node.getURL().toString() + procedure.getName() + stringBuilder.toString().hashCode();
        return string;
    }

    private boolean _commit() {
        boolean bl = false;
        BasicDocument basicDocument = (BasicDocument)this.m_txtBlock.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        try {
            PlSqlRunnerPanel.checkPlSql(PlSqlRunnerPanel.getDatabase(this.m_node), textBuffer);
            Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
            if (procedure != null) {
                procedure.saveDocument();
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            SQLErrorDialog.showErrorDialog((Component)this, (String)RunnerArb.getString("ERROR_MSG_TITLE"), (SQLException)sQLException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPlSql(Database database, TextBuffer textBuffer) throws SQLException {
        String string = textBuffer.getString(0, textBuffer.getLength());
        Connection connection = database.getConnection();
        try {
            if (connection == null) {
                throw new SQLException(RunnerArb.getString("ERROR_NO_CONNECTION"));
            }
            if (!Connections.getInstance().lock(connection)) {
                throw new SQLException(RunnerArb.getString("ERROR_NO_LOCK"));
            }
            String string2 = Connections.getInstance().getConnectionName(connection);
            ObjectFactory objectFactory = ObjectFactory.getFactory(string2, connection);
            if (objectFactory == null) {
                throw new SQLException(RunnerArb.getString("ERROR_NO_FACTORY"));
            }
            String string3 = objectFactory.getConnectionType();
            PlSqlWrapperValidator plSqlWrapperValidator = s_validators.get(string3);
            if (plSqlWrapperValidator == null) {
                throw new SQLException(RunnerArb.format("ERROR_INVALID_CONN_TYPE", string3));
            }
            plSqlWrapperValidator.checkPlSql(string, connection);
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
    }

    private static Database getDatabase(DatabaseSourceNode databaseSourceNode) {
        String string = databaseSourceNode.getConnectionName();
        if (string == null) {
            string = DBURLFormatHelper.getConnectionName(databaseSourceNode.getURL());
        }
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(string, true);
        }
        catch (DBException dBException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)dBException.getMessage(), null, null);
            return null;
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String generateAnonymousBlock(PlSqlNode plSqlNode, String string) {
        Procedure procedure = null;
        String string2 = plSqlNode.getType();
        try {
            Connection connection;
            TextBuffer textBuffer = plSqlNode.acquireTextBuffer();
            PlsqlRoot plsqlRoot = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
            URL uRL = plSqlNode.getURL();
            if (!DBURLFormatHelper.isDBURL(uRL)) {
                uRL = plSqlNode.matchingDbUrl();
            }
            String string3 = DBURLFormatHelper.getSchema(uRL);
            String string4 = DBURLFormatHelper.getName(uRL);
            Database database = Connections.getInstance().getDatabase(string);
            Connection connection2 = connection = database.getConnection();
            synchronized (connection2) {
                Object object;
                ResultSet resultSet;
                Statement statement;
                block35: {
                    statement = null;
                    resultSet = null;
                    if ("PACKAGE".equals(string2) || "PACKAGE BODY".equals(string2)) {
                        object = PlSqlRunnerPanel.getXMLSupport().getQuery("Runner.CompilationUnit", connection);
                        statement = connection.prepareStatement(object.getSql());
                        statement.setString(1, string3);
                        statement.setString(2, string4);
                        statement.setString(3, "PACKAGE");
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            String string5 = resultSet.getString(1);
                            int n = resultSet.getInt(2);
                            int n2 = resultSet.getInt(3);
                            procedure = new Procedure(string3, string4, string5, n2, n, database, plsqlRoot, textBuffer);
                        }
                    } else {
                        statement = connection.prepareStatement(PROC_QUERY);
                        statement.setString(1, string3);
                        statement.setString(2, string4);
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            int n = resultSet.getInt(1);
                            procedure = new Procedure(string3, string4, n, database, plsqlRoot, textBuffer);
                        }
                    }
                    object = new String(procedure.generateRunBlock());
                    if (resultSet == null) break block35;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return object;
                catch (SQLException sQLException) {
                    try {
                        try {
                            System.err.println(sQLException.getMessage());
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    catch (DBException dBException) {
                        System.err.println(dBException.getMessage());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            plSqlNode.releaseTextBuffer();
        }
        {
            return "";
        }
    }

    static {
        s_validators.put("Oracle", new OraclePlSqlWrapperValidator());
        persistedBlocks = new HashMap<String, URL>();
    }

    public static class PlSqlDebuggerPanel
    extends PlSqlRunnerPanel {
        public PlSqlDebuggerPanel(PlSqlNode plSqlNode) {
            super(plSqlNode);
        }

        @Override
        String getTitle() {
            return RunnerArb.getString("DEBUG_DIALOG_TITLE");
        }
    }

    public static class PlSqlProfilerPanel
    extends PlSqlRunnerPanel {
        private JPanel pnlComment = new JPanel();
        protected JLabel lblComment = new JLabel();
        private JTextField fldComment = new JTextField(30);

        public PlSqlProfilerPanel(PlSqlNode plSqlNode) {
            super(plSqlNode);
            this.pnlComment.add(this.lblComment);
            this.pnlComment.add(this.fldComment);
            ResourceUtils.resLabel((JLabel)this.lblComment, (Component)this.fldComment, (String)RunnerArb.getString("LABEL_PROFILE_COMMENT"));
            this.add((Component)this.pnlComment, "North");
        }

        @Override
        String getTitle() {
            return RunnerArb.getString("PROFILE_DIALOG_TITLE");
        }

        @Override
        void setCommentsReturn() {
            this.m_node.setProperty("commentReturn", this.fldComment.getText());
        }
    }

    private static final class OraclePlSqlWrapperValidator
    implements PlSqlWrapperValidator {
        private OraclePlSqlWrapperValidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkPlSql(String string, Connection connection) throws SQLException {
            CLOB cLOB = null;
            Statement statement = null;
            try {
                QueryXMLSupport queryXMLSupport = PlSqlRunnerPanel.getXMLSupport();
                Query query = queryXMLSupport.getQuery("runnerBlock", connection);
                HashMap<String, CLOB> hashMap = new HashMap<String, CLOB>();
                cLOB = CLOB.createTemporary((Connection)connection, (boolean)false, (int)10);
                cLOB.setString(1L, string);
                hashMap.put("SRC", cLOB);
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                statement = dBUtil.prepareExecute(query.getSql(), hashMap);
                if (statement == null) {
                    throw new SQLException(Messages.getString("PlSqlRunnerPanel.4"));
                }
                statement.execute();
            }
            finally {
                if (cLOB != null) {
                    cLOB.freeTemporary();
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

