/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.runner.InvalidData;
import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

class Procedure {
    private static Map<String, BasicDocument> s_docMap = new HashMap<String, BasicDocument>();
    private String _owner;
    private String _package;
    private String _name;
    private int _id;
    private int _overload;
    Set<String> trEvents;
    private Database _db;
    private PlsqlRoot _parseTree;
    private String _displayValue;
    private ParamTableModel _model;
    private BasicDocument _document;
    Map<String, String> defaultParams = null;
    static final String path = "/oracle/dbtools/raptor/runner/";
    static Parsed anonBlockPrg = null;
    static SqlProgram programInstance = null;
    private String rollbackStr = "Procedure.rollback";
    static final String INDENT = "  ";
    private static Map<String, Map<String, Map<String, String>>> allDefaultParams = new HashMap<String, Map<String, Map<String, String>>>();
    static Parsed parsedPls = null;
    static SqlProgram parameters = null;

    public Procedure(String string, String string2, int n, Database database, PlsqlRoot plsqlRoot, TextBuffer textBuffer) {
        this(string, null, string2, n, 0, database, plsqlRoot, textBuffer);
    }

    public Procedure(String string, String string2, String string3, int n, int n2, Database database, PlsqlRoot plsqlRoot, TextBuffer textBuffer) {
        this._owner = string;
        this._package = string2;
        this._name = string3;
        this._id = n;
        this._overload = n2;
        this._db = database;
        this._parseTree = plsqlRoot;
        this.defaultParams = this.parseDefaultParams(string, string2, textBuffer).get(string3);
        if (this.defaultParams == null) {
            this.defaultParams = new HashMap<String, String>();
        }
    }

    public Procedure(String string, String string2, int n, String string3, Database database, PlsqlRoot plsqlRoot, TextBuffer textBuffer) {
        this._owner = string;
        this._name = string2;
        this._id = n;
        this._db = database;
        this._parseTree = plsqlRoot;
        this.trEvents = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if ("OR".equals(string4)) continue;
            this.trEvents.add(string4);
        }
        this.defaultParams = this.parseDefaultParams(string, "N/A", textBuffer).get(string2);
        if (this.defaultParams == null) {
            this.defaultParams = new HashMap<String, String>();
        }
    }

    public String toString() {
        if (this._displayValue == null) {
            this._displayValue = this._overload > 0 ? this._name + "(" + this._overload + ")" : this._name;
        }
        return this._displayValue;
    }

    public ParamTableModel getTableModel() throws SQLException {
        if (this._model == null) {
            this._model = new ParamTableModel(this);
        }
        return this._model;
    }

    public Connection getConnection() {
        return this._db.getConnection();
    }

    public String getPackage() {
        return this._package;
    }

    public String getName() {
        return this._name;
    }

    public int getOverload() {
        return this._overload;
    }

    public String getOwner() {
        return this._owner;
    }

    public int getObjectID() {
        return this._id;
    }

    public PlsqlRoot getParseTree() {
        return this._parseTree;
    }

    public void saveDocument() {
        if (this._document != null) {
            s_docMap.put(this._getHashName(), this._document);
        }
    }

    public void resetDocument() {
        this._document = null;
        s_docMap.remove(this._getHashName());
    }

    public char[] generateRunBlock() throws SQLException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        boolean bl = true;
        String string = this._db.getConnection().getMetaData().getUserName();
        bl = ModelUtil.areDifferent((Object)string, (Object)this._owner);
        ParamTableModel paramTableModel = this.getTableModel();
        if (this.trEvents == null) {
            this.generateRunProcedure(fastStringBuffer, bl, paramTableModel);
        } else {
            this.generateRunTrigger(fastStringBuffer, bl, paramTableModel);
        }
        char[] cArray = new char[fastStringBuffer.length()];
        fastStringBuffer.getChars(0, cArray.length, cArray, 0);
        return cArray;
    }

    Map<String, Pair<String, String>> parseAnonBlock(String string) throws InvalidData {
        TreeMap<String, Pair<String, String>> treeMap = new TreeMap<String, Pair<String, String>>();
        try {
            List list = LexerToken.parse((String)string);
            Map map = SqlProgram.runProgram((String)string, (List)list, (String)Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/start_block_proc_args.prg"), (Parsed)anonBlockPrg, (SqlProgram)programInstance);
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("params");
            for (int i = 0; i < materializedPredicate.cardinality(); ++i) {
                ParseNode parseNode = materializedPredicate.getAttribute(i, "name");
                ParseNode parseNode2 = materializedPredicate.getAttribute(i, "expr");
                ParseNode parseNode3 = materializedPredicate.getAttribute(i, "type");
                treeMap.put(parseNode.content(list), (Pair<String, String>)new Pair((Object)parseNode2.content(list), (Object)parseNode3.content(list)));
            }
            return treeMap;
        }
        catch (SyntaxError syntaxError) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StringBuilder updateAnonBlock(String string) throws InvalidData {
        try {
            List list = LexerToken.parse((String)string);
            Map map = SqlProgram.runProgram((String)string, (List)list, (String)Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/start_block_proc_args.prg"), (Parsed)anonBlockPrg, (SqlProgram)programInstance);
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("initializations");
            TreeMap<Long, String> treeMap = new TreeMap<Long, String>();
            int n = 0;
            while (true) {
                Parameter parameter;
                String string2;
                String string3;
                int n2;
                Object object;
                Object object2;
                if (n < materializedPredicate.cardinality()) {
                    object2 = materializedPredicate.getAttribute(n, "name");
                    object = materializedPredicate.getAttribute(n, "expr");
                    n2 = this.getTableModel().getRowCount();
                    string3 = null;
                } else {
                    n = 0;
                    object2 = new StringBuilder();
                    object = treeMap.keySet().iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            ((StringBuilder)object2).append(string.substring(n));
                            return object2;
                        }
                        long l = (Long)object.next();
                        int n3 = Service.lX((long)l);
                        int n4 = Service.lY((long)l);
                        string2 = (String)treeMap.get(l);
                        ((StringBuilder)object2).append(string.substring(n, n3));
                        n = n4;
                        ((StringBuilder)object2).append(string2);
                    }
                }
                for (int i = 0; i < n2; ++i) {
                    String string4;
                    parameter = this.getTableModel().getParameter(i);
                    if (parameter.isReturn() || !(string2 = parameter.getVarName()).equals(string4 = object2.content(list))) continue;
                    try {
                        String string5 = parameter.formatValue();
                        if (object.content(list).equals(string2)) break;
                        string3 = string5;
                        break;
                    }
                    catch (InvalidData invalidData) {
                        invalidData.priorValue = object.content(list);
                        throw invalidData;
                    }
                }
                LexerToken lexerToken = (LexerToken)list.get(((ParseNode)object).from);
                parameter = (LexerToken)list.get(((ParseNode)object).to - 1);
                if (string3 != null) {
                    treeMap.put(Service.lPair((int)lexerToken.begin, (int)((LexerToken)parameter).end), string3.toString());
                }
                ++n;
            }
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    private void generateRunProcedure(FastStringBuffer fastStringBuffer, boolean bl, ParamTableModel paramTableModel) {
        int n = paramTableModel.getRowCount();
        if (n == 0) {
            fastStringBuffer.append("BEGIN\n  ");
            fastStringBuffer.append(this._getCallName(bl, null));
            fastStringBuffer.append("();\n");
            this.addRollback(fastStringBuffer);
            fastStringBuffer.append("END;");
        } else {
            Object object;
            int n2;
            int n3;
            Parameter parameter = null;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            Parameter parameter2 = paramTableModel.getParameter(0);
            if (parameter2.isReturn()) {
                parameter = parameter2;
            } else {
                arrayList.add(parameter2);
            }
            for (n3 = 1; n3 < n; ++n3) {
                arrayList.add(paramTableModel.getParameter(n3));
            }
            n = arrayList.size();
            fastStringBuffer.append("DECLARE\n");
            for (n3 = 0; n3 < n; ++n3) {
                parameter2 = (Parameter)arrayList.get(n3);
                parameter2.generateDeclaration(fastStringBuffer);
            }
            if (parameter != null) {
                parameter.generateDeclaration(fastStringBuffer);
            }
            fastStringBuffer.append("BEGIN\n");
            String string = null;
            for (n2 = 0; n2 < n; ++n2) {
                Mode mode;
                parameter2 = (Parameter)arrayList.get(n2);
                object = this.defaultParams.get(parameter2.getParamName());
                if (object != null) {
                    parameter2.setValue(object);
                }
                if (!(mode = parameter2.getMode()).equals(Mode.OUT)) {
                    parameter2.generateInitialization(fastStringBuffer);
                }
                if (!parameter2.isObjectInstance()) continue;
                string = parameter2.getParamName();
            }
            fastStringBuffer.append("\n");
            fastStringBuffer.append(INDENT);
            if (parameter != null) {
                fastStringBuffer.append(parameter.getVarName());
                fastStringBuffer.append(" := ");
            }
            fastStringBuffer.append(this._getCallName(bl, string));
            fastStringBuffer.append("(");
            if (n > 0) {
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                parameter2 = (Parameter)arrayList.get(0);
                parameter2.generateCallReference(fastStringBuffer);
                for (n2 = 1; n2 < n; ++n2) {
                    fastStringBuffer.append(",\n");
                    fastStringBuffer.append(INDENT);
                    parameter2 = (Parameter)arrayList.get(n2);
                    parameter2.generateCallReference(fastStringBuffer);
                }
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
            }
            fastStringBuffer.append(");\n");
            if (parameter != null) {
                parameter.generateResultOutput(fastStringBuffer);
            }
            for (n2 = 0; n2 < n; ++n2) {
                parameter2 = (Parameter)arrayList.get(n2);
                object = parameter2.getMode();
                if (((Mode)object).equals(Mode.IN)) continue;
                parameter2.generateResultOutput(fastStringBuffer);
            }
            this.addRollback(fastStringBuffer);
            fastStringBuffer.append("END;\n");
        }
    }

    private void addRollback(FastStringBuffer fastStringBuffer) {
        String string = NonUserConfigOptions.get(this.rollbackStr);
        if (string == null || !"true".equals(string)) {
            fastStringBuffer.append("--rollback; \n");
        } else {
            fastStringBuffer.append("rollback; \n");
        }
    }

    void persistRollback(String string) {
        NonUserConfigOptions.put(this.rollbackStr, "" + (string.contains("rollback;") && !string.contains("--rollback;")));
    }

    private void generateRunTrigger(FastStringBuffer fastStringBuffer, boolean bl, ParamTableModel paramTableModel) {
        fastStringBuffer.append("DECLARE\n");
        fastStringBuffer.append("BEGIN\n");
        for (String string : this.trEvents) {
            int n;
            int n2;
            if ("INSERT".equals(string)) {
                n2 = paramTableModel.getRowCount();
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("insert into ");
                fastStringBuffer.append(this._getCallName(bl, null));
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("(");
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        fastStringBuffer.append(",");
                    }
                    fastStringBuffer.append(paramTableModel.getParameter(n).getParamName());
                }
                fastStringBuffer.append(")\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("values\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("(");
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        fastStringBuffer.append(",");
                    }
                    fastStringBuffer.append(paramTableModel.getParameter(n).getValue());
                }
                fastStringBuffer.append(");\n");
            }
            if ("UPDATE".equals(string)) {
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("update ");
                fastStringBuffer.append(this._getCallName(bl, null));
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("set\n");
                n2 = paramTableModel.getRowCount();
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        fastStringBuffer.append(",\n");
                    }
                    fastStringBuffer.append(INDENT);
                    fastStringBuffer.append(INDENT);
                    fastStringBuffer.append(paramTableModel.getParameter(n).getParamName());
                    fastStringBuffer.append("=");
                    fastStringBuffer.append(paramTableModel.getParameter(n).getValue());
                }
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                fastStringBuffer.append("where 1=0;\n");
            }
            if (!"DELETE".equals(string)) continue;
            fastStringBuffer.append(INDENT);
            fastStringBuffer.append("delete from ");
            fastStringBuffer.append(this._getCallName(bl, null));
            fastStringBuffer.append("\n");
            fastStringBuffer.append(INDENT);
            fastStringBuffer.append("where 1=0;\n");
        }
        fastStringBuffer.append(INDENT);
        fastStringBuffer.append("rollback; \n");
        fastStringBuffer.append("END;\n");
    }

    private String _getCallName(boolean bl, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (string != null) {
            fastStringBuffer.append(string).append('.');
        } else {
            if (bl && ModelUtil.hasLength((String)this._owner)) {
                fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._owner)).append('.');
            }
            if (ModelUtil.hasLength((String)this._package)) {
                fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._package)).append('.');
            }
        }
        fastStringBuffer.append(DBUtil.addDoubleQuote((String)this._name));
        return fastStringBuffer.toString();
    }

    private String _getHashName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(this._getCallName(true, null));
        if (this._overload > 0) {
            fastStringBuffer.append("(" + this._overload + ")");
        }
        String string = null;
        try {
            Connection connection = this._db.getConnection();
            string = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ModelUtil.hasLength(string)) {
            fastStringBuffer.append('@').append(string);
        }
        return fastStringBuffer.toString();
    }

    static void resetDefaultParamMap() {
        allDefaultParams = new HashMap<String, Map<String, Map<String, String>>>();
    }

    private Map<String, Map<String, String>> parseDefaultParams(String string, String string2, TextBuffer textBuffer) {
        String string3 = string + "." + string2;
        Map<String, Map<String, String>> map = allDefaultParams.get(string3);
        if (map == null) {
            String string4 = textBuffer.getString(0, textBuffer.getLength());
            map = Procedure.parseDefaultParams(string4);
            allDefaultParams.put(string3, map);
        }
        return map;
    }

    private static Map<String, Map<String, String>> parseDefaultParams(String string) {
        List list = LexerToken.parse((String)string);
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        try {
            Map map = SqlProgram.runProgram((String)string, (List)list, (String)Service.readFile(Procedure.class, (String)"/oracle/dbtools/raptor/runner/default_par.prg"), (Parsed)parsedPls, (SqlProgram)parameters);
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("\"default parameters\"");
            for (int i = 0; i < materializedPredicate.cardinality(); ++i) {
                String string2;
                TreeMap<String, String> treeMap;
                ParseNode parseNode = materializedPredicate.getAttribute(i, "id");
                ParseNode parseNode2 = materializedPredicate.getAttribute(i, "pls_expr");
                ParseNode parseNode3 = materializedPredicate.getAttribute(i, "proc");
                String string3 = parseNode2.content(list);
                if (2 <= string3.length() && string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'') {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if ((treeMap = (TreeMap<String, String>)hashMap.get(string2 = Service.handleMixedCase((String)parseNode3.content(list)))) == null) {
                    treeMap = new TreeMap<String, String>();
                    hashMap.put(string2, treeMap);
                }
                treeMap.put(Service.handleMixedCase((String)((LexerToken)list.get((int)parseNode.from)).content), string3);
            }
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) throws IOException {
        Program.debug = true;
        String string = Service.readFile(Procedure.class, (String)"FND_STATS.pks");
        long l = System.currentTimeMillis();
        System.out.println(Procedure.parseDefaultParams(string));
        long l2 = System.currentTimeMillis();
        System.out.println("Time = " + (l2 - l));
    }
}

