/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner.debug.jdi;

import com.sun.jdi.OracleReferenceType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.runner.ArgusHelper;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManager;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;

final class DBJDIFileSystemHelper
extends URLFileSystemHelperDecorator
implements DebugJDIAnonymousBlockManager {
    private Map<Pair<Integer, DebugJDIClassInfo>, OracleReferenceType> classToORT = new HashMap<Pair<Integer, DebugJDIClassInfo>, OracleReferenceType>();
    private Map<OracleReferenceType, URL> ortToURL = new HashMap<OracleReferenceType, URL>();
    private Map<URL, String> urlToSource = new HashMap<URL, String>();
    private Map<URL, Long> urlToTime = new HashMap<URL, Long>();

    DBJDIFileSystemHelper(URLFileSystemHelper uRLFileSystemHelper) {
        super(uRLFileSystemHelper);
    }

    public synchronized void add(int n, DebugJDIClassInfo debugJDIClassInfo, OracleReferenceType oracleReferenceType) {
        this.classToORT.put((Pair<Integer, DebugJDIClassInfo>)new Pair((Object)n, (Object)debugJDIClassInfo), oracleReferenceType);
        for (URL uRL : this.urlToTime.keySet()) {
            DatabaseSourceNode databaseSourceNode;
            if (!this.isMatch(debugJDIClassInfo, uRL) || (databaseSourceNode = (DatabaseSourceNode)NodeFactory.find((URL)uRL)) == null || "BLOCK".equals(databaseSourceNode.getObjectType())) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RevertNodeCommand.reload((Node)databaseSourceNode);
                }
            });
        }
    }

    public synchronized void remove(int n, DebugJDIClassInfo debugJDIClassInfo) {
        Pair pair = new Pair((Object)n, (Object)debugJDIClassInfo);
        this.remove((Pair<Integer, DebugJDIClassInfo>)pair);
    }

    private void remove(Pair<Integer, DebugJDIClassInfo> pair) {
        URL uRL;
        OracleReferenceType oracleReferenceType = this.classToORT.remove(pair);
        if (oracleReferenceType != null && (uRL = this.ortToURL.remove(oracleReferenceType)) != null) {
            this.urlToSource.remove(uRL);
        }
    }

    public synchronized void remove(int n) {
        ArrayList<Pair<Integer, DebugJDIClassInfo>> arrayList = new ArrayList<Pair<Integer, DebugJDIClassInfo>>();
        for (Pair<Integer, DebugJDIClassInfo> pair : this.classToORT.keySet()) {
            if ((Integer)pair.first != n) continue;
            arrayList.add(pair);
        }
        for (Pair pair : arrayList) {
            this.remove((Pair<Integer, DebugJDIClassInfo>)pair);
        }
    }

    private synchronized void getSource(URL uRL) {
        if (this.urlToSource.containsKey(uRL)) {
            return;
        }
        for (Pair<Integer, DebugJDIClassInfo> pair : this.classToORT.keySet()) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)pair.second;
            try {
                OracleReferenceType oracleReferenceType;
                String string;
                if (!this.isMatch(debugJDIClassInfo, uRL) || (string = (oracleReferenceType = this.classToORT.get(pair)).sourceCode()) == null || string.length() <= 0) continue;
                this.ortToURL.put(oracleReferenceType, uRL);
                this.urlToSource.put(uRL, string);
                this.urlToTime.put(uRL, new Long(new Date().getTime()));
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    private synchronized boolean existsImpl(URL uRL) {
        this.getSource(uRL);
        return this.urlToSource.containsKey(uRL);
    }

    private synchronized long lastModifiedImpl(URL uRL) {
        this.getSource(uRL);
        Long l = this.urlToTime.get(uRL);
        return l != null ? l : -1L;
    }

    private synchronized InputStream openInputStreamImpl(URL uRL) {
        this.getSource(uRL);
        String string = this.urlToSource.get(uRL);
        byte[] byArray = string != null ? string.getBytes() : new byte[]{};
        return new ByteArrayInputStream(byArray);
    }

    private boolean isMatch(DebugJDIClassInfo debugJDIClassInfo, URL uRL) {
        String string = debugJDIClassInfo.getPackage() + '.' + debugJDIClassInfo.getPrimarySourceFilename();
        if (string.endsWith(".pls")) {
            string = string.substring(0, string.length() - 4);
        }
        String string2 = DBURLFormatHelper.getConnectionName(uRL);
        return uRL.equals(ArgusHelper.argusStringToUrl(string, string2));
    }

    public boolean canRead(URL uRL) {
        if (this.isBlock(uRL)) {
            return this.exists(uRL);
        }
        return this._helper.canRead(uRL);
    }

    private boolean isBlock(URL uRL) {
        return "BLOCK".equals(DBURLFormatHelper.getBaseType(uRL));
    }

    public boolean canWrite(URL uRL) {
        if (this.isBlock(uRL)) {
            return false;
        }
        return this._helper.canWrite(uRL);
    }

    public boolean canCreate(URL uRL) {
        if (this.isBlock(uRL)) {
            return false;
        }
        return this._helper.canCreate(uRL);
    }

    public boolean exists(URL uRL) {
        if (this.isBlock(uRL)) {
            return this.existsImpl(uRL);
        }
        return this._helper.exists(uRL);
    }

    public boolean isReadOnly(URL uRL) {
        if (this.isBlock(uRL)) {
            return true;
        }
        return this._helper.isReadOnly(uRL);
    }

    public long lastModified(URL uRL) {
        if (this.isBlock(uRL)) {
            return this.lastModifiedImpl(uRL);
        }
        return this._helper.lastModified(uRL);
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        if (this.isBlock(uRL)) {
            return this.openInputStreamImpl(uRL);
        }
        return this._helper.openInputStream(uRL);
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        if (this.isBlock(uRL)) {
            throw new UnknownServiceException();
        }
        return this._helper.openOutputStream(uRL);
    }

    public Reader createReader(URL uRL, String string) throws IOException {
        if (this.isBlock(uRL)) {
            this.getSource(uRL);
            String string2 = this.urlToSource.get(uRL);
            return new StringReader(string2 != null ? string2 : "");
        }
        return this._helper.createReader(uRL, string);
    }
}

