/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.connection;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.WindowsOSUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;

public class RaptorConnectionCreator
extends OracleConnectionCreator {
    private static final Logger LOGGER = Logger.getLogger(OracleConnectionCreator.class.getName());
    private static String OCI_NEW_PASSWORD = "OCINewPassword";
    private static String CANCEL_CONNECTION = "RaptorConnectionCreator.cancel_connection";

    public boolean shouldPromptForPassword(Properties properties) {
        return true;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        String string;
        Connection connection = null;
        String string2 = properties.getProperty("user");
        String string3 = properties.getProperty("password");
        String string4 = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Connections.populateConnectionInfo(properties2);
        String string5 = properties2.getProperty("customUrl");
        DBConfig dBConfig = DBConfig.getInstance();
        if (Connections.isOCIDriverAvailable() && dBConfig.getBoolean("USE_THICK_DRIVER").booleanValue() && ConnectionUtils.scrubOraDriverType(string5).equalsIgnoreCase("thin")) {
            properties2.setProperty("customUrl", ConnectionUtils.getOCIUrl(properties2));
        }
        String string6 = dBConfig.getString("KERBEROS_CONFIG");
        if (!dBConfig.getBoolean("USE_THICK_DRIVER").booleanValue() && Boolean.parseBoolean(properties.getProperty("KERBEROS_AUTHENTICATION"))) {
            properties2.setProperty("customUrl", ConnectionUtils.getThinUrl(properties2));
            if (string6 != null && new File(string6).exists()) {
                System.setProperty("java.security.krb5.conf", string6);
            } else {
                System.clearProperty("java.security.krb5.conf");
            }
            properties2.setProperty("user", "");
            properties2.setProperty("password", "");
            string = dBConfig.getString("KERBEROS_CACHE");
            if (string2 == null || string2.equals("")) {
                properties2.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
                properties2.setProperty("oracle.net.kerberos5_mutual_authentication", "true");
                if (string == null || string.equals("")) {
                    throw new SQLException(CreateDialogArb.getString("KERBEROS_CREDENTIALS"));
                }
                properties2.setProperty("oracle.net.kerberos5_cc_name", string);
                connection = super.getConnection(properties2);
            } else {
                boolean bl;
                Subject subject = new Subject();
                final String string7 = string3;
                Properties properties3 = new Properties();
                properties3.putAll((Map<?, ?>)properties);
                final Properties properties4 = properties3;
                Krb5LoginModule krb5LoginModule = new Krb5LoginModule();
                HashMap hashMap = new HashMap();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("doNotPrompt", "false");
                if (string != null && !string.equals("")) {
                    hashMap2.put("useTicketCache", "true");
                    hashMap2.put("ticketCache", string);
                } else {
                    hashMap2.put("useTicketCache", "false");
                }
                hashMap2.put("principal", string2);
                krb5LoginModule.initialize(subject, new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
                        for (int i = 0; i < callbackArray.length; ++i) {
                            if (callbackArray[i] instanceof PasswordCallback) {
                                PasswordCallback passwordCallback = (PasswordCallback)callbackArray[i];
                                if (string7 == null || string7.equals("")) {
                                    Properties properties = new Properties();
                                    properties.putAll((Map<?, ?>)properties4);
                                    String string = null;
                                    string = RaptorConnectionCreator.this.getPassword(properties, properties4);
                                    properties4.setProperty("password", string);
                                    if (string == null) {
                                        passwordCallback.setPassword(null);
                                        continue;
                                    }
                                    passwordCallback.setPassword(string.toCharArray());
                                    continue;
                                }
                                passwordCallback.setPassword(string7.toCharArray());
                                continue;
                            }
                            throw new UnsupportedCallbackException(callbackArray[i], CreateDialogArb.getString("UNRECOGNISED_CALLBACK"));
                        }
                    }
                }, hashMap, hashMap2);
                try {
                    bl = krb5LoginModule.login();
                    krb5LoginModule.commit();
                }
                catch (LoginException loginException) {
                    String string8 = properties4.getProperty(CANCEL_CONNECTION);
                    if (string8 != null && string8.equals("true")) {
                        throw new ConnectionCanceledException();
                    }
                    throw new SQLException(loginException.getLocalizedMessage());
                }
                if (!bl) {
                    throw new SQLException(CreateDialogArb.getString("KERBEROS_CREDENTIALS"));
                }
                properties2.setProperty("oracle.net.authentication_services", "(KERBEROS5)");
                properties2.setProperty("oracle.net.kerberos5_cc_name", string);
                OracleDriver oracleDriver = new OracleDriver();
                Properties properties5 = new Properties();
                properties5.putAll((Map<?, ?>)properties2);
                final Properties properties6 = properties5;
                final RaptorConnectionCreator raptorConnectionCreator = this;
                try {
                    String string9;
                    connection = Subject.doAs(subject, new PrivilegedExceptionAction<Connection>(){

                        @Override
                        public Connection run() throws SQLException {
                            return raptorConnectionCreator.doGetConnection(properties6);
                        }
                    });
                    if (connection != null && ModelUtil.hasLength((String)(string9 = properties4.getProperty("password"))) && !ModelUtil.hasLength((String)string3)) {
                        properties.setProperty("password", string9);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof SQLException) {
                        throw (SQLException)throwable;
                    }
                    LOGGER.log(Level.WARNING, privilegedActionException.getStackTrace()[0].toString(), privilegedActionException);
                }
            }
        } else {
            connection = super.getConnection(properties2);
        }
        if ((string = properties.getProperty("IS_PROXY")) != null && Boolean.parseBoolean(string)) {
            this.openProxySession(connection, properties2);
        }
        return connection;
    }

    public Connection doGetConnection(Properties properties) throws SQLException {
        return super.getConnection(properties);
    }

    protected boolean allowNullPassword() {
        return true;
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        String[] stringArray;
        super.setCustomProperties(properties, properties2);
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        String string3 = ConnectionUtils.scrubOraDriverType(properties.getProperty("customUrl"));
        if (Boolean.parseBoolean(properties.getProperty("OS_AUTHENTICATION")) && PlatformUtils.isWindows() && string3.equalsIgnoreCase("thin")) {
            properties2.setProperty("v$session.osuser", WindowsOSUtils.getUserWithDomain());
        }
        if (properties.getProperty("OCINewPassword") != null) {
            properties2.setProperty("OCINewPassword", properties.getProperty("OCINewPassword"));
        }
        for (String string4 : stringArray = new String[]{"oracle.net.authentication_services", "oracle.net.kerberos5_cc_name", "oracle.net.authentication_services", "oracle.net.kerberos5_mutual_authentication", "oracle.net.kerberos5_cc_name", "access.alternate.url"}) {
            String string5 = null;
            string5 = properties.getProperty(string4);
            if (string5 == null) continue;
            properties2.setProperty(string4, string5);
        }
        String string6 = System.getProperty("jdbc.machine");
        if (string6 == null) {
            properties2.remove("v$session.machine");
        } else {
            String string7 = properties2.getProperty("v$session.machine");
            if (string7 != null && string7.length() > 60) {
                properties2.setProperty("v$session.machine", string7.substring(0, 60));
            }
        }
    }

    private void openProxySession(Connection connection, Properties properties) throws SQLException {
        String string = properties.getProperty("PROXY_TYPE");
        Properties properties2 = new Properties();
        if (string.equals("USER NAME")) {
            String string2 = properties.getProperty("PROXY_USER_NAME");
            String string3 = properties.getProperty("PROXY_USER_PASSWORD");
            properties2.put("PROXY_USER_NAME", string2);
            if (string3 != null && string3.length() > 0) {
                properties2.put("PROXY_USER_PASSWORD", string3);
            }
            ((OracleConnection)connection).openProxySession(1, properties2);
        } else if (string.equals("DISTINGUISHED NAME")) {
            properties2.put("PROXY_USER_NAME", properties.getProperty("PROXY_USER_NAME"));
            properties2.put("PROXY_DISTINGUISHED_NAME", properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            ((OracleConnection)connection).openProxySession(2, properties2);
        }
    }

    String getPassword(Properties properties, Properties properties2) throws IOException {
        String string = null;
        Properties properties3 = new Properties();
        properties3.putAll((Map<?, ?>)properties);
        properties2.remove(CANCEL_CONNECTION);
        try {
            ConnectionInfoPanel.promptForConnection(properties3);
            string = properties3.getProperty("password") == null ? "" : properties3.getProperty("password");
        }
        catch (ConnectionCanceledException connectionCanceledException) {
            properties2.setProperty(CANCEL_CONNECTION, "true");
            throw new IOException(connectionCanceledException.getLocalizedMessage());
        }
        return string;
    }
}

