/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.status;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.Collections;
import javax.ide.util.MetaResource;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.status.StatusPanelArb;

public class MemoryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JLabel sga_tar = new JLabel();
    String sga_tar_sql = null;
    JLabel sga_cur = new JLabel();
    String sga_cur_sql = null;
    JLabel pga_tar = new JLabel();
    String pga_tar_sql = null;
    JLabel pga_cur = new JLabel();
    String pga_cur_sql = null;
    JLabel tot_tar = new JLabel();
    JLabel tot_cur = new JLabel();
    Connection _conn = null;
    private static final String UNAVAILABLE = "unavailable";

    public MemoryPanel(Connection connection) {
        this._conn = connection;
        this.setupSql();
    }

    public void setupSql() {
        if (this.sga_tar_sql == null) {
            QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), "/oracle/dbtools/raptor/status/StatusSql.xml"));
            Query query = queryXMLSupport.getQuery("sga_tar", this._conn);
            this.sga_tar_sql = query.getSql();
            query = queryXMLSupport.getQuery("sga_cur", this._conn);
            this.sga_cur_sql = query.getSql();
            query = queryXMLSupport.getQuery("pga_tar", this._conn);
            this.pga_tar_sql = query.getSql();
            query = queryXMLSupport.getQuery("pga_cur", this._conn);
            this.pga_cur_sql = query.getSql();
        }
    }

    public JPanel getPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(StatusPanelArb.getString("TARGET_LABEL")), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)new JLabel(StatusPanelArb.getString("CURRENT_LABEL")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(StatusPanelArb.getString("SGA")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.sga_tar, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.sga_cur, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(StatusPanelArb.getString("PGA")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.pga_tar, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.pga_cur, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(StatusPanelArb.getString("CURRENT")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.tot_tar, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.tot_cur, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.refresh();
        return this;
    }

    public void refresh() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this._conn);
        dBUtil.setRaiseError(false);
        this.sga_tar.setText(this.fetchData(dBUtil, this.sga_tar_sql));
        this.sga_cur.setText(this.fetchData(dBUtil, this.sga_cur_sql));
        this.pga_tar.setText(this.fetchData(dBUtil, this.pga_tar_sql));
        this.pga_cur.setText(this.fetchData(dBUtil, this.pga_cur_sql));
        this.tot_cur.setText(this.total(this.sga_cur.getText().trim(), this.pga_cur.getText().trim()));
        if (this.fetchData(dBUtil, this.sga_tar_sql).equals("N/A")) {
            this.tot_tar.setText("N/A");
        } else {
            this.tot_tar.setText(this.total(this.sga_tar.getText().trim(), this.pga_tar.getText().trim()));
        }
        dBUtil.setRaiseError(true);
    }

    private String fetchData(DBUtil dBUtil, String string) {
        String string2 = dBUtil.executeReturnOneCol(string, Collections.EMPTY_LIST);
        return string2 != null ? string2 : UNAVAILABLE;
    }

    private String total(String string, String string2) {
        if (UNAVAILABLE.equals(string) || UNAVAILABLE.equals(string2)) {
            return UNAVAILABLE;
        }
        String string3 = "";
        try {
            string3 = Integer.toString(Integer.parseInt(string) + Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string3;
    }
}

