/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class SqlComboBoxActionControl
extends ActionControl {
    protected JComboBox _combo;
    protected Object _defaultValue;
    protected Boolean m_raiseError = null;
    public static boolean AUTO_DELAY = false;
    protected boolean _delayLoading;

    public SqlComboBoxActionControl(String string, String string2, Connection connection, String string3) {
        this(string, string2, connection, string3, (String)null);
    }

    public SqlComboBoxActionControl(String string, String string2, Connection connection, String string3, String string4) {
        this(string, string2, connection, string3, null, string4);
    }

    public SqlComboBoxActionControl(String string, String string2, Connection connection, String string3, Map<String, Object> map) {
        this(string, string2, connection, string3, map, null);
    }

    public SqlComboBoxActionControl(String string, String string2, Connection connection, String string3, Map<String, Object> map, String string4) {
        this(string, string2, connection, string3, map, string4, false);
    }

    public SqlComboBoxActionControl(String string, String string2, Connection connection, String string3, Map<String, Object> map, String string4, boolean bl) {
        this(string, string2, connection, string3, map, string4, bl, false);
    }

    public SqlComboBoxActionControl(String string, String string2, Connection connection, String string3, Map<String, Object> map, String string4, boolean bl, boolean bl2) {
        super(string, string2);
        this.setDefaultValue(string4);
        this._delayLoading = bl2;
        SQLComboxModel sQLComboxModel = this.createModel(Connections.getInstance().getConnectionName(connection), string3, map, string4);
        this.initCombo(string, sQLComboxModel, bl);
    }

    protected SQLComboxModel createModel(String string, String string2, Map<String, Object> map, String string3) {
        return new SQLComboxModel(string, string2, map, string3);
    }

    protected void initCombo(final String string, SQLComboxModel sQLComboxModel, boolean bl) {
        this._combo = new JComboBox();
        this.setComboModel(sQLComboxModel);
        this._combo.setName(string);
        this._combo.getEditor().getEditorComponent().setName(string + "_Editor");
        this.reset();
        if (bl) {
            this._combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SqlComboBoxActionControl.this.firePropertyChangeListeners(string);
                }
            });
        } else {
            this._combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SqlComboBoxActionControl.this.firePropertyChangeListeners();
                }
            });
        }
    }

    protected void setComboModel(final SQLComboxModel sQLComboxModel) {
        if ((AUTO_DELAY || this._delayLoading) && sQLComboxModel != null && sQLComboxModel.getDefaultObject() != null) {
            sQLComboxModel.setDelayed(true);
            this._combo.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    SqlComboBoxActionControl.this._combo.removePopupMenuListener(this);
                    sQLComboxModel.load();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        sQLComboxModel.setRaiseError(this.m_raiseError);
        this._combo.setModel(sQLComboxModel);
    }

    @Override
    public void reset() {
        this.setSelected(this._defaultValue);
    }

    public void setSelected(Object object) {
        if (object != null) {
            this._combo.setSelectedItem(object);
        } else if (this._combo.getItemCount() > 0) {
            this._combo.setSelectedIndex(0);
        }
    }

    public void resetQuery(Connection connection, String string, Map<String, Object> map, String string2) {
        SQLComboxModel sQLComboxModel = new SQLComboxModel(Connections.getInstance().getConnectionName(connection), string, map, string2);
        this.setDefaultValue(string2);
        this.setComboModel(sQLComboxModel);
        this.reset();
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        Object object = this._combo.getModel().getSelectedItem();
        value.set(object != null ? object.toString() : null);
        return value;
    }

    @Override
    public JComboBox getUI() {
        return this._combo;
    }

    @Override
    public void setEditable(boolean bl) {
        this._combo.setEnabled(bl);
    }

    public void enableEditBox() {
        this._combo.setEditable(true);
    }

    protected void setDefaultValue(Object object) {
        this._defaultValue = object;
    }

    public void setRaiseError(Boolean bl) {
        this.m_raiseError = bl;
        if (this._combo != null && this._combo.getModel() instanceof SQLComboxModel) {
            ((SQLComboxModel)this._combo.getModel()).setRaiseError(this.m_raiseError);
        }
    }

    public Boolean isLoaded() {
        if (this._combo != null && this._combo.getModel() instanceof SQLComboxModel) {
            return ((SQLComboxModel)this._combo.getModel()).isLoaded();
        }
        return null;
    }
}

