/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Messages;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.layout.URL2String;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.PlatformUtils;

public class URLChooserShortcuts
implements URLChooserShortcutProvider {
    private static List<URLChooserShortcut> s_shortcuts = null;
    private static URL s_scriptDir;
    private static URLPath s_userShortcuts;

    private static void addIfExists(URL uRL, String string, Collection<URLChooserShortcut> collection, Icon icon) {
        if (URLChooserShortcuts.isValidURL(uRL)) {
            boolean bl = true;
            for (URLChooserShortcut uRLChooserShortcut : collection) {
                if (!uRL.equals(uRLChooserShortcut.url())) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (icon == null) {
                    collection.add(new URLChooserShortcut(OracleIcons.getIcon((String)"folder.png"), string, uRL));
                } else {
                    collection.add(new URLChooserShortcut(icon, string, uRL));
                }
            }
        }
    }

    private static boolean isValidURL(URL uRL) {
        return URLFileSystem.exists((URL)uRL) && URLFileSystem.isDirectory((URL)uRL) && !URLFileSystem.isHidden((URL)uRL) && URLFileSystem.canRead((URL)uRL);
    }

    private static URL getScriptDir() {
        if (s_scriptDir == null) {
            s_scriptDir = DBConfig.getInstance().getScriptDirectory();
        }
        return s_scriptDir;
    }

    private static URLPath getUserShortcuts() {
        if (s_userShortcuts == null) {
            s_userShortcuts = DBConfig.getInstance().getURLFileChooserShortcuts();
        }
        return s_userShortcuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Collection<URLChooserShortcut> getShortcuts(boolean bl, boolean bl2) {
        String[] stringArray2;
        HashSet<URL> hashSet;
        URLPath uRLPath;
        ArrayList<URLChooserShortcut> arrayList = new ArrayList<URLChooserShortcut>();
        if (bl2) {
            uRLPath = URLChooserShortcuts.class;
            // MONITORENTER : oracle.dbtools.raptor.utils.URLChooserShortcuts.class
            if (s_shortcuts == null) {
                s_shortcuts = new ArrayList<URLChooserShortcut>();
                hashSet = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
                URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)((Object)hashSet), (String)Messages.getString("URLChooserShortcuts.3")), UtilsResources.get("DESKTOP"), s_shortcuts, RaptorImagesArb.getIcon("DESKTOP"));
                URLChooserShortcuts.addIfExists(URLFactory.newDirURL(hashSet, (String)Messages.getString("URLChooserShortcuts.4")), UtilsResources.get("DOCUMENTS"), s_shortcuts, RaptorImagesArb.getIcon("MY_DOCUMENTS"));
                if (!PlatformUtils.isWindows7()) {
                    URLChooserShortcuts.addIfExists(URLFactory.newDirURL(hashSet, (String)Messages.getString("URLChooserShortcuts.5")), UtilsResources.get("MY_DOCUMENTS"), s_shortcuts, RaptorImagesArb.getIcon("MY_DOCUMENTS"));
                }
            }
            // MONITOREXIT : uRLPath
            arrayList.addAll(s_shortcuts);
        }
        URLChooserShortcuts.addIfExists(URLChooserShortcuts.getScriptDir(), UtilsResources.get("SQL"), arrayList, null);
        uRLPath = URLChooserShortcuts.getUserShortcuts();
        for (String[] stringArray2 : uRLPath.asList()) {
            URLChooserShortcuts.addIfExists((URL)stringArray2, URLFileSystem.getName((URL)stringArray2), arrayList, null);
        }
        if (!bl) return arrayList;
        hashSet = new HashSet<URL>();
        stringArray2 = FileOpenHistory.getInstance().getFileHistory();
        int n = stringArray2.length - 1;
        while (n >= 0) {
            URL uRL;
            URL uRL2 = URL2String.toURL((String)stringArray2[n]);
            if (URLFileSystem.exists((URL)uRL2) && !hashSet.contains(uRL = URLFileSystem.getParent((URL)uRL2))) {
                hashSet.add(uRL);
                URLChooserShortcuts.addIfExists(uRL, URLFileSystem.getName((URL)uRL), arrayList, null);
            }
            --n;
        }
        return arrayList;
    }

    public Collection<URLChooserShortcut> createShortcuts(Context context) {
        return URLChooserShortcuts.getShortcuts(true, false);
    }

    static {
        DBConfig.getInstance().addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                String string = "";
                for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                    string = changeInfo.getPropertyLocalName();
                    if ("DEFAULTPATH".equals(string) && changeInfo.getChangeType() == 0) {
                        s_scriptDir = DBConfig.getInstance().getScriptDirectory();
                        continue;
                    }
                    string = changeInfo.getPropertyName();
                    if (string == null || !string.startsWith("URLFILECHOOSER_SHORTCUTS")) continue;
                    s_userShortcuts = DBConfig.getInstance().getURLFileChooserShortcuts();
                }
            }
        });
    }
}

