/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.Messages;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.DeleteActionHandler;

public class DirectoryDeleteHandler
extends DeleteActionHandler<DirectoryFolder> {
    public DirectoryDeleteHandler(Context context) {
        super(context);
        this.setDeleteStrategy(new Strat());
    }

    protected void preLaunchDialog() {
        super.preLaunchDialog();
    }

    protected Component createDeleteDetailsComponent() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        Element[] elementArray = this.getContext().getSelection();
        for (Element element : elementArray) {
            if (!(element instanceof DirectoryFolder)) continue;
            defaultMutableTreeNode.insert(DirectoryDeleteHandler.createNode((DirectoryFolder)element), defaultMutableTreeNode.getChildCount());
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        return jScrollPane;
    }

    protected DeleteActionHandler.DetailsTextConfig getDetailsTextConfig() {
        DeleteActionHandler.DetailsTextConfigBuilder detailsTextConfigBuilder = new DeleteActionHandler.DetailsTextConfigBuilder();
        detailsTextConfigBuilder.title(Messages.getString("FileNav.deleteDir"));
        detailsTextConfigBuilder.header(Messages.getString("FileNav.deletePrompt"));
        detailsTextConfigBuilder.description(Messages.getString("FileNav.deleteInclude"));
        detailsTextConfigBuilder.confirmTitle(Messages.getString("FileNav.deleteConfirm"));
        detailsTextConfigBuilder.confirmMessage(Messages.getString("FileNav.deleteConfirmUndo"));
        detailsTextConfigBuilder.showDetails(Messages.getString("FileNav.deleteShow"));
        detailsTextConfigBuilder.hideDetails(Messages.getString("FileNav.deleteHide"));
        detailsTextConfigBuilder.helpTopicId("f1_delete_confirmation_html");
        return detailsTextConfigBuilder.build();
    }

    private static MutableTreeNode createNode(DirectoryFolder directoryFolder) {
        return new DefaultMutableTreeNode((Object)directoryFolder);
    }

    private static class Strat
    extends DeleteActionHandler.DeleteStrategy<DirectoryFolder> {
        private Strat() {
        }

        public boolean delete(DirectoryFolder directoryFolder) {
            URL uRL = directoryFolder.getURL();
            try {
                URLFileSystem.deleteEx((URL)uRL);
                return true;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Throwable)iOException);
                return false;
            }
        }
    }
}

