/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.filenav.FileNavigatorController;
import oracle.dbtools.raptor.filenav.FileNavigatorResources;
import oracle.dbtools.raptor.filenav.NavRoot;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Folder;
import oracle.ide.util.PropertyAccess;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

class FileNavigatorWindow
extends DefaultNavigatorWindow {
    private String m_title;
    private Controller m_controller;
    private NavRoot m_root;

    protected FileNavigatorWindow(Context context, String string, String string2) {
        super(context, string);
        this.m_title = string2;
        Folder folder = (Folder)DefaultNavigatorManager.getFolderFromContext((Context)context);
        this.m_root = (NavRoot)folder;
    }

    public String getTitleName() {
        return FileNavigatorResources.getString("PROVIDER_LABEL");
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Controller getController() {
        if (this.m_controller == null) {
            this.m_controller = new FileNavigatorController(super.getController(), this);
        }
        return this.m_controller;
    }

    protected boolean isSaveExpansionState() {
        return true;
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        context.setWorkspace(this.m_root.getWorkspace());
        context.setProject(this.m_root.getProject());
        return context;
    }

    public void loadLayout(PropertyAccess propertyAccess) {
        super.loadLayout(propertyAccess);
        final TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TNode tNode = treeExplorer.getRoot();
                    ExplorerContext.restoreExpansionState((TNode)tNode, (TreeExplorer)treeExplorer, null);
                }
            });
        }
    }
}

