/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.ArrayList;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.ErrorSupport;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlParserHelper;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.icons.OracleIcons;

class DBErrorSupport
extends ErrorSupport.ErrorProvider {
    DBErrorSupport() {
    }

    @Override
    public void update(DBObjectNode node, final Element root) {
        if (node instanceof BaseDBObjectTextNode) {
            BaseDBObjectTextNode tnode = (BaseDBObjectTextNode)node;
            DBObjectProvider pro = tnode.getProvider();
            final SourceObject so = tnode.getDBObject(false);
            if (so instanceof PlSqlSourceObject) {
                DBRequestProcessor reqProc = DBRequestProcessorFactory.getProcessor((DBObjectNode)tnode);
                String string = this.getClass().getSimpleName();
                DBRequestProcessor dBRequestProcessor = reqProc;
                dBRequestProcessor.getClass();
                reqProc.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor, pro, root.getShortLabel()){
                    {
                        DBRequestProcessor dBRequestProcessor = x0;
                        dBRequestProcessor.getClass();
                        super(dBRequestProcessor, x1, x2);
                    }

                    protected void doWork() {
                        ArrayList<PlSqlFragmentElement> errors = null;
                        for (PlSqlParserHelper.Issue issue : PlSqlParserHelper.getIssues((PlSqlSourceObject)((PlSqlSourceObject)so))) {
                            if (errors == null) {
                                errors = new ArrayList<PlSqlFragmentElement>();
                            }
                            errors.add(new PlSqlFragmentElement(issue.getMessage(), "", OracleIcons.getIcon((String)"error.png"), issue.getStartOffset(), issue.getEndOffset()));
                        }
                        DBObjectFolderFactory.setErrors(root, errors);
                    }
                }, 1500);
            }
        }
    }
}

