/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.resource.ExplorerBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;

abstract class BaseFolder
implements Element,
Subject,
DBExplorerElement {
    private final Collection<Observer> m_observers = new ArrayList<Observer>();
    private final List<Element> m_children = new CopyOnWriteArrayList<Element>();
    private ErrorsFolder m_errorsFolder;
    private boolean m_loaded;
    private boolean m_loading;
    private final Attributes m_attributes = new ElementAttributes();
    private final Comparator<Element> m_childComparator = new Comparator<Element>(){

        @Override
        public int compare(Element o1, Element o2) {
            return BaseFolder.this.compareChildren(o1, o2);
        }
    };
    private ExplorerModelHelper m_helper;

    BaseFolder() {
    }

    public final void setContext(Context context) {
        this.setHelper(new ExplorerModelHelper(context));
    }

    @Override
    public final void setHelper(ExplorerModelHelper helper) {
        if (helper != null) {
            this.m_helper = helper;
        }
    }

    protected final ExplorerModelHelper getHelper() {
        return this.m_helper;
    }

    @Override
    public void reset() {
        if (this.m_loaded && !this.m_loading) {
            this.m_loaded = false;
            this.initChildren();
        }
    }

    void setErrors(List<Element> elems) {
        ErrorsFolder existing = this.m_errorsFolder;
        if (elems == null) {
            this.m_errorsFolder = null;
            if (existing != null) {
                this.m_children.remove(existing);
                UpdateMessage.fireChildRemoved((Subject)this, (Element)existing);
            }
        } else {
            if (existing == null) {
                this.m_errorsFolder = new ErrorsFolder();
            }
            this.m_errorsFolder.setErrors(elems);
            if (existing == null) {
                this.m_children.add(0, this.m_errorsFolder);
                UpdateMessage.fireChildAdded((Subject)this, (Element)this.m_errorsFolder);
                UpdateMessage.fireStructureChanged((Subject)this);
            } else {
                UpdateMessage.fireStructureChanged((Subject)this.m_errorsFolder);
            }
        }
    }

    private synchronized void initChildren() {
        ExplorerModelHelper helper = this.getHelper();
        if (!this.m_loaded && helper != null) {
            this.m_loading = true;
            this.m_loaded = true;
            DBObjectProvider pro = this.useDBRunnable();
            if (pro == null) {
                this.loadChildren();
            } else {
                DBRequestProcessor reqProc;
                LoadingElement elem = new LoadingElement();
                if (this.m_children.size() == 0) {
                    this.m_children.add(elem);
                    UpdateMessage msg = this.createChildAddedMessage();
                    msg.getAddObjects().add(elem);
                    this.notifyObservers(this, msg);
                }
                DBRequestProcessor dBRequestProcessor = reqProc = DBRequestProcessorFactory.getProcessor((DBObjectNode)helper.getNode());
                dBRequestProcessor.getClass();
                reqProc.execute(new DBRequestProcessor.DBRunnable(dBRequestProcessor, pro, elem.getShortLabel()){
                    {
                        DBRequestProcessor dBRequestProcessor = x0;
                        dBRequestProcessor.getClass();
                        super(dBRequestProcessor, x1, x2);
                    }

                    protected void doWork() {
                        BaseFolder.this.loadChildren();
                    }
                });
            }
        }
    }

    protected DBObjectProvider useDBRunnable() {
        return null;
    }

    protected final int compareChildren(Element o1, Element o2) {
        if (o1.mayHaveChildren()) {
            if (!o2.mayHaveChildren()) {
                return -1000;
            }
        } else if (o2.mayHaveChildren()) {
            return 1000;
        }
        return String.valueOf(o1.getShortLabel()).toUpperCase().compareTo(String.valueOf(o2.getShortLabel()).toUpperCase());
    }

    protected boolean sortChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChildren() {
        this.m_loading = true;
        try {
            final List<Element> newList = this.createChildren(this.m_children);
            if (this.sortChildren()) {
                Collections.sort(newList, this.m_childComparator);
            }
            if (this.m_errorsFolder != null) {
                newList.add(0, this.m_errorsFolder);
            }
            final ArrayList<Element> added = new ArrayList<Element>();
            final ArrayList<Element> removed = new ArrayList<Element>(this.m_children);
            for (Element elem : newList) {
                if (elem instanceof DBExplorerElement) {
                    ((DBExplorerElement)elem).setHelper(this.getHelper());
                }
                if (!this.contains(this.m_children, elem)) {
                    added.add(elem);
                    continue;
                }
                if (elem instanceof DBExplorerElement) {
                    ((DBExplorerElement)elem).reset();
                }
                removed.remove(elem);
            }
            Runnable doit = new Runnable(){

                @Override
                public void run() {
                    BaseFolder.this.m_children.clear();
                    BaseFolder.this.m_children.addAll(newList);
                    BaseFolder.this.fireMessages(removed, added);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                doit.run();
            } else {
                SwingUtilities.invokeLater(doit);
            }
        }
        finally {
            this.m_loading = false;
        }
    }

    protected void fireMessages(List<Element> removed, List<Element> added) {
        if (removed.size() > 0) {
            UpdateMessage.fireChildrenRemoved((Subject)this, removed);
        }
        if (added.size() > 0) {
            UpdateMessage msg = this.createChildAddedMessage();
            msg.getAddObjects().addAll(added);
            this.notifyObservers(this, msg);
            UpdateMessage.fireStructureChanged((Subject)this);
        }
    }

    private UpdateMessage createChildAddedMessage() {
        UpdateMessage retval = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
        TreeExplorer.setSelectAddedChild((UpdateMessage)retval, (boolean)false);
        return retval;
    }

    private <T> boolean contains(List<? extends T> elems, T elem) {
        boolean retval = false;
        for (T test : elems) {
            if (test != elem) continue;
            retval = true;
            break;
        }
        return retval;
    }

    protected abstract List<Element> createChildren(List<Element> var1);

    public boolean mayHaveChildren() {
        return true;
    }

    public final Iterator<Element> getChildren() {
        this.initChildren();
        return Collections.unmodifiableList(this.m_children).iterator();
    }

    public final int size() {
        this.initChildren();
        return this.m_children.size();
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        for (Observer o : this.m_observers) {
            o.update(subject, change);
        }
    }

    public void detach(Observer observer) {
        this.m_observers.remove(observer);
    }

    public void attach(Observer observer) {
        this.m_observers.add(observer);
    }

    public final Object getData() {
        return this;
    }

    public final Attributes getAttributes() {
        return this.m_attributes;
    }

    private class ErrorsFolder
    extends BaseFolder {
        private List<Element> m_errors;

        private ErrorsFolder() {
        }

        @Override
        void setErrors(List<Element> errors) {
            if (this.m_errors != null) {
                UpdateMessage.fireChildrenRemoved((Subject)this, this.m_errors);
            }
            this.m_errors = errors;
            if (errors != null) {
                UpdateMessage.fireChildrenAdded((Subject)this, errors);
            }
        }

        @Override
        protected List<Element> createChildren(List<Element> existing) {
            return this.m_errors == null ? Collections.emptyList() : this.m_errors;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"folder.png");
        }

        @Override
        public Object getKey() {
            return "ERRORS";
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public String getShortLabel() {
            return ExplorerBundle.get("EXPLORER_ERROR_FOLDER");
        }

        public String getToolTipText() {
            return null;
        }
    }

    private final class LoadingElement
    extends DefaultElement
    implements DBExplorerElement {
        private LoadingElement() {
        }

        @Override
        public Object getKey() {
            return this;
        }

        @Override
        public void reset() {
        }

        @Override
        public void setHelper(ExplorerModelHelper helper) {
        }

        public String getShortLabel() {
            return ExplorerBundle.format("EXPLORER_PROGRESS_MESSAGE", BaseFolder.this.getShortLabel());
        }

        public String getToolTipText() {
            return this.getShortLabel();
        }
    }
}

