/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.ObjectChildElement;
import oracle.ideimpl.db.explorer.model.ObjectFolder;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.icons.OracleIcons;

final class DBTypeFolder
extends BaseFolder
implements DBObjectTypeNode,
ObjectChildElement<DBObject> {
    private URL m_url;
    private DBObject m_obj;
    private PropertyInfo m_info;
    private DBObjectProvider m_pro;
    private Icon m_icon;

    public DBTypeFolder(DBObject obj, PropertyInfo info, DBObjectProvider pro) {
        this.m_obj = obj;
        this.m_info = info;
        this.m_pro = pro;
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) {
        ArrayList<Element> retval = new ArrayList<Element>();
        Object value = this.m_info.getPropertyValue((Object)this.m_obj);
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                DBExplorerElement elem = null;
                if (obj instanceof DBObject) {
                    elem = ExplorerModelHelper.find(existing, ExplorerModelHelper.getKeyForObject((DBObject)obj, this.m_info.getPropertyName()));
                    if (elem instanceof DBObjectFolder) {
                        ((DBObjectFolder)elem).setObject((DBObject)obj);
                    } else {
                        elem = new DBObjectFolder((DBObject)obj, this.m_pro, null);
                    }
                } else {
                    elem = new ObjectFolder<Object>(obj, this.m_pro, null);
                }
                if (elem == null) continue;
                elem.setHelper(this.getHelper());
                retval.add(elem);
            }
        } else if (value != null) {
            throw new IllegalStateException(this.m_info.getPropertyName() + ": DBTypeFolder is only valid for array props");
        }
        return retval;
    }

    public String getSchemaName() {
        return null;
    }

    public String getObjectType() {
        Class<?> clz = this.m_info.getPropertyClass();
        if (clz.isArray()) {
            clz = clz.getComponentType();
        }
        return Metadata.getType((Class)clz);
    }

    public Object getProviderIdentifier() {
        return null;
    }

    public String getProviderType() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.m_info.getPropertyName();
    }

    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = DBTypeDisplayRegistry.getFolderIcon((String)this.getObjectType());
            if (this.m_icon == null) {
                this.m_icon = OracleIcons.getIcon((String)"folder.png");
            }
        }
        return this.m_icon;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return PropertyDisplayRegistry.getDisplayName((String)this.m_info.getPropertyName(), (DBObjectProvider)this.m_pro, (DBObject)this.m_obj);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public void setURL(URL url) {
        this.m_url = url;
    }

    public URL getURL() {
        return this.m_url;
    }

    @Override
    public void setParentObject(DBObject obj) {
        this.m_obj = obj;
    }

    @Override
    protected boolean sortChildren() {
        String propName = this.m_info.getPropertyName();
        return "constraints".equals(propName) || "indexes".equals(propName);
    }
}

