/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.DBTypeFolder;
import oracle.ideimpl.db.explorer.model.ObjectChildElement;
import oracle.ideimpl.db.explorer.model.PropertiesFolder;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.ModelUtil;

final class ExplorerModelHelper {
    private static final Collection<String> s_globallyIgnored = new ArrayList<String>();
    private Context m_context;

    public ExplorerModelHelper(Context context) {
        this.m_context = context;
        if (context == null || !(context.getNode() instanceof DBObjectNode)) {
            throw new IllegalArgumentException("Context must contain a DBObject.");
        }
    }

    public DBExplorerElement findOrCreateElement(Object parent, PropertyInfo info, DBObjectProvider pro, List<Element> existing) {
        DBExplorerElement elem = null;
        if (!ExplorerModelHelper.isIgnoredProperty(info, pro, parent)) {
            String propName = info.getPropertyName();
            Class propClz = info.getPropertyClass();
            if (Schema.class == propClz) {
                elem = new PropertyNode(info, parent, pro);
            } else if (DBObject.class.isAssignableFrom(propClz)) {
                DBObject obj = (DBObject)info.getPropertyValue(parent);
                if (obj != null) {
                    elem = ExplorerModelHelper.find(existing, ExplorerModelHelper.getKeyForObject(obj, propName));
                    if (elem instanceof DBObjectFolder) {
                        ((DBObjectFolder)elem).setObject(obj);
                    } else {
                        elem = new DBObjectFolder(obj, pro, propName);
                    }
                }
            } else {
                elem = ExplorerModelHelper.find(existing, propName);
                if (elem == null || elem instanceof PropertyNode) {
                    if (propClz.isArray()) {
                        if (parent instanceof DBObject) {
                            elem = new DBTypeFolder((DBObject)parent, info, pro);
                        }
                    } else if (Map.class.isAssignableFrom(propClz) || DynamicPropertySet.class.isAssignableFrom(propClz)) {
                        PropertiesFolder folder = new PropertiesFolder(parent, info, pro);
                        folder.setHelper(this);
                        if (folder.shouldInclude()) {
                            elem = folder;
                        }
                    } else {
                        elem = new PropertyNode(info, parent, pro);
                    }
                } else if (elem instanceof ObjectChildElement) {
                    ((ObjectChildElement)((Object)elem)).setParentObject(parent);
                }
            }
        }
        if (elem != null) {
            elem.setHelper(this);
        }
        return elem;
    }

    public boolean isChildOfTopObject(DBObjectID id) {
        DBObject obj;
        boolean retval = false;
        Node node = this.m_context.getNode();
        if (node instanceof DBObjectNode && (obj = ((DBObjectNode)node).getDBObject()) != null) {
            DBObjectID topID = obj.getID();
            retval = DBUtil.isSameOrChildOf((DBObjectID)id, (DBObjectID)topID, (boolean)true);
        }
        return retval;
    }

    static final Object getKeyForObject(DBObject childObj, String propName) {
        String retval = childObj.getName();
        if (!ModelUtil.hasLength((String)retval)) {
            retval = propName;
        }
        return String.valueOf(retval);
    }

    static final DBExplorerElement find(List<Element> elems, Object key) {
        DBExplorerElement retval = null;
        if (elems != null) {
            for (Element elem : elems) {
                if (!(elem instanceof DBExplorerElement) || !ModelUtil.areEqual((Object)((DBExplorerElement)elem).getKey(), (Object)key)) continue;
                retval = (DBExplorerElement)elem;
                break;
            }
        }
        return retval;
    }

    static Collection<String> getExtraProperties(DBObjectProvider pro, Object object) {
        if (pro instanceof Database && object instanceof Index) {
            return Collections.singletonList("table");
        }
        return Collections.emptyList();
    }

    static boolean isIgnoredProperty(PropertyInfo info, DBObjectProvider pro, Object object) {
        String propertyName = info.getPropertyName();
        boolean ignore = s_globallyIgnored.contains(propertyName);
        if (object instanceof DBObject && !ignore) {
            String dispName = PropertyDisplayRegistry.getDisplayNameOrNull((String)propertyName, (DBObjectProvider)pro, (DBObject)((DBObject)object));
            if (dispName == null) {
                ignore = true;
            } else if (!DBUtil.needsBuilding((DBObject)((DBObject)object), (String)propertyName)) {
                Object value = info.getPropertyValue(object);
                ignore = value == null && info.getNullBehaviour() != Nullable.NullBehaviour.NULLABLE;
            }
        }
        return ignore;
    }

    DBObjectNode getNode() {
        Node node = this.m_context.getNode();
        if (!(node instanceof DBObjectNode)) {
            String nodeDesc = node == null ? "null" : node.getClass().getName() + " " + node.getLongLabel();
            throw new IllegalStateException("Context must have a DBObjectNode, not " + nodeDesc);
        }
        DBObjectNode retval = (DBObjectNode)node;
        return retval;
    }

    static {
        s_globallyIgnored.add("ID");
        s_globallyIgnored.add("name");
        s_globallyIgnored.add("SQLQuery");
        s_globallyIgnored.add("code");
        s_globallyIgnored.add("source");
        s_globallyIgnored.add("bytes");
        s_globallyIgnored.add("password");
        s_globallyIgnored.add("passwordX");
        s_globallyIgnored.add("authentificationPassword");
        s_globallyIgnored.add("authentificationPasswordX");
    }
}

