/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

class ObjectFolder<T>
extends BaseFolder {
    private DBObjectProvider m_pro;
    private T m_obj;
    private String m_propName;
    private Icon m_icon;
    private String m_text;
    private Comparator<String> m_cic = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toUpperCase().compareTo(o2.toUpperCase());
        }
    };

    public ObjectFolder(T object, DBObjectProvider pro, String propName) {
        this.m_obj = object;
        this.m_pro = pro;
        this.m_propName = propName;
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) {
        ArrayList<Element> retval = new ArrayList<Element>();
        DBObjectProvider pro = this.getProvider();
        T folderObj = this.getObject();
        if (folderObj != null) {
            PropertyIterator iter = new PropertyIterator(folderObj.getClass(), pro.getClass());
            boolean hideTransient = !(folderObj instanceof DBObjectPlSqlFragment);
            for (PropertyInfo info : iter.getPropertyInfos(hideTransient, hideTransient, true).values()) {
                String propName = info.getPropertyName();
                DBExplorerElement elem = this.findOrCreateElement(info, existing);
                if (elem == null) continue;
                retval.add(elem);
            }
            Collection<String> extras = ExplorerModelHelper.getExtraProperties(pro, folderObj);
            if (!extras.isEmpty()) {
                Map infos = iter.getPropertyInfos(false, false, false);
                for (String extraProp : extras) {
                    DBExplorerElement elem;
                    PropertyInfo info = (PropertyInfo)infos.get(extraProp);
                    if (info == null || (elem = this.findOrCreateElement(info, existing)) == null) continue;
                    retval.add(elem);
                }
            }
        }
        return retval;
    }

    private DBExplorerElement findOrCreateElement(PropertyInfo info, List<Element> existing) {
        DBObjectProvider pro = this.getProvider();
        T folderObj = this.getObject();
        return this.getHelper().findOrCreateElement(folderObj, info, pro, existing);
    }

    protected String getPropertyName() {
        return this.m_propName;
    }

    protected T getObject() {
        return this.m_obj;
    }

    void setObject(T obj) {
        this.m_obj = obj;
    }

    public DBObjectProvider getProvider() {
        return this.m_pro;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_text = null;
        this.m_icon = null;
    }

    @Override
    public boolean mayHaveChildren() {
        T obj = this.getObject();
        return obj instanceof Copyable && !(obj instanceof DBObjectID);
    }

    @Override
    public Object getKey() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public String getShortLabel() {
        if (this.m_text == null) {
            this.m_text = this.createLabel();
        }
        return this.m_text;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = this.createIcon();
        }
        return this.m_icon;
    }

    protected Icon createIcon() {
        Icon retval = null;
        if (this.m_obj instanceof DBObject) {
            retval = DBTypeDisplayRegistry.getNodeIcon((DBObject)((DBObject)this.m_obj));
        } else if (this.m_obj instanceof DBObjectID) {
            retval = DBTypeDisplayRegistry.getNodeIcon((String)((DBObjectID)this.m_obj).getType());
        }
        if (retval == null) {
            retval = OracleIcons.getIcon((String)"properties.png");
        }
        return retval;
    }

    protected String createPropertyLabel(String propName, Object value, DBObject context) {
        String valueDisplay;
        StringBuilder buff = new StringBuilder();
        if (propName != null) {
            buff.append(PropertyDisplayRegistry.getDisplayName((String)propName, (DBObjectProvider)this.getProvider(), (DBObject)context));
        }
        if (ModelUtil.hasLength((String)(valueDisplay = PropertyDisplayRegistry.getPropValueDisplay((String)propName, (Object)value)))) {
            if (buff.length() > 0) {
                buff.append(" : ");
            }
            if (valueDisplay.contains("\n")) {
                buff.append(valueDisplay.replaceAll("\\n", " "));
            } else {
                buff.append(valueDisplay);
            }
        }
        return buff.toString();
    }

    protected String createLabel() {
        String value = null;
        if (this.m_obj instanceof DBObject) {
            value = ((DBObject)this.m_obj).getName();
            if (value == null) {
                value = "";
            }
        } else if (this.m_obj instanceof DBObjectID && (value = this.m_obj instanceof DataTypeID ? ((DataTypeID)this.m_obj).getTypeName() : (this.getHelper().isChildOfTopObject((DBObjectID)this.m_obj) ? DBUtil.getDBObjectName((DBObjectID)((DBObjectID)this.m_obj)) : DBUtil.getFullyQualifiedName((DBObjectID)((DBObjectID)this.m_obj)))) == null) {
            value = "";
        }
        if (value == null) {
            value = this.m_obj;
        }
        return this.createPropertyLabel(this.m_propName, value, this.m_obj instanceof DBObject ? (DBObject)this.m_obj : null);
    }
}

