/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.db.explorer.PlSqlCodeExplorer;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

final class PlSqlFolder
extends BaseFolder {
    private DBObjectPlSqlNode m_node;

    public PlSqlFolder(DBObjectPlSqlNode node, Context context) {
        this.m_node = node;
        this.setContext(context);
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    private CodeSection init() {
        PlSqlFragment rfrag;
        CodeSection root = new CodeSection("root", this.getIcon());
        PlSqlInterrogator plsInt = PlSqlCodeExplorer.getInterrogator(this.m_node);
        if (plsInt != null && (rfrag = plsInt.getRoot()) != null) {
            this.buildTreeForFragment(plsInt, plsInt.getRoot(), root);
        }
        return root;
    }

    private void buildTreeForFragment(PlSqlInterrogator m_plsInt, PlSqlFragment frag, CodeSection folder) {
        if (frag.getFragmentType() == PlSqlFragment.Type.TYPE_SPEC && ModelUtil.hasLength((String)m_plsInt.getCollectionType())) {
            return;
        }
        for (PlSqlFragment childFrag : frag.getChildren()) {
            Icon icon = null;
            switch (childFrag.getFragmentType()) {
                case PACKAGE_SPEC: 
                case PACKAGE_BODY: {
                    icon = OracleIcons.getIcon((String)"plsql_package.png");
                    break;
                }
                case PROCEDURE: {
                    icon = OracleIcons.getIcon((String)"plsql_proc.png");
                    break;
                }
                case FUNCTION: {
                    icon = OracleIcons.getIcon((String)"plsql_function.png");
                    break;
                }
                case PROCEDURE_FD: {
                    icon = OracleIcons.getIcon((String)"plsql_proc.png");
                    break;
                }
                case FUNCTION_FD: {
                    icon = OracleIcons.getIcon((String)"plsql_function.png");
                    break;
                }
                case TYPE_SPEC: 
                case TYPE_BODY: {
                    icon = OracleIcons.getIcon((String)"domain.png");
                    break;
                }
                case TRIGGER: 
                case TRIGGER_COLUMNS: 
                case TRIGGER_EVENTS: 
                case TRIGGER_REFERENCING: 
                case TRIGGER_ROW_LEVEL: 
                case TRIGGER_TABLE: 
                case TRIGGER_TIMING: 
                case TRIGGER_WHEN: {
                    icon = OracleIcons.getIcon((String)"trigger.png");
                    break;
                }
                case PARAMETER_LIST: {
                    icon = OracleIcons.getIcon((String)"folder.png");
                    break;
                }
                case PARAMETER: {
                    icon = OracleIcons.getIcon((String)"parameter.png");
                    break;
                }
                case DECLARATION: {
                    if (childFrag.getFirstToken().matches("TYPE") || childFrag.getFirstToken().matches("SUBTYPE")) {
                        icon = OracleIcons.getIcon((String)"domain.png");
                        break;
                    }
                    icon = OracleIcons.getIcon((String)"field.png");
                    break;
                }
                default: {
                    icon = null;
                }
            }
            if (icon != null && childFrag.getAlterSubType() != null) {
                PlSqlFragment.AlterSubType subType = childFrag.getAlterSubType();
                switch (subType) {
                    case ADD_ATTRIBUTE: 
                    case ADD_METHOD: {
                        icon = new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"add.png"));
                        break;
                    }
                    case MODIFY_ATTRIBUTE: {
                        icon = new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"edit.png"));
                        break;
                    }
                    case DROP_ATTRIBUTE: 
                    case DROP_METHOD: {
                        icon = new IconWithSmallOverlay(icon, OracleIcons.getIcon((String)"delete.png"));
                    }
                }
            }
            if (icon == null) continue;
            if (childFrag.getChildren().length > 0) {
                CodeSection childFolder = new CodeSection(childFrag, icon);
                folder.addChild(childFolder);
                this.buildTreeForFragment(m_plsInt, childFrag, childFolder);
                continue;
            }
            PlSqlFragmentElement element = new PlSqlFragmentElement(childFrag, icon);
            folder.addChild(element);
        }
    }

    public Icon getIcon() {
        return this.m_node.getIcon();
    }

    public String getLongLabel() {
        return this.m_node.getLongLabel();
    }

    public String getShortLabel() {
        return this.m_node.getShortLabel();
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    @Override
    public Object getKey() {
        return this.m_node;
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) {
        return new ArrayList<Element>(this.init().m_children);
    }

    @Override
    protected void fireMessages(List<Element> removed, List<Element> added) {
        UpdateMessage.fireStructureChanged((Subject)this);
    }

    @Override
    protected DBObjectProvider useDBRunnable() {
        return DBObjectNodeUtil.findProvider((Object)this.m_node);
    }

    public class CodeSection
    extends PlSqlFragmentElement {
        private final Collection<PlSqlFragmentElement> m_children;

        public CodeSection(String label, Icon icon) {
            super(label, null, icon, -1, -1);
            this.m_children = new ArrayList<PlSqlFragmentElement>();
        }

        public CodeSection(PlSqlFragment frag, Icon icon) {
            super(frag, icon);
            this.m_children = new ArrayList<PlSqlFragmentElement>();
        }

        @Override
        public boolean mayHaveChildren() {
            return true;
        }

        public Iterator getChildren() {
            return this.m_children.iterator();
        }

        public void addChild(PlSqlFragmentElement child) {
            this.m_children.add(child);
        }
    }
}

