/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;
import oracle.javatools.db.timesten.TimesTen11g;
import oracle.javatools.db.timesten.TimesTen11gR2;
import oracle.javatools.db.timesten.TimesTenDDLType;
import oracle.javatools.db.timesten.TimesTenDatabase;

class TimesTenDDLGenerator
extends BundleDDLGenerator<TimesTenDDLType> {
    TimesTenDDLGenerator(DBObjectProvider pro, Class<? extends TimesTenDatabase> ttClz) {
        super(ttClz, pro, TimesTenDDLGenerator.getBundles(ttClz));
        if (TimesTen11g.class.isAssignableFrom(ttClz)) {
            OracleDDLSupport oraDDL = OracleDDLSupport.getInstance();
            for (Map.Entry entry : oraDDL.getGlobalTokenGenerators().entrySet()) {
                this.registerTokenGenerator((String)entry.getKey(), (TokenGenerator)entry.getValue());
            }
            oraDDL.includeOracleSyntax((TokenDDLGenerator)this, "SYNONYM", false);
            oraDDL.includeOracleSyntax((TokenDDLGenerator)this, "SEQUENCE", false);
            oraDDL.includeOracleSyntax((TokenDDLGenerator)this, "PACKAGE", false);
            oraDDL.includeOracleSyntax((TokenDDLGenerator)this, "FUNCTION", false);
            oraDDL.includeOracleSyntax((TokenDDLGenerator)this, "PROCEDURE", false);
            this.registerTopLevelChild("TABLE", "indexes", "INDEX");
        }
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        Set<Boolean> retval = super.getAllowedPropertyValues(originalObject, updatedObject, property);
        if ("inline".equals(property) && updatedObject instanceof Column) {
            String type;
            DBObjectID id;
            boolean allowed = false;
            DataTypeUsage dtu = ((Column)updatedObject).getDataTypeUsage();
            if (dtu != null && (id = dtu.getDataTypeID()) instanceof DataTypeID && ((type = ((DataTypeID)id).getTypeName()).matches(".*VARCHAR.*") || type.matches(".*VARBINARY.*"))) {
                allowed = true;
            }
            if (!allowed) {
                retval = Collections.singleton(false);
            }
        }
        return retval;
    }

    protected TimesTenDDLType getDDLType(String type) {
        return TimesTenDDLType.getDDLType(type);
    }

    private static String[] getBundles(Class<? extends TimesTenDatabase> ttClz) {
        String[] retval = TimesTen11g.class.isAssignableFrom(ttClz) || TimesTen11gR2.class.isAssignableFrom(ttClz) ? new String[]{"/oracle/javatools/db/timesten/TimesTen7DDL.properties", "/oracle/javatools/db/timesten/TimesTen11gDDL.properties"} : new String[]{"/oracle/javatools/db/timesten/TimesTen7DDL.properties"};
        return retval;
    }
}

