/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.timesten;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import oracle.ideri.util.Product;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTen11g;
import oracle.javatools.db.timesten.TimesTen11gR2;
import oracle.javatools.db.timesten.TimesTen7;
import oracle.javatools.db.timesten.TimesTenDatabaseDescriptor;
import oracle.javatools.db.timesten.TimesTenDatabaseImpl;
import oracle.javatools.db.timesten.resource.TTBundle;

public class TimesTenDatabaseFactory
extends BaseDatabaseCreator {
    public TimesTenDatabaseFactory() {
        this.registerProviderClass(TimesTenDatabaseImpl.class, TTBundle.get("DB_TIMESTEN_6"), new TimesTenDatabaseImpl.Registerer());
        this.registerProviderClass(TimesTen7.class, TTBundle.get("DB_TIMESTEN_7"), new TimesTen7.Registerer());
        this.registerProviderClass(TimesTen11g.class, TTBundle.get("DB_TIMESTEN_11g"), new TimesTen11g.Registerer());
        this.registerProviderClass(TimesTen11gR2.class, TTBundle.get("DB_TIMESTEN_11gR2"), new TimesTen11gR2.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getTimesTenConnectionVersion(conn);
        switch (t) {
            case 0: {
                return null;
            }
            case 112: {
                return new TimesTen11gR2(connStore, connName, conn);
            }
            case 110: {
                return new TimesTen11g(connStore, connName, conn);
            }
            case 7: {
                return new TimesTen7(connStore, connName, conn);
            }
        }
        return new TimesTenDatabaseImpl(connStore, connName, conn);
    }

    private int getTimesTenConnectionVersion(Connection conn) {
        int ttVersion;
        block6: {
            ttVersion = 0;
            if (conn != null && !Product.isRaptor()) {
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    String dbName = dmd.getDatabaseProductName();
                    if (!dbName.startsWith("TimesTen")) break block6;
                    try {
                        int majorVer = dmd.getDatabaseMajorVersion();
                        int minorVer = this.getMinorVersion(dmd.getDatabaseProductVersion());
                        if (majorVer == 11) {
                            ttVersion = minorVer >= 2 ? 112 : 110;
                            break block6;
                        }
                        ttVersion = majorVer;
                    }
                    catch (Throwable t) {}
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return ttVersion;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        TimesTenDatabaseDescriptor retval = null;
        if (TimesTenDatabaseImpl.class.isAssignableFrom(providerClass)) {
            retval = new TimesTenDatabaseDescriptor(providerClass);
        }
        return retval;
    }

    private int getMinorVersion(String productName) {
        StringTokenizer st = new StringTokenizer(productName, " .");
        int tokens = 0;
        int minorVersion = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (tokens == 2) {
                try {
                    minorVersion = Integer.parseInt(token);
                }
                catch (NumberFormatException nfe) {
                    minorVersion = 0;
                }
                break;
            }
            ++tokens;
        }
        return minorVersion;
    }
}

