/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.CascadeTriggerLister;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.refactoring.CascadeProcessor;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DummyDBObjectProvider
extends AbstractDBObjectProvider {
    public static final String PROVIDER_TYPE = "dummy";
    private final String m_name;
    private final DatabaseDescriptor m_desc;
    private final boolean m_useIdentifierBasedIDs;
    private final String[] m_types;
    private String m_defSchema;
    private Map<String, DBObject> m_templates;
    private Collection<String> m_builtInSchemaNames;

    public DummyDBObjectProvider(String name, DatabaseDescriptor descriptor) {
        this(name, descriptor, true);
    }

    public DummyDBObjectProvider(String name, String dbType, int dbVersion) {
        this(name, DatabaseRegistry.getInstance().getDatabaseDescriptor(dbType, dbVersion), true);
    }

    public DummyDBObjectProvider(String name, DatabaseDescriptor descriptor, boolean useIdentifierBasedIDs) {
        this.m_name = name;
        this.m_desc = new DummyDescriptor(descriptor);
        this.m_useIdentifierBasedIDs = useIdentifierBasedIDs;
        TreeSet<String> types = new TreeSet<String>();
        Map map = this.m_desc.getValidators((DBObjectProvider)this);
        for (Map.Entry entry : map.entrySet()) {
            String type = (String)entry.getKey();
            this.registerValidator(type, (DBObjectValidator)entry.getValue());
            if (!Metadata.getInstance().isTypeOf(SystemObject.class, type)) continue;
            types.add(type);
        }
        this.m_types = types.toArray(new String[types.size()]);
        this.m_builtInSchemaNames = new ArrayList<String>();
        Collection schemas = this.m_desc.listBuiltInObjects(new DBObjectCriteria(Schema.class, new String[0]));
        for (Schema schema : schemas) {
            try {
                schema = (Schema)schema.copyTo(null, false);
                this.createSchema(schema, false);
                Collection builtIns = this.m_desc.listBuiltInObjects(DBObjectCriteria.createCriteria((String)"TYPE", (Schema)schema, null));
                DBObjectTransaction txn = new DBObjectTransaction((DBObjectProvider)this);
                for (SystemObject obj : builtIns) {
                    txn.includeUpdate(null, (SystemObject)obj.copyTo(null, false));
                }
                this.commitTransaction(txn);
                this.m_builtInSchemaNames.add(schema.getName());
            }
            catch (DBException e) {
                DBLog.getLogger((Object)((Object)this)).log(Level.WARNING, "Couldn't setup built in objects", e);
            }
        }
    }

    public String getProviderType() {
        return PROVIDER_TYPE;
    }

    public Object getProviderIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public DatabaseDescriptor getDescriptor() {
        return this.m_desc;
    }

    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine((boolean)true);
    }

    public String[] listObjectTypes() {
        return Arrays.copyOf(this.m_types, this.m_types.length);
    }

    public boolean canCreate(SystemObject object, boolean replace) {
        if (!replace) {
            try {
                return DBUtil.getProviderDefinition((DBObject)object, (DBObjectProvider)this) == null;
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.WARNING, "Couldn't check create permissions:  " + dbe.getMessage());
            }
        }
        return true;
    }

    public void createObjects(SystemObject[] objects, boolean replace) throws DBException {
        this.updateObjects(this.getDiffEngine().difference((Object)new SystemObject[objects.length], (Object)objects), replace, false);
    }

    private void replaceReferenceIDs(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        obj.replaceReferenceIDs(idMap);
        for (DBObjectID dBObjectID : obj.getReferenceIDs()) {
            if (!(dBObjectID instanceof TemporaryObjectID)) continue;
            DBObjectID real = TemporaryObjectID.findOriginalID((TemporaryObjectID)((TemporaryObjectID)dBObjectID));
            if (real == null) {
                try {
                    DBObject realObj;
                    DBObject tempObj = dBObjectID.resolveID();
                    if (tempObj != null && (realObj = DBUtil.getProviderDefinition((DBObject)tempObj, (DBObjectProvider)this)) != null) {
                        real = realObj.getID();
                    }
                }
                catch (DBException dbe) {
                    this.getLogger().warning("Couldn't lookup original object: " + dbe.getMessage());
                }
            }
            if (real == null) continue;
            obj.replaceReferenceIDs(Collections.singletonMap(dBObjectID, real));
            idMap.put(dBObjectID, real);
        }
        for (DBObjectID dBObjectID : obj.getOwnedObjects()) {
            this.replaceReferenceIDs((DBObject)dBObjectID, idMap);
        }
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        DBObjectSet retval = new DBObjectSet();
        Collection types = criteria.getTypes();
        if (criteria.isUserOnly() && types.contains("SCHEMA")) {
            for (SystemObject so : this.listObjectsFromCache(criteria)) {
                if (so instanceof Schema && this.m_builtInSchemaNames.contains(so.getName())) continue;
                retval.add(so);
            }
        } else {
            retval.addAll(this.listObjectsFromCache(criteria));
        }
        return retval;
    }

    public void deleteObjects(SystemObject[] objects, boolean cascade) throws DBException {
        this.updateObjects(this.getDiffEngine().difference((Object)objects, (Object)new SystemObject[objects.length]), false, cascade);
    }

    public void undeleteObject(SchemaObject object) throws DBException {
        throw new UnsupportedOperationException("undelete not supported");
    }

    public void undeleteObjects(SchemaObject[] objects) throws DBException {
        throw new UnsupportedOperationException("undelete not supported");
    }

    public boolean canDelete(SystemObject object, boolean cascade) {
        return true;
    }

    public boolean canDelete(Schema schema, boolean cascade) {
        return true;
    }

    protected Collection<DBObjectChange> commitTransaction(DBObjectTransaction txn, Difference listDiff) throws DBException {
        ArrayList<DBObjectChange> events = new ArrayList<DBObjectChange>();
        if (listDiff.getOriginalObject() instanceof SystemObject[]) {
            SystemObject original;
            DBObjectSet objects = new DBObjectSet();
            DBObjectSet added = new DBObjectSet();
            DBObjectSet removed = new DBObjectSet();
            DBObjectIDSet removedIDs = new DBObjectIDSet(true);
            ArrayList<Difference> updates = new ArrayList<Difference>();
            for (Difference objDiff : listDiff.getChildren()) {
                original = (SystemObject)objDiff.getOriginalObject();
                SystemObject update = (SystemObject)objDiff.getUpdatedObject();
                if (update == null) {
                    if (original == null) continue;
                    removed.add(original);
                    continue;
                }
                if (original == null) {
                    SystemObject existing = (SystemObject)DBUtil.getProviderDefinition((DBObject)update, (DBObjectProvider)this);
                    if (existing != null) {
                        if (txn.isReplace()) {
                            this.uncacheObject(existing);
                        } else {
                            throw new NameInUseException((DBObject)update);
                        }
                    }
                    if (update instanceof SchemaObject) {
                        Schema realSchema;
                        Schema s = ((SchemaObject)update).getSchema();
                        Schema schema = realSchema = s == null ? null : this.getSchema(s.getName());
                        if (s == null && s instanceof SchemaObject) {
                            throw new ValidationException((DBObject)update, "Object must have a Schema");
                        }
                        if (s != null && realSchema == null) {
                            throw new ValidationException((DBObject)update, "Schema does not exist");
                        }
                    }
                    objects.add(update);
                    added.add(update);
                    continue;
                }
                updates.add(objDiff);
            }
            for (SystemObject obj : removed) {
                this.uncacheObject(obj);
            }
            for (Difference d : updates) {
                original = (SystemObject)d.getOriginalObject();
                this.uncacheObject(original);
                DifferenceApplier rsa = new DifferenceApplier((DBObjectProvider)this);
                rsa.apply(d);
                objects.add(original);
                for (DBObjectChange doc : rsa.getEvents()) {
                    events.add(doc);
                }
            }
            this.getObjectFactory().ensureIDs((Collection)objects, listDiff);
            for (SystemObject so : objects) {
                this.cacheObject(so, false);
            }
            this.fireObjectsAdded((Collection)added);
            for (DBObjectChange doc : events) {
                this.fireObjectUpdated(doc);
            }
        }
        return events;
    }

    protected void cacheObject(SystemObject object, boolean loadOperation) {
        super.cacheObject(object, loadOperation);
        if (object instanceof Table && this.supportsObjectType("INDEX")) {
            for (Index idx : ((Table)object).getIndexes()) {
                super.cacheObject((SystemObject)idx, loadOperation);
            }
        }
    }

    public Schema getDefaultSchema() throws DBException {
        Schema[] schemas;
        Schema retval = null;
        if (ModelUtil.hasLength((String)this.m_defSchema)) {
            retval = this.getSchema(this.m_defSchema);
        }
        if (retval == null && (schemas = this.listSchemas(false)) != null && schemas.length > 0) {
            retval = schemas[0];
        }
        return retval;
    }

    public void setDefaultSchema(String name) {
        this.m_defSchema = name;
    }

    public void createSchema(Schema schema, boolean replace) throws DBException {
        this.createObject((SystemObject)schema, replace);
        if (this.m_builtInSchemaNames.contains(schema.getName())) {
            this.m_builtInSchemaNames.remove(schema.getName());
        }
        this.fireObjectsAdded(Collections.singleton(schema));
    }

    public void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        String name = newSchema.getName();
        Schema realOldSchema = this.getSchema(name);
        if (realOldSchema == null) {
            throw new DBException((DBObject)newSchema, "Schema " + name + " doesn't exist to update.");
        }
        Difference rs = this.getDiffEngine().difference((Object)realOldSchema, (Object)newSchema);
        if (!rs.isSame()) {
            DifferenceApplier rsa = new DifferenceApplier((DBObjectProvider)this);
            rsa.apply(rs);
            for (DBObjectChange doc : rsa.getEvents()) {
                this.fireObjectUpdated(doc);
            }
        }
    }

    public void deleteSchema(Schema schema, boolean cascade) throws DBException {
        String name = schema.getName();
        if (this.getSchema(name) == null) {
            throw new DBException((DBObject)schema, "Schema " + name + " doesn't exist to delete.");
        }
        this.deleteObject((SystemObject)schema, cascade);
        this.fireObjectsRemoved(Collections.singleton(schema));
    }

    protected DBObject resolveID(DBObjectID id) throws DBException {
        DBObject retval = super.resolveID(id);
        if (retval == null) {
            if (id instanceof NameBasedID) {
                retval = this.getObject(((NameBasedID)id).getType(), new Schema(((NameBasedID)id).getSchemaName()), ((NameBasedID)id).getName());
            } else if (id instanceof IdentifierBasedID && "INDEX".equals(id.getType())) {
                retval = ((IdentifierBasedID)id).resolveFromParent();
            }
        }
        return retval;
    }

    public void setDefaultTemplateForType(String type, DBObject template) {
        if (template == null) {
            if (this.m_templates != null) {
                this.m_templates.remove(type);
            }
        } else {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (clz == null || !clz.isAssignableFrom(template.getClass())) {
                throw new IllegalArgumentException("Invalid template for type " + type);
            }
            this.m_templates = new TreeMap<String, DBObject>();
            this.m_templates.put(type, template);
        }
    }

    public DBObject getDefaultTemplateForType(String type) {
        return this.m_templates == null ? null : this.m_templates.get(type);
    }

    protected DBObjectFactory createObjectFactory() {
        return new DummyObjectFactory(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DummyDescriptor
    extends DatabaseDescriptor {
        public DummyDescriptor(DatabaseDescriptor base) {
            super(base);
        }

        public void validateName(String type, String name) throws InvalidNameException {
            this.getBaseDescriptor().validateName(type, name);
        }

        public Map getValidators(DBObjectProvider pro) {
            return this.getBaseDescriptor().getValidators(pro);
        }

        public int getMaxNameLength(String type) {
            return this.getBaseDescriptor().getMaxNameLength(type);
        }

        public String getIdentifierQuoteString() {
            return this.getBaseDescriptor().getIdentifierQuoteString();
        }

        public int getDatabaseVersion() {
            return this.getBaseDescriptor().getDatabaseVersion();
        }

        public String getDatabaseType() {
            return this.getBaseDescriptor().getDatabaseType();
        }

        public int getCasePolicy() {
            return this.getBaseDescriptor().getCasePolicy();
        }

        public Collection<String> getReservedWords() {
            return this.getBaseDescriptor().getReservedWords();
        }

        public List<UpdateProcessor> getUpdateProcessors() {
            List retval = this.getBaseDescriptor().getUpdateProcessors();
            retval.add(new CascadeProcessor());
            return retval;
        }

        public DBObjectLister getTriggerLister(DBObjectProvider pro) {
            return pro.supportsObjectType("TRIGGER") ? new CascadeTriggerLister(pro) : null;
        }
    }

    private class DummyObjectFactory
    extends DBObjectFactory {
        DummyObjectFactory(DummyDBObjectProvider pro) {
            super((DBObjectProvider)pro);
        }

        protected boolean useIdentifierBasedIDs(DBObject obj) {
            return DummyDBObjectProvider.this.m_useIdentifierBasedIDs;
        }
    }
}

