/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerTableBuilder
extends JdbcTableBuilder<Table> {
    public SQLServerTableBuilder(SQLServerDatabaseImpl db) {
        super(db, null);
    }

    @Override
    protected void buildCCs(final Table rel) throws DBException {
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select c.name,\n       c.definition\nfrom sys.check_constraints c,\n     sys.objects t\nwhere c.parent_object_id = t.object_id\n  and SCHEMA_NAME(t.schema_id) = ?\n  and t.name like (?)\n", new Object[]{rel.getSchema(), rel.getName()});
        wrap.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        CheckConstraint con = (CheckConstraint)SQLServerTableBuilder.this.getProvider().getObjectFactory().newObject(CheckConstraint.class, (DBObject)rel);
                        String ccName = rs.getString(1);
                        con.setName(ccName);
                        String ccCondition = rs.getString(2);
                        int start = ccCondition.indexOf(40) + 1;
                        int end = ccCondition.lastIndexOf(41);
                        String stripped = ccCondition.substring(start, end).replaceAll("[\\[\\]]", "");
                        con.setCheckCondition(stripped);
                        con.setID((DBObjectID)new NameBasedID("CONSTRAINT", ccName, rel.getID()));
                        rel.addConstraint((Constraint)con);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)rel, sqe);
                }
            }
        });
    }

    @Override
    protected void buildUKs(final Table rel) throws DBException {
        final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), "select i.name,\n       c.name\nfrom sys.objects t,\n     sys.indexes i,\n     sys.index_columns ic,\n     sys.columns c\nwhere i.object_id = t.object_id\n  and ic.object_id = i.object_id\n  and i.index_id = ic.index_id\n  and c.object_id = t.object_id\n  and ic.column_id = c.column_id\n  and i.is_unique_constraint = 'true'\n  and SCHEMA_NAME(t.schema_id) = ?\n  and t.name like (?)\n", new Object[]{rel.getSchema(), rel.getName()});
        wrap.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                HashMap<String, UniqueConstraint> map = new HashMap<String, UniqueConstraint>();
                try {
                    while (rs.next()) {
                        Column col;
                        String name = rs.getString(1);
                        UniqueConstraint uc = (UniqueConstraint)map.get(name);
                        if (uc == null) {
                            uc = (UniqueConstraint)SQLServerTableBuilder.this.getProvider().getObjectFactory().newObject(UniqueConstraint.class, (DBObject)rel);
                            uc.setName(name);
                            uc.setID((DBObjectID)new NameBasedID("CONSTRAINT", name, rel.getID()));
                            rel.addConstraint((Constraint)uc);
                            map.put(name, uc);
                        }
                        if ((col = rel.getColumn(rs.getString(2))) == null) continue;
                        uc.addColumn(col);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)rel, sqe);
                }
            }
        });
    }
}

