/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;

@Deprecated
public class Trigger
extends PlSql {
    public static final String TYPE = "TRIGGER";
    public static final String INSERT_EVENT = "INSERT";
    public static final String DELETE_EVENT = "DELETE";
    public static final String UPDATE_EVENT = "UPDATE";
    public static final String ALTER_EVENT = "ALTER";
    public static final String ANALYZE_EVENT = "ANALYZE";
    public static final String ASSOCIATE_STATISTICS_EVENT = "ASSOCIATE STATISTICS";
    public static final String AUDIT_EVENT = "AUDIT";
    public static final String COMMENT_EVENT = "COMMENT";
    public static final String CREATE_EVENT = "CREATE";
    public static final String DISASSOCIATE_STATISTICS_EVENT = "DISASSOCIATE STATISTICS";
    public static final String DB_ROLE_CHANGE_EVENT = "DB_ROLE_CHANGE";
    public static final String DROP_EVENT = "DROP";
    public static final String GRANT_EVENT = "GRANT";
    public static final String NOAUDIT_EVENT = "NOAUDIT";
    public static final String RENAME_EVENT = "RENAME";
    public static final String REVOKE_EVENT = "REVOKE";
    public static final String TRUNCATE_EVENT = "TRUNCATE";
    public static final String DDL_EVENT = "DDL";
    public static final String SERVERERROR_EVENT = "SERVERERROR";
    public static final String LOGON_EVENT = "LOGON";
    public static final String LOGOFF_EVENT = "LOGOFF";
    public static final String STARTUP_EVENT = "STARTUP";
    public static final String SHUTDOWN_EVENT = "SHUTDOWN";
    public static final String SUSPEND_EVENT = "SUSPEND";
    private static final List TABLE_EVENTS = Collections.unmodifiableList(Arrays.asList("INSERT", "DELETE", "UPDATE"));
    private static final List BEFORE_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List BEFORE_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "SHUTDOWN", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "STARTUP", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL", "DB_ROLE_CHANGE"));
    private static final List DATABASE_ONLY_EVENTS = Collections.unmodifiableList(Arrays.asList("SERVERERROR", "LOGON", "LOGOFF", "STARTUP", "SHUTDOWN", "SUSPEND"));

    public static boolean isDatabaseOnlyEvent(String event) {
        return DATABASE_ONLY_EVENTS.contains(event);
    }

    public static List getEvents(BaseType type, Timing timing) {
        List list;
        if (timing == Timing.INSTEAD_OF && type != BaseType.VIEW) {
            list = Collections.EMPTY_LIST;
        } else {
            switch (type) {
                case TABLE: 
                case VIEW: {
                    list = TABLE_EVENTS;
                    break;
                }
                case SCHEMA: {
                    list = timing == Timing.BEFORE ? BEFORE_SCHEMA_EVENTS : AFTER_SCHEMA_EVENTS;
                    break;
                }
                case DATABASE: {
                    list = timing == Timing.BEFORE ? BEFORE_DB_EVENTS : AFTER_DB_EVENTS;
                    break;
                }
                default: {
                    list = Collections.EMPTY_LIST;
                }
            }
        }
        return list;
    }

    public Trigger() {
        this((Schema)null, (String)null);
    }

    public Trigger(Schema schema, String name) {
        super(name, schema);
        this.setStatementLevel(true);
        this.setEnabled(true);
    }

    public String getType() {
        return TYPE;
    }

    public boolean isEnabled() {
        return (Boolean)this.getProperty("enabled", true);
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", enabled);
    }

    public Timing getTiming() {
        return (Timing)((Object)this.getProperty("timing"));
    }

    public void setTiming(Timing timing) {
        this.setProperty("timing", (Object)timing);
    }

    public boolean isStatementLevel() {
        return (Boolean)this.getProperty("statementLevel", true);
    }

    public void setStatementLevel(boolean statementLevel) {
        this.setProperty("statementLevel", statementLevel);
    }

    public String[] getEvents() {
        return (String[])this.getChildSupport("events").getChildArray(String.class);
    }

    public void setEvents(String[] events) {
        this.getChildSupport("events").setChildArray((Object[])events);
    }

    public String getBaseSchemaName() {
        return (String)this.getProperty("baseSchemaName");
    }

    public void setBaseSchemaName(String baseSchemaName) {
        this.setProperty("baseSchemaName", baseSchemaName);
    }

    public void setBaseSchema(Schema schema) {
        this.setBaseSchemaName(schema == null ? null : schema.getName());
    }

    @Deprecated
    public Schema getTableOwner() {
        return new Schema(this.getBaseSchemaName());
    }

    @Transient
    @Deprecated
    public void setTableOwner(Schema owner) {
        this.setBaseSchema(owner);
    }

    @References(value=Table.class)
    public DBObjectID getTableID() {
        return (DBObjectID)this.getProperty("tableID");
    }

    public void setTableID(DBObjectID tableID) {
        this.setProperty("tableID", tableID);
    }

    public BaseType getBaseType() {
        return (BaseType)((Object)this.getProperty("baseType"));
    }

    public void setBaseType(BaseType baseType) {
        this.setProperty("baseType", (Object)baseType);
    }

    public String getWhenClause() {
        return (String)this.getProperty("whenClause");
    }

    public void setWhenClause(String whenClause) {
        this.setProperty("whenClause", whenClause);
    }

    @References(value=Column.class)
    public DBObjectID[] getColumnIDs() {
        return (DBObjectID[])this.getChildSupport("columnIDs").getChildArray(DBObjectID.class);
    }

    public void setColumnIDs(DBObjectID[] ids) {
        this.getChildSupport("columnIDs").setChildArray((Object[])ids);
    }

    public String getCode() {
        String code = (String)this.getProperty("code");
        return code == null ? null : code.trim();
    }

    public void setCode(String code) {
        this.setProperty("code", code);
    }

    public void setReferencingNewAs(String referencingNewAs) {
        this.setProperty("referencingNewAs", referencingNewAs);
    }

    public String getReferencingNewAs() {
        return (String)this.getProperty("referencingNewAs");
    }

    public void setReferencingOldAs(String referencingOldAs) {
        this.setProperty("referencingOldAs", referencingOldAs);
    }

    public String getReferencingOldAs() {
        return (String)this.getProperty("referencingOldAs");
    }

    @Deprecated
    public String[] getReferenceNames() {
        return new String[]{this.getReferencingOldAs(), this.getReferencingNewAs()};
    }

    @Deprecated
    @Transient
    public void setReferenceNames(String[] names) {
        if (names == null || names.length != 2) {
            throw new IllegalArgumentException("trigger reference names property must contain two names.");
        }
        this.setReferencingOldAs(names[0]);
        this.setReferencingNewAs(names[1]);
    }

    public String getSource() {
        return super.getSource();
    }

    public void setSource(String source) {
        super.setSource(source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaseType {
        TABLE,
        VIEW,
        SCHEMA,
        DATABASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Timing {
        BEFORE,
        AFTER,
        INSTEAD_OF;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

