/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

public class DB2ColumnValidator
extends ColumnValidator {
    public DB2ColumnValidator(DBObjectProvider prov) {
        super(prov, true);
    }

    @DBObjectValidator.PropertyValidator(value={"notNull"})
    public void validateNotNull(Column original, Column object) throws ValidationException {
        super.validateNotNull(original, object);
        if (!object.isNotNull()) {
            Relation r = object.getRelation();
            DBObjectID id = object.getID();
            if (r != null) {
                for (Constraint con : r.getConstraints()) {
                    UniqueConstraint uk;
                    if (!(con instanceof UniqueConstraint) || !(uk = (UniqueConstraint)con).isEnabled()) continue;
                    for (DBObjectID colID : uk.getColumnIDs()) {
                        if (!colID.equals(id)) continue;
                        throw new ValidationException((DBObject)object, APIBundle.format((String)"UK_ERROR_NOT_NULL_COL", (Object[])new Object[]{object.getName()}));
                    }
                }
            }
        }
    }
}

