/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.db2.DB2DatabaseDescriptor;
import oracle.javatools.db.db2.DB2UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v10UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v9DatabaseDescriptor;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;

public class DB2UniversalDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getUniversalConnectionType(conn);
        switch (t) {
            case 81: {
                return new DB2UniversalDatabaseImpl(connStore, connName, conn);
            }
            case 95: {
                return new DB2v9UniversalDatabaseImpl(connStore, connName, conn);
            }
            case 101: {
                return new DB2v10UniversalDatabaseImpl(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getUniversalConnectionType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.contains("DB2") || driverName.contains("IBM Data Server") || driverName.contains("AS/400") || driverName.contains("JDE World")) {
                    int v = dmd.getDatabaseMajorVersion();
                    if (v >= 10) {
                        return 101;
                    }
                    if (v == 9) {
                        return 95;
                    }
                    return 81;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        DB2DatabaseDescriptor retval = null;
        if (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(providerClass)) {
            retval = new DB2v9DatabaseDescriptor(providerClass);
        } else if (DB2UniversalDatabaseImpl.class.isAssignableFrom(providerClass)) {
            retval = new DB2DatabaseDescriptor(providerClass);
        }
        return retval;
    }
}

