/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.db2.DB2AliasBuilder;
import oracle.javatools.db.db2.DB2DictionaryQueries;
import oracle.javatools.db.db2.DB2SchemaBuilder;
import oracle.javatools.db.db2.DB2TableBuilder;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2ViewBuilder;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcDictionaryDatabase;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2v9UniversalDatabaseImpl
extends JdbcDictionaryDatabase
implements DB2UniversalDatabase {
    private DB2DictionaryQueries m_dictionary;

    protected DB2v9UniversalDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    public DictionaryQueries getDictionaryQueries() {
        if (this.m_dictionary == null) {
            this.m_dictionary = new DB2DictionaryQueries(this);
        }
        return this.m_dictionary;
    }

    @Override
    protected void registerBuilders() {
        this.registerBuilder("SCHEMA", (DBObjectBuilder)new DB2SchemaBuilder(this, this.getCatalog()));
        this.registerBuilder("TABLE", (DBObjectBuilder)new DB2TableBuilder(this, this.getCatalog()));
        this.registerBuilder("VIEW", (DBObjectBuilder)new DB2ViewBuilder(this, this.getCatalog()));
        this.registerBuilder("ALIAS", (DBObjectBuilder)new DB2AliasBuilder(this));
    }

    public boolean supportsTimestamps(String objectType) {
        return false;
    }

    protected final boolean isCurrentUser(Schema schema) {
        return schema != null && ModelUtil.areEqual((Object)this.getUserName(), (Object)schema.getName());
    }

    protected <T extends SystemObject> T checkCachedObject(T object) throws DBException {
        Object retval = object instanceof Schema && this.isCurrentUser((Schema)object) ? object : super.checkCachedObject(object);
        return (T)retval;
    }

    protected String queryCurrentSchemaName() throws DBException {
        QueryWrapper wrap = new QueryWrapper((Database)this, "select strip(current_schema,T) from sysibm.sysdummy1");
        return wrap.executeSingleCellQuery();
    }
}

