/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.derby.DerbySynonymBuilder;
import oracle.javatools.db.derby.DerbyTableBuilder;
import oracle.javatools.db.derby.DerbyViewBuilder;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

public class DerbyDatabaseImpl
extends JdbcDDLDatabase
implements DerbyDatabase {
    protected DerbyDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected boolean alwaysIncludeDefaultSchema() {
        return true;
    }

    protected String queryCurrentSchemaName() throws DBException {
        QueryWrapper wrap = new QueryWrapper((Database)this, "SELECT current schema FROM sys.sysschemas");
        return wrap.executeSingleCellQuery();
    }

    public boolean catalogIsSchema() {
        return false;
    }

    protected void registerBuilders() {
        this.registerBuilder("TABLE", (DBObjectBuilder)new DerbyTableBuilder(this, this.getCatalog()));
        this.registerBuilder("VIEW", (DBObjectBuilder)new DerbyViewBuilder(this));
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new DerbySynonymBuilder(this));
    }

    protected void processDeleteException(DBException dbe, SystemObject object) throws DBException {
        String state;
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException && ("X0Y23".equals(state = ((SQLException)cause).getSQLState()) || "X0Y25".equals(state))) {
            throw new CascadeRequiredException((DBObject)object, ((SQLException)cause).getMessage());
        }
        throw dbe;
    }

    public boolean isUnsupportedOperation(SQLException sqe) {
        String state = sqe.getSQLState();
        return "XJZZZ".equals(state) || super.isUnsupportedOperation(sqe);
    }
}

